/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;

public class SSBIndexOraclev9i
extends AbstractSSBOracle {
    private StorageDesignOraclev9i storageDesign;
    private Object sType;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxyOracle && ((IndexProxyOracle)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        Index index = null;
        IndexProxyOraclev9i indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            Design design = index.getDesign();
            RDBMSSite site = index.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(site);
            indexProxy = (IndexProxyOraclev9i)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyOraclev9i) {
            indexProxy = (IndexProxyOraclev9i)object;
            index = (Index)indexProxy.getObject();
        }
        if (index != null && !index.isOidKey() && indexProxy != null) {
            this.storageDesign = (StorageDesignOraclev9i)indexProxy.getStorageDesign();
            if (index.getElements().length > 0 || index.hasIndexExpression()) {
                if (indexProxy.isMarkedGenerate()) {
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, indexProxy);
                    } else {
                        this.appendComment(oldbuffer, index);
                    }
                    String indName = indexProxy.getName();
                    if (indName.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "CREATE");
                    if (indexProxy.isUnique()) {
                        SSBIndexOraclev9i.appendStringWithSpace(buffer, "UNIQUE");
                    } else if (indexProxy.getBitmapIndex()) {
                        SSBIndexOraclev9i.appendStringWithSpace(buffer, "BITMAP");
                    }
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "INDEX");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(indexProxy));
                    advancedComment = buffer.toString();
                    this.appendTable(buffer, indexProxy);
                    this.appendElementList(buffer, index, indexProxy, true);
                    if (!index.isSpatialIndex() && indexProxy.getIndexType().equals("")) {
                        this.appendGlobalOrLocal(buffer, indexProxy, prettyPrint);
                        this.appendIndexAttributes(buffer, indexProxy, prettyPrint);
                    }
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                }
            } else {
                SSBIndexOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                oldbuffer.append("-- Error - Index ");
                oldbuffer.append(this.storageDesign.getFormatedName(index));
                oldbuffer.append(" has no columns");
                SSBIndexOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendTable(StringBuffer buffer, IndexProxy indexProxy) {
        TableProxy tableProxy = indexProxy.getTableProxy();
        SSBIndexOraclev9i.appendStringWithSpace(buffer, "ON");
        SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
    }

    private void appendElementList(StringBuffer buffer, Index index, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if (index.hasIndexExpression()) {
            SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
            SSBIndexOraclev9i.appendString(buffer, index.getIndexExpression());
            SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
        } else {
            ColumnProxy column = null;
            ColumnProxy[] columns = indexProxy.getColumnProxies();
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if (columns.length < 1) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "-- No Columns");
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < columns.length; ++i) {
                if (i != 0) {
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, ',');
                }
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                column = columns[i];
                SSBIndexOraclev9i.appendString(buffer, ' ');
                String columnName = this.storageDesign.getFormatedName(column);
                if (index.isSpatialIndex()) {
                    Datatype colType = column.getDataType();
                    if (this.sType == null) {
                        this.sType = column.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                    }
                    if (colType instanceof StructuredType) {
                        StructuredType st = (StructuredType)colType;
                        for (TypeElement te : st.getAllElements()) {
                            if (te.getType() != this.sType) continue;
                            columnName = columnName.concat(".").concat(this.storageDesign.getFormatedName(te));
                            break;
                        }
                    }
                }
                SSBIndexOraclev9i.appendStringWithSpace(buffer, columnName);
                if (index.isSpatialIndex() || !indexProxy.getIndexType().equals("")) continue;
                SSBIndexOraclev9i.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
        if (indexProxy != null) {
            if (index.isSpatialIndex()) {
                this.appendSpatialIndex(buffer, index, indexProxy, prettyPrint);
            } else {
                this.appendDomainIndexProps(buffer, index, indexProxy, prettyPrint);
            }
        }
    }

    private void appendDomainIndexProps(StringBuffer buffer, Index index, IndexProxyOracle indexProxy, boolean prettyPrint) {
        String type;
        if (!index.isSpatialIndex() && !(type = indexProxy.getIndexType()).equals("")) {
            if (!type.equalsIgnoreCase("XMLINDEX") && !type.equalsIgnoreCase("XDB.XMLINDEX")) {
                type = this.storageDesign.getFormatedName(type);
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "INDEXTYPE");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "IS");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, type);
            String params = indexProxy.getIndexDomainParameters();
            if (!params.equals("")) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
                SSBIndexOraclev9i.appendString(buffer, '(');
                SSBIndexOraclev9i.appendString(buffer, '\'');
                SSBIndexOraclev9i.appendString(buffer, params);
                SSBIndexOraclev9i.appendString(buffer, '\'');
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendSpatialIndex(StringBuffer buffer, Index index, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if (index.isSpatialIndex()) {
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "INDEXTYPE");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "IS");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "MDSYS.SPATIAL_INDEX");
            if (!index.getGeodetic().equals("YES") || indexProxy.getTableSpace() != null || index.getLayerType() != null && !index.getLayerType().equals("") || index.getDimensionsNumber() != 2) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
                SSBIndexOraclev9i.appendString(buffer, '(');
                SSBIndexOraclev9i.appendString(buffer, '\'');
                if (!index.getGeodetic().equals("YES")) {
                    SSBIndexOraclev9i.appendString(buffer, "geodetic");
                    SSBIndexOraclev9i.appendString(buffer, '=');
                    this.appendString(buffer, Boolean.FALSE);
                }
                if (index.getLayerType() != null && !index.getLayerType().equals("")) {
                    SSBIndexOraclev9i.appendSpace(buffer);
                    SSBIndexOraclev9i.appendString(buffer, "layer_gtype");
                    SSBIndexOraclev9i.appendString(buffer, '=');
                    SSBIndexOraclev9i.appendString(buffer, index.getLayerType());
                }
                if (index.getDimensionsNumber() != 2) {
                    SSBIndexOraclev9i.appendSpace(buffer);
                    SSBIndexOraclev9i.appendString(buffer, "sdo_indx_dims");
                    SSBIndexOraclev9i.appendString(buffer, '=');
                    this.appendString(buffer, index.getDimensionsNumber());
                }
                if (indexProxy.getTableSpace() != null) {
                    SSBIndexOraclev9i.appendSpace(buffer);
                    SSBIndexOraclev9i.appendString(buffer, "tablespace=");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableSpace()));
                }
                SSBIndexOraclev9i.appendString(buffer, '\'');
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
            this.appendSpatialIndexPartitions(buffer, indexProxy, prettyPrint);
        }
    }

    private void appendSpatialIndexPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if ("LOCAL".equalsIgnoreCase(indexProxy.getIndexPartitioned())) {
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "LOCAL");
            TableProxyOraclev9i tableProxy = (TableProxyOraclev9i)indexProxy.getTableProxy();
            PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
            if (partitionList != null) {
                this.appendSpatialPartitions(buffer, indexProxy, partitionList, prettyPrint);
            }
        }
    }

    private void appendSpatialPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, PartitionListOraclev9i partitionList, boolean prettyPrint) {
        PartitionSetOraclev9i partitionSet = (PartitionSetOraclev9i)((StorageDesignOraclev9i)partitionList.getStorageDesign()).getPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            SegmentOraclev9i indexSegment;
            PartitionOraclev9i partition = (PartitionOraclev9i)setIt.next();
            if (partition.getPartitionList() == null || !partition.getPartitionList().getObjectID().equalsIgnoreCase(partitionList.getObjectID())) continue;
            if (first) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                first = false;
            } else {
                buffer.append(',');
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex((IndexProxyOracle)indexProxy, partition);
            if (lip != null && !"".equalsIgnoreCase(lip.getPartitionName())) {
                pName = lip.getPartitionName();
                formattedPName = this.storageDesign.getFormatedName(pName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
            SSBIndexOraclev9i.appendString(buffer, '(');
            SSBIndexOraclev9i.appendString(buffer, '\'');
            if (lip.getTableSpace() != null) {
                SSBIndexOraclev9i.appendString(buffer, "tablespace = ");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lip.getTableSpace()));
            }
            if ((indexSegment = (SegmentOraclev9i)lip.getSegment()) != null) {
                SSBIndexOraclev9i.appendSpace(buffer);
                SSBIndexOraclev9i.appendString(buffer, "sdo_rdr_pctfree=");
                this.appendString(buffer, indexSegment.getPCTFree());
                if (indexSegment.getSCInitialExtent() > 0L) {
                    SSBIndexOraclev9i.appendSpace(buffer);
                    SSBIndexOraclev9i.appendString(buffer, "initial=");
                    this.appendString(buffer, indexSegment.getSCInitialExtent());
                }
                if (indexSegment.getSCNextExtent() > 0L) {
                    SSBIndexOraclev9i.appendSpace(buffer);
                    SSBIndexOraclev9i.appendString(buffer, "next=");
                    this.appendString(buffer, indexSegment.getSCNextExtent());
                }
                SSBIndexOraclev9i.appendSpace(buffer);
                SSBIndexOraclev9i.appendString(buffer, "pctincrease=");
                this.appendStringWithSpace(buffer, indexSegment.getSCPctIncrease());
                SSBIndexOraclev9i.appendSpace(buffer);
                SSBIndexOraclev9i.appendString(buffer, "minextents=");
                this.appendStringWithSpace(buffer, indexSegment.getSCMinExtents());
                SSBIndexOraclev9i.appendSpace(buffer);
                SSBIndexOraclev9i.appendString(buffer, "maxextents=");
                SSBIndexOraclev9i.appendString(buffer, indexSegment.getSCMaxExtents());
            }
            if (lip.getLayerType() != null && !lip.getLayerType().equals("")) {
                SSBIndexOraclev9i.appendSpace(buffer);
                SSBIndexOraclev9i.appendString(buffer, "layer_gtype=");
                SSBIndexOraclev9i.appendString(buffer, lip.getLayerType());
            }
            SSBIndexOraclev9i.appendString(buffer, '\'');
            SSBIndexOraclev9i.appendString(buffer, ')');
        }
        if (!first) {
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendString(buffer, ')');
        }
    }

    private void appendGlobalOrLocal(StringBuffer buffer, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if ("GLOBAL".equalsIgnoreCase(indexProxy.getIndexPartitioned())) {
            IndexGlobalPartitionsListOraclev9i globalPartitionList = (IndexGlobalPartitionsListOraclev9i)indexProxy.getIndexGlobalPartitionsList();
            if (globalPartitionList != null) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "GLOBAL");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "RANGE");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(globalPartitionList.getGlobalPartColumns()));
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendGlobalPartitions(buffer, indexProxy, prettyPrint);
            }
        } else if ("LOCAL".equalsIgnoreCase(indexProxy.getIndexPartitioned())) {
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "LOCAL");
            this.appendPartitionList(buffer, indexProxy, (TableProxyOraclev9i)indexProxy.getTableProxy(), prettyPrint);
        }
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        Iterator it = indexProxy.getGlobalPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            IndexGlobalPartitionOraclev9i globalPartition = (IndexGlobalPartitionOraclev9i)it.next();
            if (first) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "VALUES LESS THAN");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
            SSBIndexOraclev9i.appendStringWithSpace(buffer, globalPartition.getValueList());
            SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
            if (globalPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            this.appendSegment(buffer, (SegmentOraclev9i)globalPartition.getSegment(), prettyPrint);
            if (!this.storageDesign.isOpen() || !this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev9i segment, boolean prettyPrint) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "PCTFREE");
                this.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    this.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "2");
                }
                if (segment.getMaxTrans() > 2) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                    this.appendStringWithSpace(buffer, segment.getMaxTrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "255");
                }
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "STORAGE");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                this.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                this.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                this.appendStringWithSpace(buffer, segment.getSCMinExtents());
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                this.appendStringWithSpace(buffer, segment.getSCFreeLists());
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                this.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        boolean temporaryTable = tableProxy.getTemporary().equalsIgnoreCase("YES");
        if (!temporaryTable) {
            if (indexProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableSpace()));
            }
            this.appendSegment(buffer, (SegmentOraclev9i)indexProxy.getSegment(), prettyPrint);
        }
        if (this.storageDesign.isOpen()) {
            if (!temporaryTable && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(indexProxy.getLogging())) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(indexProxy.getLogging())) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            if ("YES".equalsIgnoreCase(indexProxy.getOnline())) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "ONLINE");
            }
            if ("YES".equalsIgnoreCase(indexProxy.getComputeStatistics())) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
            if (indexProxy.getCompress() > 0) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
                this.appendStringWithSpace(buffer, indexProxy.getCompress());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (!indexProxy.getBitmapIndex()) {
                if ("NO".equalsIgnoreCase(indexProxy.getSortedRows())) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "NOSORT");
                } else if ("REVERSE".equalsIgnoreCase(indexProxy.getSortedRows())) {
                    buffer.append(NEWLINE).append("    ");
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBIndexOraclev9i.appendStringWithSpace(buffer, "SORT");
                    }
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "REVERSE");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "SORT");
                }
            }
            if (!temporaryTable) {
                if ("YES".equalsIgnoreCase(indexProxy.getParallel())) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
                    if (!"".equalsIgnoreCase(indexProxy.getDegree())) {
                        SSBIndexOraclev9i.appendStringWithSpace(buffer, indexProxy.getDegree());
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
                }
            }
        }
    }

    private void appendPartitionList(StringBuffer buffer, IndexProxyOraclev9i indexProxy, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, indexProxy, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) {
                String subPartitionTableSpaceIDs = indexProxy.getHashSubPartitionsTableSpaces();
                if (!"".equals(subPartitionTableSpaceIDs.trim())) {
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
                }
                this.appendPartitions(buffer, indexProxy, partitionList, true, prettyPrint);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, indexProxy, partitionList, true, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType) || "HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                this.appendHashPartitions(buffer, partitionList, indexProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                this.appendListPartitions(buffer, partitionList, indexProxy, prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)it.next();
            if (first) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex((IndexProxyOracle)indexProxy, partition);
            if (lip != null && !"".equalsIgnoreCase(lip.getPartitionName())) {
                pName = lip.getPartitionName();
                formattedPName = this.storageDesign.getFormatedName(pName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)lip.getTableSpace();
            String logging = lip.getLogging();
            SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
            if (indexSegment != null) {
                this.appendSegment(buffer, indexSegment, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (ts != null) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                }
            }
            if (!this.storageDesign.isOpen() || !this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(logging)) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(logging)) continue;
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, IndexProxyOraclev9i indexProxy, boolean prettyPrint) {
        if (partitionList.getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
            TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
            StorageObjectCollection partitions = tableProxy.getPartitions();
            Iterator it = partitions.iterator();
            boolean first = true;
            while (it.hasNext()) {
                TableSpaceOraclev9i ts;
                HashPartitionOraclev9i partition = (HashPartitionOraclev9i)it.next();
                if (first) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, ',');
                }
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                String pName = partition.getName();
                String formattedPName = this.storageDesign.getFormatedName(partition);
                LocalIndexProperties lip = this.getPropsForIndex((IndexProxyOracle)indexProxy, partition);
                if (lip != null && !"".equalsIgnoreCase(lip.getPartitionName())) {
                    pName = lip.getPartitionName();
                    formattedPName = this.storageDesign.getFormatedName(pName);
                }
                if (!pName.toUpperCase().startsWith("SYS_")) {
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
                }
                if (lip == null || (ts = (TableSpaceOraclev9i)lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (!first) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
        } else {
            String subPartitionTableSpaceIDs = indexProxy.getHashSubPartitionsTableSpaces();
            if (!"".equals(subPartitionTableSpaceIDs.trim())) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, PartitionListOraclev9i partitionList, boolean composite, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            PartitionOraclev9i partition = (PartitionOraclev9i)it.next();
            if (first) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex((IndexProxyOracle)indexProxy, partition);
            if (lip != null && !"".equalsIgnoreCase(lip.getPartitionName())) {
                pName = lip.getPartitionName();
                formattedPName = this.storageDesign.getFormatedName(pName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOracle ts = lip.getTableSpace();
            String logging = lip.getLogging();
            SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
            if (indexSegment != null) {
                this.appendSegment(buffer, indexSegment, prettyPrint);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (ts != null) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(logging)) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(logging)) {
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            if (!composite) continue;
            String tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            this.appendIndexSubPartitions(buffer, indexProxy, partitionList.getPartitionType(), partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            buffer.append("    ").append(')');
        }
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxy, PartitionOracle partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, indexProxy);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxy, HashPartitionOraclev9i partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, indexProxy);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxy, ListPartitionOraclev9i partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, indexProxy);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxy, ListStorageTemplatePartitionOraclev9i partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, indexProxy);
    }

    private void appendIndexSubPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, String partType, PartitionOraclev9i partition, String tablespaceIDs, boolean prettyPrint) {
        if (partType.equalsIgnoreCase("COMPOSITE BY HASH")) {
            if (!this.appendHashSubPartitions(buffer, indexProxy, partition, prettyPrint) && !"".equalsIgnoreCase(tablespaceIDs.trim())) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(tablespaceIDs));
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
        } else if (partType.equalsIgnoreCase("COMPOSITE BY LIST")) {
            this.appendListSubPartitions(buffer, indexProxy, partition, prettyPrint);
        }
    }

    private void appendListSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, PartitionOraclev9i partition, boolean prettyPrint) {
        boolean first = true;
        Iterator it = partition.getListPartitions().iterator();
        while (it.hasNext()) {
            TableSpaceOracle ts;
            ListStorageTemplatePartitionOraclev9i listPartition = (ListStorageTemplatePartitionOraclev9i)it.next();
            if (first) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            String lpName = listPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(listPartition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, listPartition);
            if (lip != null && !"".equalsIgnoreCase(lip.getPartitionName())) {
                lpName = lip.getPartitionName();
                formattedPName = this.storageDesign.getFormatedName(lpName);
            }
            if (!lpName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, IndexProxyOraclev9i indexProxy, PartitionOraclev9i partition, boolean prettyPrint) {
        boolean result = false;
        Iterator it = partition.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            TableSpaceOraclev9i ts;
            HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)it.next();
            if (first) {
                SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            String hpName = hashPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(hashPartition);
            LocalIndexProperties lip = this.getPropsForIndex((IndexProxyOracle)indexProxy, hashPartition);
            if (lip != null && !"".equalsIgnoreCase(lip.getPartitionName())) {
                hpName = lip.getPartitionName();
                formattedPName = this.storageDesign.getFormatedName(hpName);
            }
            if (!hpName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = (TableSpaceOraclev9i)lip.getTableSpace()) == null || !this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            buffer.append(')');
        }
        return result;
    }

    private void appendConstraintElementList(StringBuffer buffer, Index index, IndexProxy indexProxy, boolean prettyPrint) {
        ColumnProxy column = null;
        ColumnProxy[] columns = indexProxy.getColumnProxies();
        SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBIndexOraclev9i.appendStringWithSpace(buffer, "-- No Columns");
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexOraclev9i.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                SSBIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            column = columns[i];
            SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev9i.appendString(buffer, ' ');
            SSBIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
            SSBIndexOraclev9i.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
        }
        SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexOraclev9i.appendStringWithSpace(buffer, ')');
    }

    public void appendIndexForConstraint(StringBuffer oldbuffer, Index index, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        IndexProxy indexProxy = null;
        StorageDesignOraclev9i storageDesign = (StorageDesignOraclev9i)this.getStorageDesign(index);
        if ("Primary Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxyOracle)storageDesign.getPKProxySet().getProxy(index.getObjectID());
        } else if ("Unique Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxyOracle)storageDesign.getUniqueSet().getProxy(index.getObjectID());
        } else if (index.isFK()) {
            indexProxy = (FKProxyOracle)storageDesign.getFKProxySet().getProxy(index.getObjectID());
        }
        if (indexProxy != null && !index.isOidKey()) {
            this.storageDesign = (StorageDesignOraclev9i)indexProxy.getStorageDesign();
            if (indexProxy.isMarkedGenerate()) {
                if (index.getElements().length > 0) {
                    String tablespaceName;
                    ModelIDObject tableUser;
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, indexProxy);
                    } else {
                        this.appendComment(oldbuffer, index);
                    }
                    TableProxy tp = indexProxy.getTableProxy();
                    String indName = indexProxy.getName();
                    indName = ApplyNamingStandards.createIndexNameAuto(tp.getName(), indName, index, index.getDesign().getDesignLevelSettings().getNamingStandardRule(), index.getDesignPart().getName(), index.getTable().getAbbreviation());
                    if (indName.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    OracleIndexTemplate oit = null;
                    if (storageDesign.getAppView().getSettings().useOracleIndexTemplate()) {
                        oit = storageDesign.getAppView().getSettings().getOracleIndexTemplate();
                    }
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "CREATE");
                    if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                        SSBIndexOraclev9i.appendStringWithSpace(buffer, "UNIQUE");
                    } else if (oit != null && oit.isBitmapIndex()) {
                        SSBIndexOraclev9i.appendStringWithSpace(buffer, "BITMAP");
                    }
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, "INDEX");
                    if (storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && (tableUser = tp.getSchemaImplementingObject()) != null) {
                        SSBIndexOraclev9i.appendString(buffer, storageDesign.getFormatedName(tableUser));
                        SSBIndexOraclev9i.appendString(buffer, '.');
                    }
                    SSBIndexOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(indName));
                    advancedComment = buffer.toString();
                    this.appendTable(buffer, indexProxy);
                    this.appendConstraintElementList(buffer, index, indexProxy, true);
                    if (oit != null && (tablespaceName = oit.getTableSpace().trim()).length() > 0 && storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                        TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tablespaceName);
                        if (tablespace != null) {
                            SSBIndexOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(tablespace));
                        } else {
                            SSBIndexOraclev9i.appendStringWithSpace(buffer, storageDesign.getFormatedName(tablespaceName));
                        }
                    }
                    SSBIndexOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    oldbuffer.append("-- Error - Index ");
                    oldbuffer.append(storageDesign.getFormatedName(index));
                    oldbuffer.append(" has no columns");
                    SSBIndexOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (one instanceof PartitionOraclev9i && two instanceof PartitionOraclev9i) {
                if (((PartitionOraclev9i)one).getPosition() > ((PartitionOraclev9i)two).getPosition()) {
                    return 1;
                }
                if (((PartitionOraclev9i)one).getPosition() < ((PartitionOraclev9i)two).getPosition()) {
                    return -1;
                }
            } else if (one instanceof ListPartitionOraclev9i && two instanceof ListPartitionOraclev9i) {
                if (((ListPartitionOraclev9i)one).getPosition() > ((ListPartitionOraclev9i)two).getPosition()) {
                    return 1;
                }
                if (((ListPartitionOraclev9i)one).getPosition() < ((ListPartitionOraclev9i)two).getPosition()) {
                    return -1;
                }
            } else {
                return 0;
            }
            return 0;
        }
    }
}

