/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SequenceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSequenceOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SequenceOraclev9i sequence = (SequenceOraclev9i)object;
        this.storageDesign = sequence.getStorageDesign();
        this.appendComment(oldbuffer, sequence);
        SSBSequenceOraclev9i.appendStringWithSpace(buffer, "CREATE");
        SSBSequenceOraclev9i.appendStringWithSpace(buffer, "SEQUENCE");
        SSBSequenceOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(sequence));
        advancedComment = buffer.toString();
        this.appendStartWith(buffer, sequence);
        this.appendIncrementBy(buffer, sequence);
        this.appendMaxValue(buffer, sequence);
        this.appendMinValue(buffer, sequence);
        this.appendCycle(buffer, sequence);
        this.appendCache(buffer, sequence);
        this.appendOrder(buffer, sequence);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBSequenceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateSequence();
        this.appendPermissions(oldbuffer, sequence, prettyPrint);
        SSBSequenceOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SequenceOraclev9i && ((SequenceOraclev9i)object).isMarkedGenerate();
    }

    private void appendStartWith(StringBuffer buffer, SequenceOraclev9i sequence) {
        if (this.isNotEmpty(sequence.getStartWith())) {
            buffer.append(NEWLINE).append("    ");
            buffer.append("START WITH ").append(sequence.getStartWith());
        }
    }

    private void appendIncrementBy(StringBuffer buffer, SequenceOraclev9i sequence) {
        if (this.isNotEmpty(sequence.getIncrementBy())) {
            buffer.append(NEWLINE).append("    ");
            buffer.append("INCREMENT BY ").append(sequence.getIncrementBy());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE).append("    ");
            buffer.append("INCREMENT BY 1");
        }
    }

    private void appendMaxValue(StringBuffer buffer, SequenceOraclev9i sequence) {
        if (this.isNotEmpty(sequence.getMaxValue())) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "MAXVALUE");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, sequence.getMaxValue());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "NOMAXVALUE");
        }
    }

    private void appendMinValue(StringBuffer buffer, SequenceOraclev9i sequence) {
        if (this.isNotEmpty(sequence.getMinValue())) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "MINVALUE");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, sequence.getMinValue());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "NOMINVALUE");
        }
    }

    private void appendCycle(StringBuffer buffer, SequenceOraclev9i sequence) {
        if ("YES".equalsIgnoreCase(sequence.getCycle())) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "NOCYCLE");
        }
    }

    private void appendCache(StringBuffer buffer, SequenceOraclev9i sequence) {
        if ("YES".equals(sequence.getNoCache())) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "NOCACHE");
        } else if (this.isNotEmpty(sequence.getCache())) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "CACHE");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, sequence.getCache());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "CACHE");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "20");
        }
    }

    private void appendOrder(StringBuffer buffer, SequenceOraclev9i sequence) {
        if ("YES".equalsIgnoreCase(sequence.getOrder())) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "ORDER");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE).append("    ");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "NOORDER");
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, SequenceOraclev9i sequence, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Iterator it = ((StorageDesignOracle)this.storageDesign).getPermissionsSet().iterator();
        while (it.hasNext()) {
            PermissionsOraclev9i permissions = (PermissionsOraclev9i)it.next();
            if (permissions.getSequence() == null || !permissions.getSequence().equals(sequence)) continue;
            if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                SSBSequenceOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBSequenceOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                SSBSequenceOraclev9i.appendStringWithSpace(buffer, "GRANT");
                SSBSequenceOraclev9i.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions, prettyPrint);
                this.appendTo(buffer, permissions);
                advancedComment = buffer.toString();
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBSequenceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                SSBSequenceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            SSBSequenceOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBSequenceOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendComment(oldbuffer, permissions);
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions, prettyPrint);
            this.appendTo(buffer, permissions);
            this.appendGrantOption(buffer, permissions);
            advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBSequenceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBSequenceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev9i permissions, boolean prettyPrint) {
        SSBSequenceOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBSequenceOraclev9i.appendStringWithSpace(buffer, "ON");
        if (permissions.getSequence() != null) {
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getSequence()));
        }
    }

    private void appendTo(StringBuffer buffer, PermissionsOraclev9i privileges) {
        SSBSequenceOraclev9i.appendStringWithSpace(buffer, "TO");
        if ("YES".equalsIgnoreCase(privileges.getPublic())) {
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "PUBLIC");
        } else if (privileges.getUser() != null) {
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(privileges.getUser()));
        } else if (privileges.getRole() != null) {
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(privileges.getRole()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getRole() == null) {
            SSBSequenceOraclev9i.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

