/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.MethodProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StructuredTypeProxyOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStructuredTypeBodyOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StructuredTypeProxyOraclev9i typeProxy;
        if (object instanceof StructuredTypeProxyOraclev9i && (typeProxy = (StructuredTypeProxyOraclev9i)object).isMarkedGenerate() && !typeProxy.getStructuredType().isPredefined()) {
            this.appendCreateTypeBody(buffer, typeProxy, prettyPrint);
        }
    }

    private void appendCreateTypeBody(StringBuffer oldbuffer, StructuredTypeProxyOracle typeProxy, boolean prettyPrint) {
        if (this.hasPLSQLMethod(typeProxy)) {
            this.storageDesign = typeProxy.getStorageDesign();
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            SSBStructuredTypeBodyOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "CREATE");
            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "OR");
            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "REPLACE");
            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "TYPE");
            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "BODY");
            if (typeProxy.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBStructuredTypeBodyOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
                SSBStructuredTypeBodyOraclev9i.appendString(buffer, '.');
            }
            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
            advancedComment = buffer.toString();
            SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "AS");
            Iterator it = typeProxy.getMethods().iterator();
            while (it.hasNext()) {
                MethodProxyOraclev9i method = (MethodProxyOraclev9i)it.next();
                boolean isConstructor = "YES".equalsIgnoreCase(method.getConstructor());
                if (!isConstructor && "NO".equalsIgnoreCase(method.getInstantiable())) continue;
                SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                if (!isConstructor) {
                    if (typeProxy.getMapOrderFunction() == method) {
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, typeProxy.getMapOrderType());
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "MEMBER");
                    } else if ("YES".equalsIgnoreCase(method.getIsStatic())) {
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "STATIC");
                        if ("YES".equalsIgnoreCase(method.getIsFinal())) {
                            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "FINAL");
                        }
                    } else {
                        if ("YES".equalsIgnoreCase(method.getOverriding())) {
                            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "OVERRIDING");
                        }
                        if ("YES".equalsIgnoreCase(method.getIsFinal())) {
                            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "FINAL");
                        }
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "MEMBER");
                    }
                    if ("PROCEDURE".equalsIgnoreCase(method.getMethodType())) {
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "PROCEDURE");
                    } else {
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "FUNCTION");
                    }
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(method));
                } else {
                    if ("YES".equalsIgnoreCase(method.getIsFinal())) {
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "FINAL");
                    }
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "CONSTRUCTOR");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "FUNCTION");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
                }
                if (method.getParams().size() > 0 || "NO".equalsIgnoreCase(method.getCopySelf())) {
                    SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    boolean first = true;
                    if ("NO".equalsIgnoreCase(method.getCopySelf()) && "NO".equalsIgnoreCase(method.getIsStatic())) {
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "SELF");
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "IN");
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "OUT");
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "NOCOPY");
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
                        first = false;
                    }
                    Iterator paramsIt = method.getParams().iterator();
                    while (paramsIt.hasNext()) {
                        MethodParamProxyOracle param = (MethodParamProxyOracle)paramsIt.next();
                        if (first) {
                            first = false;
                        } else {
                            this.appendComma(buffer);
                            SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        }
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(param));
                        if (!"".equalsIgnoreCase(param.getDirectionType())) {
                            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, param.getDirectionType());
                        }
                        if ("NO".equalsIgnoreCase(param.getCopyArgument())) {
                            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "NOCOPY");
                        }
                        String datatype = this.getMethodParamDatatype((MethodParam)param.getObject());
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, datatype);
                        String defaultValue = param.getDefaultValue().trim();
                        if (defaultValue.length() <= 0) continue;
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
                        String df = this.addQuotesToDefault(datatype, defaultValue);
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, df);
                    }
                    SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, ')');
                }
                if (isConstructor) {
                    SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "RETURN");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "SELF");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "AS");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "RESULT");
                } else {
                    MethodParam returnValue = ((Method)method.getObject()).getReturnValue();
                    if (returnValue != null) {
                        SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "RETURN");
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, this.getMethodParamDatatype(returnValue));
                    }
                }
                SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "AS");
                SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                if ("PL/SQL".equalsIgnoreCase(method.getImplLanguage())) {
                    if (!"".equalsIgnoreCase(method.getPLSQLBody().trim())) {
                        SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, method.getPLSQLBody());
                        continue;
                    }
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "-- Empty PL/SQL Body");
                    SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "BEGIN NULL; END;");
                    continue;
                }
                SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "LANGUAGE");
                if ("Java".equalsIgnoreCase(method.getImplLanguage())) {
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "JAVA");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "NAME");
                    SSBStructuredTypeBodyOraclev9i.appendString(buffer, '\'');
                    SSBStructuredTypeBodyOraclev9i.appendString(buffer, method.getJavaName());
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, '\'');
                    continue;
                }
                if (!"C".equalsIgnoreCase(method.getImplLanguage())) continue;
                SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "C");
                if (!"".equalsIgnoreCase(method.getCName())) {
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "NAME");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, method.getCName());
                }
                SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "LIBRARY");
                if ("".equalsIgnoreCase(method.getCLibrary())) {
                    SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "-- Empty library");
                } else {
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, method.getCLibrary());
                }
                if (!"".equalsIgnoreCase(method.getAgentArguments())) {
                    SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "AGENT");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "IN");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, method.getAgentArguments());
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, ')');
                }
                if ("YES".equalsIgnoreCase(method.getWithContext())) {
                    SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "WITH");
                    SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "CONTEXT");
                }
                if ("".equalsIgnoreCase(method.getCPartemeters())) continue;
                SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "PARAMETERS");
                SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, '(');
                SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, method.getCPartemeters());
                SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, ')');
            }
            SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeBodyOraclev9i.appendStringWithSpace(buffer, "END");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisherWithSlash(buffer, prettyPrint);
            SSBStructuredTypeBodyOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateStructuredTypeBody();
        }
    }

    private String getMethodParamDatatype(MethodParam methodParam) {
        String datatype = null;
        DesignObject paramDataType = methodParam.getType();
        if (paramDataType instanceof StructuredType || paramDataType instanceof CollectionType) {
            RelationalObjectProxy proxy = this.storageDesign.getProxy(paramDataType);
            datatype = proxy != null ? this.storageDesign.getFormatedLongNameDDL(proxy) : this.storageDesign.getFormatedName(paramDataType);
            if (methodParam.isReference() && paramDataType instanceof StructuredType) {
                datatype = "REF " + datatype;
            }
        } else {
            datatype = methodParam.getDataType(this.storageDesign.getRDBMSType().getName());
        }
        return datatype;
    }

    private boolean hasPLSQLMethod(StructuredTypeProxyOracle typeProxy) {
        Iterator it = typeProxy.getMethods().iterator();
        while (it.hasNext()) {
            MethodProxyOraclev9i method = (MethodProxyOraclev9i)it.next();
            if (!"PL/SQL".equalsIgnoreCase(method.getImplLanguage()) || !"YES".equalsIgnoreCase(method.getInstantiable())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StructuredTypeProxyOraclev9i;
    }
}

