/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBUndoTablespaceOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        UndoTablespaceOraclev9i tableSpace = (UndoTablespaceOraclev9i)object;
        if (!tableSpace.isNullInstance() && tableSpace != null) {
            this.storageDesign = tableSpace.getStorageDesign();
            this.appendComment(oldbuffer, tableSpace);
            this.appendCreate(buffer, tableSpace);
            advancedComment = buffer.toString();
            this.appendDataFiles(buffer, tableSpace, prettyPrint);
            this.appendExtentManagement(buffer, prettyPrint);
            this.appendRetention(buffer, tableSpace, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBUndoTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBUndoTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateTablespace();
        }
    }

    private void appendCreate(StringBuffer buffer, UndoTablespaceOraclev9i tableSpace) {
        this.appendCreate(buffer);
        SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "UNDO");
        SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
        SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
    }

    private void appendDataFiles(StringBuffer buffer, UndoTablespaceOraclev9i tableSpace, boolean prettyPrint) {
        Iterator setIt = tableSpace.getDfiles().iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (!b) {
                SSBUndoTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBUndoTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, this.addQuotes(dataFile.getFileName(), true));
            SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "SIZE");
            this.appendStringWithSpace(buffer, dataFile.getSize());
            SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            if (dataFile.getReuse().equalsIgnoreCase("YES")) {
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "NEXT");
                this.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "K");
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "K");
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendExtentManagement(StringBuffer buffer, boolean prettyPrint) {
        SSBUndoTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "EXTENT");
        SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "MANAGEMENT");
        SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "LOCAL");
    }

    private void appendRetention(StringBuffer buffer, UndoTablespaceOraclev9i tableSpace, boolean prettyPrint) {
        SSBUndoTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, "RETENTION");
        SSBUndoTablespaceOraclev9i.appendStringWithSpace(buffer, tableSpace.getRetention());
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof UndoTablespaceOraclev9i && ((UndoTablespaceOraclev9i)object).isMarkedGenerate();
    }
}

