/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableViewProxyOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBViewOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableViewProxyOraclev9i && ((TableViewProxyOraclev9i)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        TableView view = null;
        TableViewProxyOraclev9i proxy = null;
        if (object instanceof TableView) {
            RDBMSSite site;
            view = (TableView)object;
            RelationalDesign rd = (RelationalDesign)view.getDesignPart();
            if (rd.getStorageDesign(site = rd.getSelectedRDBMSSite()) instanceof StorageDesignOraclev9i) {
                this.storageDesign = rd.getStorageDesign(site);
                proxy = (TableViewProxyOraclev9i)this.storageDesign.getProxy(view);
            }
        } else {
            proxy = (TableViewProxyOraclev9i)object;
            view = (TableView)proxy.getObject();
            this.storageDesign = proxy.getStorageDesign();
        }
        if (!view.isValidSQL()) {
            SSBViewOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid View " + view.getName());
            DDLFileMaker.incrementErrors();
            SSBViewOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBViewOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            return;
        }
        if (proxy != null) {
            if (proxy.isCommentChanged()) {
                this.appendComment(oldbuffer, proxy);
            } else {
                this.appendComment(oldbuffer, view);
            }
            String stmt = view.getBasedOnStructuredType() != null ? view.getUserDefinedSQL() : proxy.getDefinition();
            stmt = stmt.trim();
            if (stmt.endsWith(";")) {
                stmt = stmt.substring(0, stmt.length() - 1).trim();
            }
            if (!"".equalsIgnoreCase(stmt)) {
                int index;
                String createViewPart = "";
                boolean includesColumnList = false;
                if (Token.getFirstToken(stmt).equalsIgnoreCase("CREATE") && (index = stmt.toUpperCase().indexOf("VIEW")) > -1) {
                    int viewNameIndex;
                    int dotIndex;
                    createViewPart = stmt.substring(0, index + 4);
                    String stmtWithoutNL = (stmt = stmt.substring(index + 4).trim()).replaceAll("[\t\n\f\r\u000b]+", " ");
                    String oldViewName = Token.getFirstName(stmtWithoutNL, '\"', '\"');
                    int bracketIndex = oldViewName.indexOf(40);
                    if (bracketIndex > -1) {
                        oldViewName = oldViewName.substring(0, bracketIndex);
                    }
                    if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                        oldViewName = oldViewName.substring(dotIndex + 1);
                    }
                    if ((viewNameIndex = stmt.indexOf(oldViewName, dotIndex)) > -1 && (stmt = stmt.substring(viewNameIndex + oldViewName.length())).startsWith("\"")) {
                        stmt = stmt.substring(1);
                    }
                    if ((stmt = stmt.trim()).toUpperCase().startsWith("AS")) {
                        stmt = stmt.substring(2).trim();
                    } else if (stmt.startsWith("(")) {
                        includesColumnList = true;
                    }
                }
                if ("YES".equalsIgnoreCase(proxy.getForce())) {
                    if (!Token.startsWithString(createViewPart, "CREATE OR REPLACE FORCE")) {
                        createViewPart = "CREATE OR REPLACE FORCE VIEW";
                    }
                } else if (!Token.startsWithString(createViewPart, "CREATE OR REPLACE")) {
                    createViewPart = this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL() ? "CREATE OR REPLACE NOFORCE VIEW" : "CREATE OR REPLACE VIEW";
                }
                ModelIDObject viewObject = this.storageDesign.isOpen() ? proxy : view;
                createViewPart = createViewPart + ' ' + this.storageDesign.getFormatedLongNameDDL(viewObject);
                if (view.getBasedOnStructuredType() != null) {
                    if (stmt.toUpperCase().startsWith("OF")) {
                        createViewPart = createViewPart + NEWLINE + ' ' + stmt;
                        stmt = "";
                    } else {
                        createViewPart = createViewPart + this.appendStructuredType(proxy);
                    }
                }
                if (stmt.equals("")) {
                    stmt = createViewPart;
                } else if (includesColumnList) {
                    stmt = createViewPart + ' ' + stmt;
                } else {
                    String columnList = this.getColumnList(view);
                    stmt = createViewPart + ' ' + columnList + ' ' + "AS" + NEWLINE + stmt;
                }
                this.appendBeforeCreateScript(oldbuffer, prettyPrint, view);
                SSBViewOraclev9i.appendStringWithSpace(buffer, stmt);
                this.appendWith(buffer, proxy);
                this.appendToBuffer(oldbuffer, buffer, createViewPart);
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, createViewPart);
                SSBViewOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementCreateView();
                this.appendAfterCreateScript(oldbuffer, prettyPrint, view);
                if (view.getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendViewCommentOn(this.storageDesign, oldbuffer, view, proxy, prettyPrint);
                }
                this.appendPermissions(oldbuffer, proxy, prettyPrint);
            } else {
                SSBViewOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                DDLFileMaker.incrementErrors();
            }
            SSBViewOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBViewOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
        }
    }

    private String appendStructuredType(TableViewProxyOraclev9i view) {
        StringBuffer forInsert = new StringBuffer();
        SSBViewOraclev9i.appendStringWithSpace(forInsert, NEWLINE);
        SSBViewOraclev9i.appendStringWithSpace(forInsert, "OF");
        StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getProxy(((TableView)view.getObject()).getBasedOnStructuredType().getObjectID());
        SSBViewOraclev9i.appendStringWithSpace(forInsert, this.storageDesign.getFormatedLongNameDDL(stp));
        TableViewProxy superView = view.getSuperView();
        if (superView != null) {
            SSBViewOraclev9i.appendStringWithSpace(forInsert, "UNDER");
            SSBViewOraclev9i.appendStringWithSpace(forInsert, this.storageDesign.getFormatedLongNameDDL(superView));
        } else {
            String schemaElement = view.getXmlSchemaElement();
            if (!"".equalsIgnoreCase(schemaElement)) {
                String schemaUrl = view.getXmlSchemaUrl();
                if (!"".equalsIgnoreCase(schemaUrl)) {
                    SSBViewOraclev9i.appendStringWithSpace(forInsert, "XMLSCHEMA");
                    forInsert.append('\"').append(schemaUrl).append('\"').append(' ');
                }
                SSBViewOraclev9i.appendStringWithSpace(forInsert, "ELEMENT");
                forInsert.append('\"').append(schemaElement).append('\"').append(' ');
            }
            SSBViewOraclev9i.appendStringWithSpace(forInsert, "WITH");
            SSBViewOraclev9i.appendStringWithSpace(forInsert, "OBJECT");
            SSBViewOraclev9i.appendStringWithSpace(forInsert, "IDENTIFIER");
            if (view.getOidAttributes() == null || "".equalsIgnoreCase(view.getOidAttributes())) {
                SSBViewOraclev9i.appendStringWithSpace(forInsert, "DEFAULT");
            } else {
                SSBViewOraclev9i.appendStringWithSpace(forInsert, '(');
                this.appendOidAttributes(forInsert, view.getOidAttributes());
                SSBViewOraclev9i.appendStringWithSpace(forInsert, ')');
            }
        }
        return forInsert.toString();
    }

    private void appendOidAttributes(StringBuffer buff, String attrs) {
        StringTokenizer tokenizer = new StringTokenizer(attrs, ",");
        String attr = null;
        int attrNum = 0;
        while (tokenizer.hasMoreTokens()) {
            attr = tokenizer.nextToken().trim();
            StringBuffer attrBuff = new StringBuffer(attr);
            while (tokenizer.hasMoreTokens() && Token.tokenNumber(attr, "(") > Token.tokenNumber(attr, ")")) {
                attrBuff.append(",").append(tokenizer.nextToken().trim());
                attr = attrBuff.toString().trim();
            }
            if (attrNum > 0) {
                SSBViewOraclev9i.appendStringWithSpace(buff, ',');
            }
            if (Token.hasCloseAndOpenBrackets(attr)) {
                SSBViewOraclev9i.appendStringWithSpace(buff, attr);
            } else {
                SSBViewOraclev9i.appendStringWithSpace(buff, this.storageDesign.getFormatedName(attr));
            }
            ++attrNum;
        }
    }

    private void appendWith(StringBuffer buffer, TableViewProxyOracle viewProxy) {
        if ("YES".equalsIgnoreCase(viewProxy.getReadOnly())) {
            if (buffer.indexOf("WITH READ ONLY") == -1) {
                buffer.append(NEWLINE).append("    ");
                buffer.append("WITH READ ONLY");
            }
        } else if (viewProxy.getCheckOption() && viewProxy.getDefinition() != null && viewProxy.getDefinition().trim().length() != 0) {
            int withCheckOptionIndex = buffer.lastIndexOf("WITH CHECK OPTION");
            if (withCheckOptionIndex == -1) {
                buffer.append(NEWLINE).append("    ");
                SSBViewOraclev9i.appendStringWithSpace(buffer, "WITH CHECK OPTION");
            }
            if (!"".equalsIgnoreCase(viewProxy.getCheckOptionName())) {
                int constraintIndex = buffer.lastIndexOf("CONSTRAINT ");
                if (constraintIndex > withCheckOptionIndex && withCheckOptionIndex > -1) {
                    buffer.delete(constraintIndex, buffer.length());
                }
                buffer.append("CONSTRAINT ").append(viewProxy.getCheckOptionName());
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableViewProxyOracle viewProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)this.storageDesign).getPermissionsSet();
        Iterator it = permissionsSet.iterator();
        while (it.hasNext()) {
            PermissionsOraclev9i permissions = (PermissionsOraclev9i)it.next();
            if (permissions.getView() != null && permissions.getView().equals(viewProxy) && !permissions.getPrivileges().equalsIgnoreCase("")) {
                SSBViewOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBViewOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                SSBViewOraclev9i.appendStringWithSpace(buffer, "GRANT");
                SSBViewOraclev9i.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions);
                this.appendTo(buffer, permissions);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getView() != null && permissions.getView().equals(viewProxy) && !permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, permissions);
                SSBViewOraclev9i.appendStringWithSpace(buffer, "GRANT");
                SSBViewOraclev9i.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
                this.appendObject(buffer, permissions);
                this.appendTo(buffer, permissions);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions);
                this.appendGrantOption(buffer, permissions);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getView() == null || !permissions.getView().equals(viewProxy) || permissions.getPrivilegesWithHierarchyOption().equalsIgnoreCase("")) continue;
            SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, permissions);
            SSBViewOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBViewOraclev9i.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions);
            this.appendTo(buffer, permissions);
            advancedComment = buffer.toString();
            buffer.append(NEWLINE);
            SSBViewOraclev9i.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBViewOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getView() != null) {
            buffer.append(NEWLINE);
            SSBViewOraclev9i.appendStringWithSpace(buffer, "ON");
            SSBViewOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getView()));
        }
    }

    private void appendTo(StringBuffer buffer, PermissionsOraclev9i privileges) {
        SSBViewOraclev9i.appendStringWithSpace(buffer, "TO");
        if ("YES".equalsIgnoreCase(privileges.getPublic())) {
            SSBViewOraclev9i.appendStringWithSpace(buffer, "PUBLIC");
        } else if (privileges.getUser() != null) {
            SSBViewOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(privileges.getUser()));
        } else if (privileges.getRole() != null) {
            SSBViewOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(privileges.getRole()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getRole() == null) {
            SSBViewOraclev9i.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            buffer.append(NEWLINE);
            SSBViewOraclev9i.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }
}

