/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver;

import oracle.dbtools.crest.exports.ddl.DDLConstants;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;

public abstract class AbstractSSBSqlServer
extends SQLStatementBuilder
implements DDLConstants {
    private StorageDesign storageDesign;

    @Override
    protected void appendCommentOn(StringBuffer buffer, StorageObject object, boolean prettyPrint) {
        String tableCommentOn = "";
        if (object instanceof TableProxy) {
            Table table = (Table)((TableProxy)object).getObject();
            tableCommentOn = table.getCommentInRDBMS();
        } else if (object instanceof IndexProxy) {
            Index index = (Index)((IndexProxy)object).getObject();
            tableCommentOn = index.getCommentInRDBMS();
        } else if (object instanceof TableViewProxy) {
            TableView view = (TableView)((TableViewProxy)object).getObject();
            tableCommentOn = view.getCommentInRDBMS();
        } else if (object != null) {
            tableCommentOn = object.getCommentInRDBMS();
        } else {
            return;
        }
        this.storageDesign = object.getStorageDesign();
        if (this.isNotEmpty(tableCommentOn)) {
            if (prettyPrint) {
                buffer.append(NEWLINE).append("    ");
            }
            buffer.append("COMMENT ON ").append(this.storageDesign.getFormatedName(object.getName())).append(" IS '").append(tableCommentOn).append('\'');
            buffer.append(NEWLINE);
            buffer.append("GO");
        }
        buffer.append(NEWLINE);
    }

    protected void appendViewElementComment(StringBuffer buffer, DesignObject element, TableView tableView, boolean prettyPrint) {
        if (!element.getCommentInRDBMS().equalsIgnoreCase("")) {
            AbstractSSBSqlServer.appendNewLine(buffer, prettyPrint, 0);
            AbstractSSBSqlServer.appendNewLine(buffer, prettyPrint, 0);
            AbstractSSBSqlServer.appendNewLine(buffer, prettyPrint, 0);
            AbstractSSBSqlServer.appendStringWithSpace(buffer, "EXEC");
            AbstractSSBSqlServer.appendStringWithSpace(buffer, "sp_addextendedproperty");
            AbstractSSBSqlServer.appendStringWithSpace(buffer, "'MS_Description'");
            AbstractSSBSqlServer.appendStringWithSpace(buffer, ',');
            AbstractSSBSqlServer.appendString(buffer, '\'');
            AbstractSSBSqlServer.appendString(buffer, element.getCommentInRDBMS());
            AbstractSSBSqlServer.appendStringWithSpace(buffer, '\'');
            AbstractSSBSqlServer.appendStringWithSpace(buffer, ',');
            AbstractSSBSqlServer.appendString(buffer, '\'');
            AbstractSSBSqlServer.appendString(buffer, "VIEW");
            AbstractSSBSqlServer.appendStringWithSpace(buffer, '\'');
            AbstractSSBSqlServer.appendStringWithSpace(buffer, ',');
            AbstractSSBSqlServer.appendString(buffer, '\'');
            AbstractSSBSqlServer.appendString(buffer, tableView.getName());
            AbstractSSBSqlServer.appendStringWithSpace(buffer, '\'');
            AbstractSSBSqlServer.appendStringWithSpace(buffer, ',');
            AbstractSSBSqlServer.appendString(buffer, '\'');
            AbstractSSBSqlServer.appendString(buffer, "COLUMN");
            AbstractSSBSqlServer.appendStringWithSpace(buffer, '\'');
            AbstractSSBSqlServer.appendStringWithSpace(buffer, ',');
            AbstractSSBSqlServer.appendString(buffer, '\'');
            AbstractSSBSqlServer.appendString(buffer, element.getName());
            AbstractSSBSqlServer.appendStringWithSpace(buffer, '\'');
            AbstractSSBSqlServer.appendNewLine(buffer, prettyPrint, 0);
            AbstractSSBSqlServer.appendString(buffer, "GO");
            AbstractSSBSqlServer.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    protected boolean isNotEmpty(String string) {
        return string != null && !"".equals(string) && !"".equals(string.trim());
    }

    protected void appendDataBase(StringBuffer buffer, DataBaseSqlServer database, boolean prettyPrint) {
        if (database != null && !database.isNullInstance()) {
            this.storageDesign = database.getStorageDesign();
            AbstractSSBSqlServer.appendStringWithSpace(buffer, "USE");
            AbstractSSBSqlServer.appendString(buffer, this.storageDesign.getFormatedName(database.getName()));
            AbstractSSBSqlServer.appendNewLine(buffer, prettyPrint, 0);
            AbstractSSBSqlServer.appendStringWithSpace(buffer, "GO");
            AbstractSSBSqlServer.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    protected String addQuotesToDefault(String dataType, String defaultValue) {
        String df = defaultValue.trim();
        if (("TRUE".equalsIgnoreCase(df) || "FALSE".equalsIgnoreCase(df)) && "BIT".equalsIgnoreCase(dataType)) {
            return "TRUE".equalsIgnoreCase(df) ? "1" : "0";
        }
        if ("CURRENT_TIMESTAMP".equalsIgnoreCase(df) || "CURRENT_USER".equalsIgnoreCase(df)) {
            return df;
        }
        if ("CURRENT_DATE".equalsIgnoreCase(df) || "SYSDATE".equalsIgnoreCase(df)) {
            return "GETDATE()";
        }
        if ("CURRENT_TIMESTAMP".equalsIgnoreCase(df) || "LOCALTIMESTAMP".equalsIgnoreCase(df) || "SYSTIMESTAMP".equalsIgnoreCase(df)) {
            return "CURRENT_TIMESTAMP";
        }
        if ("SESSIONTIMEZONE".equalsIgnoreCase(df) || "DBTIMEZONE".equalsIgnoreCase(df)) {
            return "";
        }
        if ("USER".equalsIgnoreCase(df)) {
            return "CURRENT_USER";
        }
        df = super.addQuotesToDefault(dataType, defaultValue);
        return df;
    }
}

