/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.sqlserver.SSBDropFKDSqlServer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;

public class SSBDropTableSqlServer
extends SQLStatementBuilder {
    private List droppedTables;
    private SSBDropFKDSqlServer fkDrop = new SSBDropFKDSqlServer();

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isDropEnabled()) {
            return true;
        }
        return object instanceof TableProxySqlServer && ((TableProxySqlServer)object).isDropEnabled() && !((TableProxySqlServer)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        ModelIDObject mdObject = null;
        if (object == null) {
            return;
        }
        mdObject = (ModelIDObject)object;
        Table table = null;
        TableProxySqlServer tp = null;
        if (object instanceof TableProxySqlServer) {
            tp = (TableProxySqlServer)mdObject;
            table = (Table)((TableProxySqlServer)object).getObject();
        } else {
            table = (Table)object;
        }
        for (FKIndexAssociation fk : ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table)) {
            ContainerWithKeyObject child = fk.getContainerWithKeyObject();
            if (this.getDroppedTables().contains(child)) continue;
            FKProxySqlServer fkProxy = null;
            if (((RelationalDesign)table.getDesignPart()).getStorageDesign() instanceof StorageDesignSqlServerv2k) {
                fkProxy = (FKProxySqlServer)((StorageDesignSqlServerv2k)((RelationalDesign)table.getDesignPart()).getStorageDesign()).getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID());
                this.fkDrop.doAppend(buffer, fkProxy, prettyPrint);
                continue;
            }
            fkProxy = (FKProxySqlServer)((StorageDesignSqlServerv2k5)((RelationalDesign)table.getDesignPart()).getStorageDesign()).getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID());
            this.fkDrop.doAppend(buffer, fkProxy, prettyPrint);
        }
        this.appendBeforeDropScript(oldbuffer, prettyPrint, table);
        this.appendDrop(buffer);
        SSBDropTableSqlServer.appendStringWithSpace(buffer, "TABLE");
        if (tp != null) {
            DataBaseSqlServer database = tp.getDatabase();
            if (tp.getStorageDesign() instanceof StorageDesignSqlServerv2k) {
                UserSqlServer user = tp.getUser();
                if (user != null && tp.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBDropTableSqlServer.appendString(buffer, ((StorageDesignSqlServerv2k)tp.getStorageDesign()).getFormatedName(database.getName()));
                    SSBDropTableSqlServer.appendString(buffer, '.');
                    SSBDropTableSqlServer.appendString(buffer, ((StorageDesignSqlServerv2k)tp.getStorageDesign()).getFormatedName(user.getName()));
                    SSBDropTableSqlServer.appendString(buffer, '.');
                    SSBDropTableSqlServer.appendString(buffer, ((StorageDesignSqlServerv2k)tp.getStorageDesign()).getFormatedName(tp.getName()));
                } else {
                    SSBDropTableSqlServer.appendString(buffer, ((StorageDesignSqlServerv2k)tp.getStorageDesign()).getFormatedName(tp.getName()));
                }
            } else if (tp.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
                SchemaSqlServer schema = tp.getSchema();
                if (schema != null && tp.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBDropTableSqlServer.appendString(buffer, ((StorageDesignSqlServerv2k5)tp.getStorageDesign()).getFormatedName(database.getName()));
                    SSBDropTableSqlServer.appendString(buffer, '.');
                    SSBDropTableSqlServer.appendString(buffer, ((StorageDesignSqlServerv2k5)tp.getStorageDesign()).getFormatedName(schema.getName()));
                    SSBDropTableSqlServer.appendString(buffer, '.');
                    SSBDropTableSqlServer.appendString(buffer, ((StorageDesignSqlServerv2k5)tp.getStorageDesign()).getFormatedName(tp.getName()));
                } else {
                    SSBDropTableSqlServer.appendString(buffer, ((StorageDesignSqlServerv2k5)tp.getStorageDesign()).getFormatedName(tp.getName()));
                }
            }
        } else {
            StorageDesign storageDesign = this.getStorageDesign(object);
            SSBDropTableSqlServer.appendStringWithSpace(buffer, storageDesign.getFormatedName(table.getLongNameDDL()));
        }
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        SSBDropTableSqlServer.appendNewLine(buffer, prettyPrint, 0);
        SSBDropTableSqlServer.appendString(buffer, "GO");
        SSBDropTableSqlServer.appendNewLine(buffer, prettyPrint, 0);
        SSBDropTableSqlServer.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        this.getDroppedTables().add(tp);
    }

    public List getDroppedTables() {
        if (this.droppedTables == null) {
            this.droppedTables = new ArrayList();
        }
        return this.droppedTables;
    }

    @Override
    public void clearTemporaryObjects() {
        this.getDroppedTables().clear();
    }
}

