/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.DataBaseSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesignSqlServer storageDesign;
    boolean existsPrimary = false;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DataBaseSqlServerv2k database = (DataBaseSqlServerv2k)object;
        this.storageDesign = (StorageDesignSqlServer)this.getStorageDesign(object);
        this.appendComment(buffer, database);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        this.appendCreate(buffer, database, prettyPrint);
        this.appendFileSpec(buffer, database, prettyPrint);
        this.appendFileGroup(buffer, database, prettyPrint);
        this.appendLogOn(buffer, database, prettyPrint);
        this.appendCollate(buffer, database, prettyPrint);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "GO");
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateDatabase();
        this.appendAlterDatabase(buffer, database, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        this.appendCreate(buffer);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "DATABASE");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(database.getName()));
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
    }

    protected void appendFileSpec(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        StorageObjectCollection fileGroups = database.getFilegroups();
        if (fileGroups.containsName("PRIMARY") && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            FileGroupSqlServer primary = (FileGroupSqlServer)fileGroups.getByName("PRIMARY");
            if (primary != null && primary.getDatafiles() != null) {
                if (this.checkFileGroupValidity(primary)) {
                    StorageObjectCollection datafiles = primary.getDatafiles();
                    if (datafiles.size() > 0) {
                        this.existsPrimary = true;
                        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "ON");
                        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "PRIMARY");
                        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                        this.appendDataFiles(buffer, datafiles, prettyPrint);
                    }
                } else {
                    SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "-- Invalid filegroup");
                    SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(primary.getName()));
                }
            }
        } else {
            this.existsPrimary = false;
        }
    }

    protected void appendFileGroup(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        if (this.existsPrimary && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            StorageObjectCollection fileGroups = database.getFilegroups();
            Iterator it = fileGroups.iterator();
            while (it.hasNext()) {
                FileGroupSqlServer filegroup = (FileGroupSqlServer)it.next();
                if (filegroup.getName().equalsIgnoreCase("PRIMARY")) continue;
                if (this.checkFileGroupValidity(filegroup)) {
                    this.appendComma(buffer);
                    SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    this.appendGroup(buffer, filegroup, prettyPrint);
                    continue;
                }
                SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "-- Invalid filegroup");
                SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(filegroup.getName()));
            }
        }
    }

    protected void appendCollate(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        String collation = database.getCollationName();
        if (collation != null && !collation.trim().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "COLLATE");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, collation);
        }
    }

    protected void appendLogOn(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        if (this.existsPrimary && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            StorageObjectCollection datafiles = database.getTransactionLogs();
            Iterator it = datafiles.iterator();
            boolean wasInside = false;
            while (it.hasNext()) {
                DataFileSqlServer datafile = (DataFileSqlServer)it.next();
                if (datafile.getDataBase() != null && this.checkDataFileValidity(datafile)) {
                    if (!wasInside) {
                        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "LOG ON");
                        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    }
                    wasInside = true;
                    this.appendDataFile(buffer, datafile, prettyPrint);
                    continue;
                }
                if (datafile.getDataBase() == null || this.checkDataFileValidity(datafile)) continue;
                SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "-- Invalid datafile name");
                SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(datafile.getName()));
            }
            this.deleteLastComma(buffer, prettyPrint, wasInside);
        }
    }

    protected void appendAlterDatabase(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "ALTER");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "DATABASE");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(database.getLongNameDDL()));
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "SET");
        this.appendStateOption(buffer, database, prettyPrint);
        this.appendCursorOption(buffer, database, prettyPrint);
        this.appendAutoOption(buffer, database, prettyPrint);
        this.appendSqlOption(buffer, database, prettyPrint);
        this.appendRecoveryOption(buffer, database, prettyPrint);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "GO");
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
    }

    protected void appendStateOption(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getUserState());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
    }

    protected void appendCursorOption(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "CURSOR_CLOSE_ON_COMMIT");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getCursorCloseOnCommit());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "CURSOR_DEFAULT");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getCursorDefault());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
    }

    protected void appendAutoOption(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        if (database.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "AUTO_CLOSE");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getAutoClose());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "AUTO_CREATE_STATISTICS");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getAutoCreateStatistics());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "AUTO_SHRINK");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getAutoShrink());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "AUTO_UPDATE_STATISTICS");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getAutoUpdateStatistics());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    protected void appendSqlOption(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "ANSI_NULLS");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getAnsiNulls());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (!database.getAnsiPadding().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "ANSI_PADDING");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getAnsiPadding());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getAnsiWarnings().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "ANSI_WARNINGS");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getAnsiWarnings());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getArithabort().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "ARITHABORT");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getArithabort());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getConcatNullYieldsNull().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "CONCAT_NULL_YIELDS_NULL");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getConcatNullYieldsNull());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "CONCAT_NULL_YIELDS_NULL");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "OFF");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getNumericRoundabort().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "NUMERIC_ROUNDABORT");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getNumericRoundabort());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "QUOTED_IDENTIFIER");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getQuotedIdentifier());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (!database.getRecursiveTriggers().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "RECURSIVE_TRIGGERS");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getRecursiveTriggers());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "RECURSIVE_TRIGGERS");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "OFF");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    protected void appendRecoveryOption(StringBuffer buffer, DataBaseSqlServerv2k database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "RECOVERY");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getRecovery());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "TORN_PAGE_DETECTION");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, database.getTornPageDetection());
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
    }

    private boolean checkFileGroupValidity(FileGroupSqlServer filegroup) {
        StorageObjectCollection datafiles = filegroup.getDatafiles();
        if (datafiles == null || datafiles.size() == 0) {
            return false;
        }
        Iterator it = datafiles.iterator();
        while (it.hasNext()) {
            DataFileSqlServer df = (DataFileSqlServer)it.next();
            if (df.getFileName() != null && !df.getFileName().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private boolean checkDataFileValidity(DataFileSqlServer datafile) {
        return datafile.getFileName() != null && !datafile.getFileName().trim().equalsIgnoreCase("");
    }

    protected void appendGroup(StringBuffer buffer, FileGroupSqlServer filegroup, boolean prettyPrint) {
        StorageObjectCollection datafiles = filegroup.getDatafiles();
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "FILEGROUP");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(filegroup.getName()));
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        this.appendDataFiles(buffer, datafiles, prettyPrint);
    }

    protected void appendDataFiles(StringBuffer buffer, StorageObjectCollection datafiles, boolean prettyPrint) {
        Iterator it = datafiles.iterator();
        boolean wasInside = false;
        while (it.hasNext()) {
            wasInside = true;
            DataFileSqlServer datafile = (DataFileSqlServer)it.next();
            this.appendDataFile(buffer, datafile, prettyPrint);
        }
        if (wasInside) {
            int newline = prettyPrint ? NEWLINE.length() + "    ".length() : 1;
            buffer = buffer.delete(buffer.length() - newline - 2, buffer.length() - 1);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseSqlServerv2k && ((DataBaseSqlServerv2k)object).isMarkedGenerate();
    }

    protected void appendDataFile(StringBuffer buffer, DataFileSqlServer datafile, boolean prettyPrint) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '(');
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        this.appendNameWithQuotes(buffer, prettyPrint, datafile);
        this.appendFilename(buffer, prettyPrint, datafile);
        this.appendInitialSize(buffer, prettyPrint, datafile);
        this.appendMaxSize(buffer, datafile);
        this.appendGrowthValue(buffer, prettyPrint, datafile);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2k.appendString(buffer, ')');
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
    }

    private void deleteLastComma(StringBuffer buffer, boolean prettyPrint, boolean wasInside) {
        int newline = prettyPrint ? NEWLINE.length() + "    ".length() : 1;
        if (wasInside) {
            buffer = buffer.delete(buffer.length() - newline - 2, buffer.length());
        }
    }

    private void appendNameWithQuotes(StringBuffer buffer, boolean prettyPrint, DataFileSqlServer datafile) {
        if (!datafile.getName().trim().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "NAME");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '=');
            SSBDataBaseSqlServerv2k.appendString(buffer, '\'');
            this.appendString(buffer, datafile);
            SSBDataBaseSqlServerv2k.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    private void appendFilename(StringBuffer buffer, boolean prettyPrint, DataFileSqlServer datafile) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "FILENAME");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '=');
        SSBDataBaseSqlServerv2k.appendString(buffer, '\'');
        SSBDataBaseSqlServerv2k.appendString(buffer, datafile.getFileName());
        SSBDataBaseSqlServerv2k.appendString(buffer, '\'');
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
    }

    private void appendInitialSize(StringBuffer buffer, boolean prettyPrint, DataFileSqlServer datafile) {
        if (datafile.getInitialSize() != 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "SIZE");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '=');
            this.appendString(buffer, datafile.getInitialSize());
            if (!datafile.getInitialSizeInUnit().equals("")) {
                SSBDataBaseSqlServerv2k.appendSpace(buffer);
                SSBDataBaseSqlServerv2k.appendString(buffer, datafile.getSizeUnitFromInUnit(datafile.getInitialSizeInUnit()));
            }
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    private void appendMaxSize(StringBuffer buffer, DataFileSqlServer datafile) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "MAXSIZE");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '=');
            if (datafile.getIsUnlimited()) {
                SSBDataBaseSqlServerv2k.appendString(buffer, "UNLIMITED");
            } else {
                this.appendString(buffer, datafile.getMaxSize());
                if (!datafile.getMaxSizeInUnit().equals("")) {
                    SSBDataBaseSqlServerv2k.appendSpace(buffer);
                    SSBDataBaseSqlServerv2k.appendString(buffer, datafile.getSizeUnitFromInUnit(datafile.getMaxSizeInUnit()));
                }
            }
        }
    }

    private void appendGrowthValue(StringBuffer buffer, boolean prettyPrint, DataFileSqlServer datafile) {
        if (datafile.getGrowthValue() != 0) {
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "FILEGROWTH");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '=');
            this.appendString(buffer, datafile.getGrowthValue());
            if (datafile.getGrowthMethod().equalsIgnoreCase("By Percent")) {
                SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '%');
            } else if (!datafile.getGrowthMethod().equals("")) {
                SSBDataBaseSqlServerv2k.appendSpace(buffer);
                SSBDataBaseSqlServerv2k.appendString(buffer, datafile.getSizeUnitFromInUnit(datafile.getGrowthMethod()));
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, "FILEGROWTH");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '=');
            SSBDataBaseSqlServerv2k.appendString(buffer, "10");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(buffer, '%');
        }
    }
}

