/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k.SSBIndexOnViewSqlServerv2k;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexOnViewSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.TableViewProxySqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBViewSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesignSqlServerv2k storageDesign;
    private SSBIndexOnViewSqlServerv2k ssbIndex = new SSBIndexOnViewSqlServerv2k();

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableView view = null;
        TableViewProxySqlServerv2k proxy = null;
        if (object instanceof TableView) {
            view = (TableView)object;
            if (this.getStorageDesign(object) instanceof StorageDesignSqlServerv2k) {
                this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
                proxy = (TableViewProxySqlServerv2k)this.storageDesign.getProxy(view);
            }
        } else if (object instanceof TableViewProxySqlServerv2k) {
            proxy = (TableViewProxySqlServerv2k)object;
            view = (TableView)proxy.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
        }
        if (!view.isValidSQL()) {
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName());
            DDLFileMaker.incrementErrors();
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            return;
        }
        if (proxy != null) {
            if (!proxy.isMarkedGenerate()) {
                this.appendIndexes(buffer, proxy, prettyPrint);
                return;
            }
            if (!proxy.getDefinition().trim().equalsIgnoreCase("")) {
                int index;
                this.appendBeforeCreateScript(buffer, prettyPrint, view);
                if (proxy.isCommentChanged()) {
                    this.appendComment(buffer, proxy);
                } else {
                    this.appendComment(buffer, view);
                }
                String stmt = proxy.getDefinition();
                stmt = stmt.trim();
                if (stmt.endsWith(";")) {
                    stmt = stmt.substring(0, stmt.length() - 1).trim();
                }
                String createViewPart = "";
                boolean includesColumnList = false;
                if (Token.getFirstToken(stmt).equalsIgnoreCase("CREATE") && (index = stmt.toUpperCase().indexOf("VIEW")) > -1) {
                    int viewNameIndex;
                    int dotIndex;
                    createViewPart = stmt.substring(0, index + 4);
                    String oldViewName = Token.getFirstName(stmt = stmt.substring(index + 4).trim(), '\"', '\"');
                    int bracketIndex = oldViewName.indexOf(40);
                    if (bracketIndex > -1) {
                        oldViewName = oldViewName.substring(0, bracketIndex);
                    }
                    if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                        oldViewName = oldViewName.substring(dotIndex + 1);
                    }
                    if ((viewNameIndex = stmt.indexOf(oldViewName, dotIndex)) > -1 && (stmt = stmt.substring(viewNameIndex + oldViewName.length())).startsWith("\"")) {
                        stmt = stmt.substring(1);
                    }
                    if ((stmt = stmt.trim()).toUpperCase().startsWith("AS")) {
                        stmt = stmt.substring(2).trim();
                    } else if (stmt.startsWith("(")) {
                        includesColumnList = true;
                    }
                }
                if (!Token.startsWithString(createViewPart, "CREATE")) {
                    createViewPart = "CREATE VIEW";
                }
                String longName = this.storageDesign.isOpen() ? proxy.getLongNameDDL() : view.getName();
                createViewPart = createViewPart + ' ' + this.storageDesign.getFormatedName(longName) + this.appendWithOptions(proxy);
                if (includesColumnList) {
                    stmt = createViewPart + ' ' + stmt;
                } else {
                    String columnList = this.getColumnList(view);
                    stmt = createViewPart + ' ' + columnList + ' ' + "AS" + ' ' + NEWLINE + stmt;
                }
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, stmt);
                if (proxy.getCheckOption() && buffer.indexOf("WITH CHECK OPTION") == -1) {
                    SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBViewSqlServerv2k.appendString(buffer, "WITH CHECK OPTION");
                }
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBViewSqlServerv2k.appendString(buffer, "GO");
                DDLFileMaker.incrementCreateView();
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                this.appendAfterCreateScript(buffer, prettyPrint, view);
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                this.appendAlter(buffer, proxy, prettyPrint);
                if (view.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendViewComment(buffer, view, proxy, prettyPrint);
                }
                this.appendExtProperties(buffer, proxy, prettyPrint);
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                this.appendIndexes(buffer, proxy, prettyPrint);
            } else {
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                DDLFileMaker.incrementErrors();
            }
        } else {
            this.appendComment(buffer, view);
            DDLFileMaker.incrementErrors();
        }
    }

    private String appendWithOptions(TableViewProxySqlServer proxy) {
        String withOptions = " WITH";
        boolean withFlag = false;
        if (proxy.getEncryption().equalsIgnoreCase("YES")) {
            withOptions = withOptions + ' ' + "ENCRYPTION";
            withFlag = true;
        }
        if (proxy.getSchemaBinding().equalsIgnoreCase("YES")) {
            withOptions = withOptions + ' ' + "SCHEMABINDING";
            withFlag = true;
        }
        if (proxy.getViewMetaData().equalsIgnoreCase("YES")) {
            withOptions = withOptions + ' ' + "VIEW_METADATA";
            withFlag = true;
        }
        return withFlag ? withOptions : "";
    }

    private void appendIndexes(StringBuffer buffer, TableViewProxySqlServer proxy, boolean prettyPrint) {
        IndexOnViewSqlServerv2k index;
        Object object;
        boolean uniqueClusteredFound = false;
        Iterator it = proxy.getIndexesOnView().iterator();
        while (it.hasNext()) {
            object = it.next();
            if (!(object instanceof IndexOnViewSqlServerv2k) || !(index = (IndexOnViewSqlServerv2k)object).getUnique().equalsIgnoreCase("YES") || !index.getClustered().equalsIgnoreCase("YES")) continue;
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
            uniqueClusteredFound = true;
        }
        it = proxy.getIndexesOnView().iterator();
        while (it.hasNext()) {
            object = it.next();
            if (!(object instanceof IndexOnViewSqlServerv2k) || (index = (IndexOnViewSqlServerv2k)object).getUnique().equalsIgnoreCase("YES") && index.getClustered().equalsIgnoreCase("YES")) continue;
            if (uniqueClusteredFound) {
                this.ssbIndex.doAppend(buffer, object, prettyPrint);
                continue;
            }
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "--  ERROR: Missing Index on View " + proxy.getName() + " : a unique clustered index must be created on the view before the nonclustered index " + index.getName() + " can be created");
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    protected String appendOwner(String definition, TableViewProxySqlServerv2k view) {
        String result = definition;
        String name = Token.getTokenAfter(result, "VIEW");
        if (name.indexOf(46) == -1 && view.getUser() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            String owner = this.storageDesign.getFormatedName(view.getUser().getName());
            result = this.appendOwner(result, name, owner);
        }
        return result;
    }

    protected void appendViewComment(StringBuffer buffer, TableView view, TableViewProxySqlServerv2k proxy, boolean prettyPrint) {
        String comment = null;
        String viewName = null;
        if (proxy != null && proxy.isCommentInRDBMSChanged()) {
            comment = proxy.getCommentInRDBMS();
            viewName = proxy.getName();
        } else if (view != null) {
            comment = view.getCommentInRDBMS();
            viewName = view.getName();
        }
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k.appendString(buffer, '\'');
            SSBViewSqlServerv2k.appendString(buffer, comment);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (proxy != null && proxy.getUser() != null) {
                SSBViewSqlServerv2k.appendString(buffer, '\'');
                SSBViewSqlServerv2k.appendString(buffer, "USER");
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k.appendString(buffer, '\'');
                SSBViewSqlServerv2k.appendString(buffer, proxy.getUser().getName());
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBViewSqlServerv2k.appendString(buffer, '\'');
            SSBViewSqlServerv2k.appendString(buffer, "VIEW");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k.appendString(buffer, '\'');
            SSBViewSqlServerv2k.appendString(buffer, viewName);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k.appendString(buffer, "GO");
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
        ContainedObject[] elements = null;
        TableView tbView = null;
        if (proxy != null) {
            tbView = (TableView)proxy.getObject();
            elements = tbView.getElements();
        } else if (view != null) {
            tbView = view;
            elements = tbView.getElements();
        }
        if (elements != null && tbView != null) {
            for (int i = 0; i < elements.length; ++i) {
                ContainedObject desObj = elements[i];
                if (desObj.getCommentInRDBMS() == null) continue;
                this.appendViewElementComment(buffer, desObj, tbView, prettyPrint);
            }
        }
    }

    private void appendExtProperties(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableViewProxySqlServerv2k viewProxySqlServer = (TableViewProxySqlServerv2k)object;
        if (!"".equalsIgnoreCase(viewProxySqlServer.getProps()) && viewProxySqlServer.getUser() != null) {
            for (int i = 0; i < viewProxySqlServer.getExtPropsSet().size() - 1; ++i) {
                String name = '\'' + (String)viewProxySqlServer.getExtPropsSet().get(i) + '\'';
                String value = '\'' + (String)viewProxySqlServer.getExtPropsSet().get(++i) + '\'';
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
                String props = name + ", " + value;
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, props);
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBViewSqlServerv2k.appendString(buffer, '\'');
                SSBViewSqlServerv2k.appendString(buffer, "USER");
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(viewProxySqlServer.getUser().getName()));
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k.appendString(buffer, '\'');
                SSBViewSqlServerv2k.appendString(buffer, "VIEW");
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBViewSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(viewProxySqlServer.getName()));
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBViewSqlServerv2k.appendString(buffer, "GO");
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableViewProxySqlServerv2k && ((TableViewProxySqlServerv2k)object).getDataBase() != null && !((TableViewProxySqlServerv2k)object).getDataBase().isNullInstance();
    }

    protected void appendColumns(StringBuffer buffer, TableView view, TableViewProxySqlServerv2k tableViewProxy, boolean prettyPrint) {
        ColumnView[] columns = (ColumnView[])view.getElements();
        SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBViewSqlServerv2k.appendString(buffer, "-- No columns");
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        } else {
            for (int i = 0; i < columns.length; ++i) {
                if (i == 0) {
                    SSBViewSqlServerv2k.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                if (tableViewProxy == null) continue;
                if (!columns[i].getAlias().equalsIgnoreCase("")) {
                    SSBViewSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getAlias()));
                    continue;
                }
                SSBViewSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
            }
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k.appendString(buffer, ')');
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    protected void appendAlter(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableViewProxySqlServerv2k viewProxySqlServer = (TableViewProxySqlServerv2k)object;
        if (viewProxySqlServer.getDataBase() != null && !viewProxySqlServer.getDataBase().isNullInstance() && viewProxySqlServer.getIndexesOnView() != null) {
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "ALTER");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "DATABASE");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(viewProxySqlServer.getDataBase().getName()));
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "SET");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "ARITHABORT");
            SSBViewSqlServerv2k.appendString(buffer, "ON");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "CONCAT_NULL_YIELDS_NULL");
            SSBViewSqlServerv2k.appendString(buffer, "ON");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "QUOTED_IDENTIFIER");
            SSBViewSqlServerv2k.appendString(buffer, "ON");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "ANSI_NULLS");
            SSBViewSqlServerv2k.appendString(buffer, "ON");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "ANSI_PADDING");
            SSBViewSqlServerv2k.appendString(buffer, "ON");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "ANSI_WARNINGS");
            SSBViewSqlServerv2k.appendString(buffer, "ON");
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBViewSqlServerv2k.appendStringWithSpace(buffer, "NUMERIC_ROUNDABORT");
            SSBViewSqlServerv2k.appendString(buffer, "OFF");
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBViewSqlServerv2k.appendString(buffer, "GO");
            SSBViewSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }
}

