/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RuleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBRuleSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        RuleSqlServerv2k5 rule = (RuleSqlServerv2k5)object;
        this.storageDesign = rule.getStorageDesign();
        SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        this.appendComment(buffer, rule);
        SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        this.appendRule(buffer, rule, prettyPrint);
        this.appendBindRule(buffer, rule, prettyPrint);
    }

    private void appendRule(StringBuffer buffer, RuleSqlServerv2k5 rule, boolean prettyPrint) {
        if (!rule.getExpression().trim().equalsIgnoreCase("")) {
            this.appendDataBase(buffer, rule.getDatabase(), prettyPrint);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "RULE");
            if (rule.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBRuleSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(rule.getSchema().getName()));
                SSBRuleSqlServerv2k5.appendString(buffer, '.');
            }
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(rule.getName()));
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "AS");
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, rule.getExpression());
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateRule();
            if (rule.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendRuleComment(buffer, rule, prettyPrint);
            }
        } else {
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Empty expression in rule ");
            buffer.append(rule.getName());
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendRuleComment(StringBuffer buffer, RuleSqlServerv2k5 rule, boolean prettyPrint) {
        String comment = rule.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            SSBRuleSqlServerv2k5.appendString(buffer, comment);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (rule != null && rule.getSchema() != null) {
                SSBRuleSqlServerv2k5.appendString(buffer, '\'');
                SSBRuleSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBRuleSqlServerv2k5.appendString(buffer, '\'');
                this.appendString(buffer, rule.getSchema());
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (rule != null && rule.getOwner() != null) {
                SSBRuleSqlServerv2k5.appendString(buffer, '\'');
                SSBRuleSqlServerv2k5.appendString(buffer, "USER");
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBRuleSqlServerv2k5.appendString(buffer, '\'');
                SSBRuleSqlServerv2k5.appendString(buffer, rule.getOwner().getName());
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBRuleSqlServerv2k5.appendString(buffer, '\'');
                SSBRuleSqlServerv2k5.appendString(buffer, "USER");
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBRuleSqlServerv2k5.appendString(buffer, '\'');
                SSBRuleSqlServerv2k5.appendString(buffer, "dbo");
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            SSBRuleSqlServerv2k5.appendString(buffer, "RULE");
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            SSBRuleSqlServerv2k5.appendString(buffer, rule.getLongNameDDL());
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendString(buffer, "GO");
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendBindRule(StringBuffer buffer, RuleSqlServerv2k5 rule, boolean prettyPrint) {
        Iterator it = rule.getColumnSet().iterator();
        ColumnProxySetSqlServerv2k5 colProxy = (ColumnProxySetSqlServerv2k5)rule.getStorageDesign().getColumnProxySet();
        ColumnProxySqlServerv2k5 col = null;
        while (it.hasNext()) {
            String column = (String)it.next();
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "sp_bindrule");
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            if (rule.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBRuleSqlServerv2k5.appendString(buffer, rule.getSchema().getName());
                SSBRuleSqlServerv2k5.appendString(buffer, '.');
            }
            SSBRuleSqlServerv2k5.appendString(buffer, rule.getName());
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            this.appendComma(buffer);
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            column = column.substring(column.lastIndexOf(46) + 1, column.length());
            col = (ColumnProxySqlServerv2k5)colProxy.getByName(column);
            SSBRuleSqlServerv2k5.appendString(buffer, col.getTableProxy().getName());
            SSBRuleSqlServerv2k5.appendString(buffer, '.');
            SSBRuleSqlServerv2k5.appendString(buffer, column);
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
        it = ((DataBaseSqlServerv2k5)rule.getDatabase()).getUsedDistinctTypes().iterator();
        while (it.hasNext()) {
            UsedUserDefinedDatav2k5 usedUDDT = (UsedUserDefinedDatav2k5)it.next();
            if (usedUDDT.getRuleObject() == null || usedUDDT.getRuleObject() != rule) continue;
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "sp_bindrule");
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            if (rule.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBRuleSqlServerv2k5.appendString(buffer, rule.getSchema().getName());
                SSBRuleSqlServerv2k5.appendString(buffer, '.');
            }
            SSBRuleSqlServerv2k5.appendString(buffer, rule.getName());
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            this.appendComma(buffer);
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            if (usedUDDT.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBRuleSqlServerv2k5.appendString(buffer, usedUDDT.getSchema().getName());
                SSBRuleSqlServerv2k5.appendString(buffer, '.');
            }
            SSBRuleSqlServerv2k5.appendString(buffer, usedUDDT.getLongName());
            SSBRuleSqlServerv2k5.appendString(buffer, '\'');
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBRuleSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBRuleSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RuleSqlServerv2k5 && ((RuleSqlServerv2k5)object).getDatabase() != null && !((RuleSqlServerv2k5)object).getDatabase().isNullInstance() && ((RuleSqlServerv2k5)object).isMarkedGenerate();
    }
}

