/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k5.SSBIndexSqlServerv2k5;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k5.SSBXMLIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesignSqlServerv2k5 storageDesign;
    private SSBIndexSqlServerv2k5 ssbIndex = new SSBIndexSqlServerv2k5();
    private SSBXMLIndexSqlServerv2k5 ssbXMLIndex = new SSBXMLIndexSqlServerv2k5();
    boolean canWriteComma = true;
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Table table = null;
        TableProxySqlServerv2k5 tableProxy = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
            tableProxy = (TableProxySqlServerv2k5)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxySqlServerv2k5) {
            tableProxy = (TableProxySqlServerv2k5)object;
            table = (Table)tableProxy.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
        }
        if (tableProxy != null && !tableProxy.isMarkedGenerate()) {
            this.appendIndexes(buffer, tableProxy, prettyPrint);
            return;
        }
        if (table != null) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            this.appendBeforeCreateScript(buffer, prettyPrint, table);
            if (tableProxy != null && tableProxy.isCommentChanged()) {
                this.appendComment(buffer, tableProxy);
            } else {
                this.appendComment(buffer, table);
            }
            if (tableProxy != null) {
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                this.appendDataBase(buffer, tableProxy.getDatabase(), prettyPrint);
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                this.appendCreateTable(buffer, tableProxy);
                this.appendColumns(buffer, table, tableProxy, prettyPrint);
                this.appendFilegroup(buffer, tableProxy, prettyPrint);
                this.appendTextImage(buffer, tableProxy, prettyPrint);
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "GO");
                DDLFileMaker.incrementCreateTable();
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                this.appendAfterCreateScript(buffer, prettyPrint, table);
                this.appendColumnCheckConstraints(buffer, tableProxy, prettyPrint);
                this.appendTableCheckConstraints(buffer, tableProxy, prettyPrint);
                SSBTableSqlServerv2k5.appendExistenceDependencyConstraints(buffer, tableProxy, prettyPrint, this, "GO", 128);
                SSBTableSqlServerv2k5.appendOptionalFKCheckConstraints(buffer, tableProxy, prettyPrint, this, String.valueOf(';'), 30);
                if (this.getArcConstrHandler() != null) {
                    this.getArcConstrHandler().appendArcConstraints(buffer, tableProxy, prettyPrint);
                }
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(buffer, table, tableProxy, prettyPrint);
                }
                this.appendBindDefault(buffer, table, tableProxy, prettyPrint);
                this.appendExtProperties(buffer, tableProxy, prettyPrint);
                this.appendColumnExtProperties(buffer, table, tableProxy, prettyPrint);
                this.appendIndexes(buffer, tableProxy, prettyPrint);
            } else {
                this.appendTableCommentOn(buffer, table, tableProxy, prettyPrint);
            }
        }
    }

    private void appendIndexes(StringBuffer buffer, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        Iterator it = tableProxy.getIndexes().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (this.ssbXMLIndex.canHandle(object)) {
                this.ssbXMLIndex.doAppend(buffer, object, prettyPrint);
                continue;
            }
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
        }
        this.appendIndexesForConstraints(buffer, (Table)tableProxy.getObject(), tableProxy);
    }

    private void appendCreateTable(StringBuffer buffer, TableProxySqlServerv2k5 tableProxy) {
        if (tableProxy.getName().length() > tableProxy.getMaxNameLength()) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, true, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
            SSBTableSqlServerv2k5.appendNewLine(buffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "TABLE");
        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
    }

    private void appendBindDefault(StringBuffer buffer, Table table, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k5 columnProxy = null;
        SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        if (tableProxy != null) {
            for (int i = 0; i < columns.length; ++i) {
                column = columns[i];
                columnProxy = (ColumnProxySqlServerv2k5)tableProxy.getColumnProxy(column.getObjectID());
                if (!columnProxy.getDefineDefault() || columnProxy.getDefaultObject() == null) continue;
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_bindefault");
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, columnProxy.getDefaultObject().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                this.appendComma(buffer);
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, columnProxy.getTableProxy().getLongNameDDL());
                SSBTableSqlServerv2k5.appendString(buffer, '.');
                SSBTableSqlServerv2k5.appendString(buffer, columnProxy.getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "GO");
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    protected void appendColumns(StringBuffer buffer, Table table, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k5 columnProxy = null;
        Object[] instCols = null;
        if (tableProxy != null) {
            instCols = tableProxy.getInstanceDescriptorCols().toArray();
        }
        SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length == 0 && (instCols == null || instCols.length == 0)) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            buffer.append("-- No columns");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        } else {
            for (int i = 0; i < columns.length; ++i) {
                if (i == 0) {
                    SSBTableSqlServerv2k5.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                if (tableProxy == null) continue;
                column = columns[i];
                columnProxy = (ColumnProxySqlServerv2k5)tableProxy.getColumnProxy(column.getObjectID());
                if (columnProxy.getComputed()) {
                    SSBTableSqlServerv2k5.appendSpace(buffer);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "AS");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, columnProxy.getFormula());
                    if (!columnProxy.getPersistedProp().equalsIgnoreCase("YES")) continue;
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "PERSISTED");
                    continue;
                }
                this.appendColumnNameAndDataType(buffer, columnProxy, prettyPrint);
                this.appendColate(buffer, columnProxy);
                this.appendColumnNullsAllowed(buffer, columnProxy);
                this.appendDefault(buffer, columnProxy);
                this.appendIdentity(buffer, columnProxy);
                this.appendRowGuidCol(buffer, columnProxy);
                this.appendColumnConstraints(buffer, column, columnProxy);
            }
            InstanceDescriptorColumnSqlServer instCol = null;
            for (int i = 0; i < instCols.length; ++i) {
                instCol = (InstanceDescriptorColumnSqlServer)instCols[i];
                if (columns.length == 0 && i == 0) {
                    SSBTableSqlServerv2k5.appendString(buffer, '(');
                } else {
                    buffer.append(", ");
                }
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(instCol.getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, instCol.getDataType());
            }
            this.appendConstrants(buffer, tableProxy, prettyPrint);
            this.appendTableConstraintsDefinition(buffer, table, prettyPrint);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k5.appendString(buffer, ')');
        }
    }

    private void appendFilegroup(StringBuffer buffer, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            if (tableProxy.getPartitionScheme() != null) {
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getPartitionScheme().getName()));
                if (tableProxy.getPartitioningColumn() != null) {
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '(');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getPartitioningColumn().getName()));
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ')');
                }
            } else if (tableProxy.getFilegroup() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getFilegroup().getName()));
            } else {
                SSBTableSqlServerv2k5.appendString(buffer, "\"default\"");
            }
        }
    }

    private void appendTextImage(StringBuffer buffer, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        if (tableProxy.getTextImageFG() != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "TEXTIMAGE_ON");
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getTextImageFG().getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
        }
    }

    private void appendColumnNameAndDataType(StringBuffer buffer, ColumnProxySqlServerv2k5 columnProxy, boolean prettyPrint) {
        String size;
        if (columnProxy.getName().length() > columnProxy.getMaxNameLength()) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, true, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
            SSBTableSqlServerv2k5.appendNewLine(buffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBTableSqlServerv2k5.appendString(buffer, ' ');
        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
        String datatype = columnProxy.getDatatypeString();
        if (datatype.equalsIgnoreCase("DATETIME") && columnProxy.getColumn().getParameters().containsKey("size") && !"0".equals(size = (String)columnProxy.getColumn().getParameters().get("size"))) {
            datatype = datatype.concat(" (" + size + ")");
        }
        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, datatype);
        if (datatype.equalsIgnoreCase("unknown")) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 5);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendColumnNullsAllowed(StringBuffer buffer, ColumnProxySqlServerv2k5 columnProxy) {
        if (!columnProxy.getNullsAllowed()) {
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "NOT NULL");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "NULL");
        }
    }

    private void appendColate(StringBuffer buffer, ColumnProxySqlServerv2k5 columnProxy) {
        if (!columnProxy.getCollation().trim().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "COLLATE");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, columnProxy.getCollation());
        }
    }

    private void appendDefault(StringBuffer buffer, ColumnProxySqlServer columnProxy) {
        if (!columnProxy.getDefineDefault() && !columnProxy.getDefaultValue().trim().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "DEFAULT");
            try {
                String defaultValue = columnProxy.getDefaultValue().trim();
                String dt = columnProxy.getColumn().getDatatypeString("SQL Server 2005");
                String df = this.addQuotesToDefault(dt, defaultValue);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, df);
            }
            catch (Exception e) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, columnProxy.getDefaultValue().trim());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            }
        }
    }

    private void appendIdentity(StringBuffer buffer, ColumnProxySqlServerv2k5 columnProxy) {
        if (!columnProxy.getDefineDefault() && columnProxy.getAsIdentity()) {
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "IDENTITY");
            if (!"1".equals(columnProxy.getIdentitySeed()) || columnProxy.getIdentityIncrement() != 1) {
                SSBTableSqlServerv2k5.appendString(buffer, '(');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, columnProxy.getIdentitySeed());
                this.appendComma(buffer);
                this.appendString(buffer, columnProxy.getIdentityIncrement());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ')');
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSqlServerv2k5.appendString(buffer, '(');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "1");
                this.appendComma(buffer);
                SSBTableSqlServerv2k5.appendString(buffer, "1");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ')');
            }
            if (columnProxy.getIdentityForReplication().equalsIgnoreCase("NO")) {
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "NOT FOR REPLICATION");
            }
        }
    }

    private void appendRowGuidCol(StringBuffer buffer, ColumnProxySqlServerv2k5 columnProxy) {
        if (columnProxy.getRowGuidCol().trim().equalsIgnoreCase("YES")) {
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ROWGUIDCOL");
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer buffer, Table table, boolean prettyPrint) {
        if (table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                this.appendComma(buffer);
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendString(buffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(constraint.getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CHECK");
                SSBTableSqlServerv2k5.appendString(buffer, '(');
                SSBTableSqlServerv2k5.appendString(buffer, constraint.getRule());
                SSBTableSqlServerv2k5.appendString(buffer, ')');
            }
        }
    }

    private void appendConstrants(StringBuffer buffer, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        this.appendPKey(buffer, tableProxy, prettyPrint);
        this.appendUniqueKeys(buffer, tableProxy, prettyPrint);
    }

    private void appendPKey(StringBuffer buffer, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        StorageObjectCollection pkeys = tableProxy.getPkeys();
        Iterator it = pkeys.iterator();
        while (it.hasNext()) {
            PKProxySqlServerv2k5 pkey = (PKProxySqlServerv2k5)it.next();
            ColumnProxy[] proxies = pkey.getColumnProxies();
            if (proxies.length <= 0 || !pkey.isMarkedGenerate()) continue;
            if (!this.isContainXMLColumn(proxies)) {
                this.appendComma(buffer);
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendString(buffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkey.getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "PRIMARY KEY");
                if (pkey.isClustered()) {
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CLUSTERED");
                } else {
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "NONCLUSTERED");
                }
                for (int i = 0; i < proxies.length; ++i) {
                    if (i == 0) {
                        SSBTableSqlServerv2k5.appendString(buffer, '(');
                    } else {
                        buffer.append(", ");
                    }
                    ColumnProxy proxy = proxies[i];
                    String sortorder = "";
                    if (proxy.getObject() != null) {
                        sortorder = ((Index)pkey.getObject()).getColumnSortOrder(proxy.getObject());
                    }
                    if ("DESC".equalsIgnoreCase(sortorder)) {
                        SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()) + " " + sortorder);
                        continue;
                    }
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()) + " ASC");
                        continue;
                    }
                    SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()));
                }
                SSBTableSqlServerv2k5.appendString(buffer, ')');
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendString(buffer, ' ');
                if (!this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) continue;
                boolean needComma = false;
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "WITH");
                SSBTableSqlServerv2k5.appendString(buffer, '(');
                if (pkey.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    needComma = true;
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
                    needComma = true;
                }
                if (pkey.getFillFactor() > 0 && pkey.getFillFactor() < 100) {
                    if (needComma) {
                        this.appendComma(buffer);
                    }
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    this.appendStringWithSpace(buffer, pkey.getFillFactor());
                    needComma = true;
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if (needComma) {
                        this.appendComma(buffer);
                    }
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "0");
                    needComma = true;
                }
                if (pkey.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                    if (needComma) {
                        this.appendComma(buffer);
                    }
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "IGNORE_DUP_KEY");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    needComma = true;
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if (needComma) {
                        this.appendComma(buffer);
                    }
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "IGNORE_DUP_KEY");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
                    needComma = true;
                }
                if (pkey.getRecomputeStatistics().equalsIgnoreCase("NO")) {
                    if (needComma) {
                        this.appendComma(buffer);
                    }
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "STATISTICS_NORECOMPUTE");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    needComma = true;
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if (needComma) {
                        this.appendComma(buffer);
                    }
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "STATISTICS_NORECOMPUTE");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
                    needComma = true;
                }
                if (needComma) {
                    this.appendComma(buffer);
                }
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendString(buffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ALLOW_PAGE_LOCKS");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, pkey.getAllowPageLocks());
                this.appendComma(buffer);
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendString(buffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ALLOW_ROW_LOCKS");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, pkey.getAllowRowLocks());
                SSBTableSqlServerv2k5.appendString(buffer, ')');
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendString(buffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                if (pkey.getPartitionScheme() != null) {
                    this.appendStringWithSpace(buffer, pkey.getPartitionScheme());
                    if (pkey.getPartitioningColumn() == null) continue;
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '(');
                    this.appendStringWithSpace(buffer, pkey.getPartitioningColumn());
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (pkey.getFilegroup() != null) {
                    SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(pkey.getFilegroup().getName()));
                    continue;
                }
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "\"default\"");
                continue;
            }
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Constraint ");
            buffer.append(pkey.getName());
            buffer.append(" contains a column of XML type.");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            this.canWriteComma = false;
            DDLFileMaker.incrementErrors();
        }
    }

    private boolean isContainXMLColumn(ColumnProxy[] proxies) {
        for (int i = 0; i < proxies.length; ++i) {
            if (!proxies[i].getDataType().getName().equalsIgnoreCase("XML")) continue;
            return true;
        }
        return false;
    }

    private void appendUniqueKeys(StringBuffer buffer, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        StorageObjectCollection ukeys = tableProxy.getUkeys();
        Iterator it = ukeys.iterator();
        while (it.hasNext()) {
            UniqueProxySqlServerv2k5 ukey = (UniqueProxySqlServerv2k5)it.next();
            ColumnProxy[] proxies = ukey.getColumnProxies();
            if (proxies.length <= 0 || !ukey.isMarkedGenerate()) continue;
            if (!this.isContainXMLColumn(proxies)) {
                this.appendComma(buffer);
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendString(buffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ukey.getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "UNIQUE");
                if (ukey.isClustered()) {
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CLUSTERED");
                } else {
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "NONCLUSTERED");
                }
                for (int i = 0; i < proxies.length; ++i) {
                    if (i == 0) {
                        SSBTableSqlServerv2k5.appendString(buffer, '(');
                    } else {
                        buffer.append(", ");
                    }
                    ColumnProxy proxy = proxies[i];
                    String sortorder = "";
                    if (proxy.getObject() != null) {
                        sortorder = ((Index)ukey.getObject()).getColumnSortOrder(proxy.getObject());
                    }
                    if ("DESC".equalsIgnoreCase(sortorder)) {
                        SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()) + " " + sortorder);
                        continue;
                    }
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()) + " ASC");
                        continue;
                    }
                    SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(proxy.getName()));
                }
                SSBTableSqlServerv2k5.appendString(buffer, ')');
                if (!this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) continue;
                if (ukey.getFillFactor() > 0 && ukey.getFillFactor() < 100) {
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k5.appendString(buffer, ' ');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "WITH");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    this.appendStringWithSpace(buffer, ukey.getFillFactor());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k5.appendString(buffer, ' ');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "WITH");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "0");
                }
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendString(buffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                if (ukey.getPartitionScheme() != null) {
                    this.appendStringWithSpace(buffer, ukey.getPartitionScheme());
                    if (ukey.getPartitioningColumn() == null) continue;
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '(');
                    this.appendStringWithSpace(buffer, ukey.getPartitioningColumn());
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (ukey.getFilegroup() != null) {
                    this.appendStringWithSpace(buffer, ukey.getFilegroup());
                    continue;
                }
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "\"default\"");
                continue;
            }
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("-- Error - Constraint ");
            buffer.append(ukey.getName());
            buffer.append(" contains column of XML type.");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            this.canWriteComma = false;
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendColumnConstraints(StringBuffer buffer, Column column, ColumnProxySqlServer columnProxy) {
        String text;
        if (column.hasConstraintsDefinedForDDL() && !"".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName())))) {
            String cname = column.getConstraintName();
            if (column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                if (!cname.equals("") && cname.length() <= 128) {
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(cname));
                }
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CHECK");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '(');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, text);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected void appendTableCommentOn(StringBuffer buffer, Table table, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        block17: {
            block16: {
                String comment = null;
                String tableName = null;
                if (tableProxy != null && tableProxy.isCommentInRDBMSChanged()) {
                    comment = tableProxy.getCommentInRDBMS();
                    tableName = tableProxy.getName();
                } else if (table != null) {
                    comment = table.getCommentInRDBMS();
                    tableName = table.getName();
                }
                if (comment != null && !comment.trim().equalsIgnoreCase("")) {
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k5.appendString(buffer, '\'');
                    SSBTableSqlServerv2k5.appendString(buffer, comment);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    if (tableProxy != null && tableProxy.getSchema() != null) {
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, "SCHEMA");
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getSchema().getName());
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    } else if (tableProxy != null && tableProxy.getUser() != null) {
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, "USER");
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getUser().getName());
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    } else {
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, "USER");
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, "dbo");
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    }
                    SSBTableSqlServerv2k5.appendString(buffer, '\'');
                    SSBTableSqlServerv2k5.appendString(buffer, "TABLE");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k5.appendString(buffer, '\'');
                    SSBTableSqlServerv2k5.appendString(buffer, tableName);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k5.appendString(buffer, "GO");
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                }
                if (tableProxy == null) break block16;
                ColumnProxy[] columns = tableProxy.getColumnProxies();
                for (int i = 0; i < columns.length; ++i) {
                    ColumnProxy col = columns[i];
                    if (col.getCommentInRDBMS() != null && col.isCommentInRDBMSChanged()) {
                        this.appendColumnComment(buffer, col, tableProxy, prettyPrint);
                        continue;
                    }
                    this.appendColumnComment(buffer, (Column)col.getObject(), table, prettyPrint);
                }
                Iterator it = tableProxy.getPkeys().iterator();
                PKProxySqlServerv2k5 pkey = null;
                while (it.hasNext()) {
                    pkey = (PKProxySqlServerv2k5)it.next();
                    if (pkey.getCommentInRDBMS() != null && pkey.isCommentInRDBMSChanged()) {
                        this.appendPKeyComment(buffer, pkey, tableProxy, prettyPrint);
                        continue;
                    }
                    this.appendIndexComment(buffer, (Index)pkey.getObject(), table, prettyPrint);
                }
                it = tableProxy.getUkeys().iterator();
                UniqueProxySqlServerv2k5 ukey = null;
                while (it.hasNext()) {
                    ukey = (UniqueProxySqlServerv2k5)it.next();
                    if (ukey.getCommentInRDBMS() != null && ukey.isCommentInRDBMSChanged()) {
                        this.appendUKeyComment(buffer, ukey, tableProxy, prettyPrint);
                        continue;
                    }
                    this.appendIndexComment(buffer, (Index)ukey.getObject(), table, prettyPrint);
                }
                break block17;
            }
            if (table == null) break block17;
            ContainedObject[] columns = table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                Column col = (Column)columns[i];
                if (col.getCommentInRDBMS() == null) continue;
                this.appendColumnComment(buffer, col, table, prettyPrint);
            }
            Iterator it = table.getPKeys().iterator();
            Index pkey = null;
            while (it.hasNext()) {
                pkey = (Index)it.next();
                if (pkey.getCommentInRDBMS() == null) continue;
                this.appendIndexComment(buffer, pkey, table, prettyPrint);
            }
        }
    }

    protected void appendColumnComment(StringBuffer buffer, ColumnProxy col, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !col.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, col.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (tableProxy.getSchema() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getSchema().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (tableProxy.getUser() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getUser().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "dbo");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "COLUMN");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, col.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendString(buffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendColumnComment(StringBuffer buffer, Column col, Table table, boolean prettyPrint) {
        if (!col.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, col.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            TableProxySqlServerv2k5 tableProxy = (TableProxySqlServerv2k5)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            if (tableProxy != null && tableProxy.getSchema() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getSchema().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (tableProxy != null && tableProxy.getUser() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getUser().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "dbo");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, table.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "COLUMN");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, col.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendString(buffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendPKeyComment(StringBuffer buffer, PKProxySqlServerv2k5 index, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !index.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, index.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (tableProxy.getSchema() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getSchema().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (tableProxy.getUser() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getUser().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "dbo");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "CONSTRAINT");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, index.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendString(buffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendUKeyComment(StringBuffer buffer, UniqueProxySqlServerv2k5 index, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !index.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, index.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (tableProxy.getSchema() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getSchema().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (tableProxy.getUser() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getUser().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "dbo");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "CONSTRAINT");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, index.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendString(buffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    protected void appendIndexComment(StringBuffer buffer, Index index, Table table, boolean prettyPrint) {
        if (!index.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, index.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            TableProxySqlServerv2k5 tableProxy = (TableProxySqlServerv2k5)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            if (tableProxy != null && tableProxy.getSchema() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getSchema().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (tableProxy != null && tableProxy.getUser() != null) {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, tableProxy.getUser().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTableSqlServerv2k5.appendString(buffer, '\'');
                SSBTableSqlServerv2k5.appendString(buffer, "dbo");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, table.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, "CONSTRAINT");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTableSqlServerv2k5.appendString(buffer, '\'');
            SSBTableSqlServerv2k5.appendString(buffer, index.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendString(buffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy[] colProxies = tableProxy.getColumnProxies();
        for (int i = 0; i < colProxies.length; ++i) {
            String text;
            ColumnProxy columnProxy = colProxies[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefinedForDDL() || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC() || "".equals(text = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName())))) continue;
            String cname = this.storageDesign.getFormatedName(column.getConstraintName());
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ALTER");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname) && cname.length() <= 128) {
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, cname);
            }
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CHECK");
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '(');
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, text);
            SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ')');
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSqlServerv2k5.appendString(buffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
        }
    }

    private void appendTableCheckConstraints(StringBuffer buffer, TableProxy tableProxy, boolean prettyPrint) {
        Table table = (Table)tableProxy.getObject();
        if (!table.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
            for (TableLevelConstraint constraint : table.getCheckConstraints()) {
                String text = constraint.getRule();
                if ("".equals(text)) continue;
                String cname = this.storageDesign.getFormatedName(constraint.getName());
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ALTER");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "TABLE");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "ADD");
                if (!"".equals(cname) && cname.length() <= 128) {
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CONSTRAINT");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, cname);
                }
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "CHECK");
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '(');
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, text);
                SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ')');
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBTableSqlServerv2k5.appendString(buffer, "GO");
                SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxySqlServerv2k5 && ((TableProxySqlServerv2k5)object).getDatabase() != null && !((TableProxySqlServerv2k5)object).getDatabase().isNullInstance();
    }

    private void appendExtProperties(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableProxySqlServerv2k5 tableProxy = (TableProxySqlServerv2k5)object;
        if (!"".equalsIgnoreCase(tableProxy.getProps())) {
            int i = 0;
            if (tableProxy.getSchema() != null || tableProxy.getUser() != null) {
                while (i < tableProxy.getExtPropsSet().size() - 1) {
                    String name = '\'' + (String)tableProxy.getExtPropsSet().get(i) + '\'';
                    String value = '\'' + (String)tableProxy.getExtPropsSet().get(++i) + '\'';
                    ++i;
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
                    String props = name + ", " + value;
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, props);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    if (tableProxy.getSchema() != null) {
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, "SCHEMA");
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                        SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getSchema().getName()));
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    } else {
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, "USER");
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                        SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getUser().getName()));
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    }
                    SSBTableSqlServerv2k5.appendString(buffer, '\'');
                    SSBTableSqlServerv2k5.appendString(buffer, "TABLE");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getName()));
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k5.appendString(buffer, "GO");
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                }
            }
        }
    }

    private void appendColumnExtProperties(StringBuffer buffer, Table table, TableProxySqlServerv2k5 tableProxy, boolean prettyPrint) {
        Column[] columns = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k5 columnProxy = null;
        SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        if (tableProxy != null) {
            for (int j = 0; j < columns.length; ++j) {
                column = columns[j];
                columnProxy = (ColumnProxySqlServerv2k5)tableProxy.getColumnProxy(column.getObjectID());
                if ("".equalsIgnoreCase(columnProxy.getProps())) continue;
                int i = 0;
                while (i < columnProxy.getExtPropsSet().size() - 1) {
                    if (tableProxy.getSchema() == null && tableProxy.getUser() == null) continue;
                    String name = '\'' + (String)columnProxy.getExtPropsSet().get(i) + '\'';
                    String value = '\'' + (String)columnProxy.getExtPropsSet().get(++i) + '\'';
                    ++i;
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
                    String props = name + ", " + value;
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, props);
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    if (tableProxy.getSchema() != null) {
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, "SCHEMA");
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                        SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getSchema().getName()));
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    } else {
                        SSBTableSqlServerv2k5.appendString(buffer, '\'');
                        SSBTableSqlServerv2k5.appendString(buffer, "USER");
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                        SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getUser().getName()));
                        SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    }
                    SSBTableSqlServerv2k5.appendString(buffer, '\'');
                    SSBTableSqlServerv2k5.appendString(buffer, "TABLE");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(tableProxy.getName()));
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k5.appendString(buffer, '\'');
                    SSBTableSqlServerv2k5.appendString(buffer, "COLUMN");
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(buffer, ',');
                    SSBTableSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableSqlServerv2k5.appendString(buffer, "GO");
                    SSBTableSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                }
            }
        }
    }

    private void appendIndexesForConstraints(StringBuffer oldbuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keys = table.getKeys();
        boolean genPK = table.getDesign().getDesignLevelSettings().isAutomaticPKGeneration();
        boolean genUK = table.getDesign().getDesignLevelSettings().isAutomaticUKGeneration();
        boolean genFK = table.getDesign().getDesignLevelSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keys.length; ++i) {
            Index ind;
            ContainedObject[] cols;
            Index index = (Index)keys[i];
            if (!(genPK && "Primary Constraint".equals(index.getIndexState()) || genUK && "Unique Constraint".equals(index.getIndexState())) && (!index.isFK() || !genFK) || (cols = index.getElements()).length <= 0 || (ind = this.getIndexForColumns(table, index, cols, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(oldbuffer, index, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] cols, boolean ascending) {
        Object[] inds = table.getIndexes().toArray();
        for (int i = 0; i < inds.length; ++i) {
            DesignObjectPlaceHolder dph = (DesignObjectPlaceHolder)inds[i];
            Index ind = (Index)dph.getDesignObject();
            ContainedObject[] icols = ind.getElements();
            if (cols.length != icols.length) continue;
            boolean brflag = false;
            for (int j = 0; j < cols.length; ++j) {
                String so;
                if (cols[j] != icols[j]) {
                    brflag = true;
                    break;
                }
                if (!ascending || "ASC".equalsIgnoreCase(so = ind.getColumnSortOrder(icols[j]).trim()) || "".equalsIgnoreCase(so)) continue;
                brflag = true;
                break;
            }
            if (brflag || ind == index) continue;
            return ind;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }
}

