/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TriggerSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerSqlServerv2k5
extends AbstractSSBSqlServer {
    StorageDesignSqlServerv2k5 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TriggerSqlServerv2k5 trigger = (TriggerSqlServerv2k5)object;
        this.appendComment(buffer, trigger);
        if (!trigger.getActions().trim().equalsIgnoreCase("")) {
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            this.appendCreate(buffer, trigger);
            this.appendOnTable(buffer, trigger);
            this.appendWithEncription(buffer, trigger, prettyPrint);
            this.appendTriggeringTime(buffer, trigger, prettyPrint);
            this.appendAction(buffer, trigger);
            this.appendReplication(buffer, trigger, prettyPrint);
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "AS");
            this.appendTriggeredAction(buffer, trigger, prettyPrint);
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementCreateTrigger();
            this.appendSetTriggerOrder(buffer, trigger, prettyPrint);
            if (trigger.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTriggerComment(buffer, trigger, prettyPrint);
            }
        } else {
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "-- invalid trigger: without action");
        }
    }

    private void appendTriggerComment(StringBuffer buffer, TriggerSqlServerv2k5 trigger, boolean prettyPrint) {
        String comment = trigger.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
            SSBTriggerSqlServerv2k5.appendString(buffer, comment);
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (trigger != null && trigger.getSchema() != null) {
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, trigger.getSchema().getName());
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (trigger != null && trigger.getOwner() != null) {
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, "USER");
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, trigger.getOwner().getName());
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, "USER");
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, "dbo");
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            if (trigger.getTable() != null) {
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, "TABLE");
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, trigger.getTable().getLongNameDDL());
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (trigger.getView() != null) {
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, "VIEW");
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, trigger.getView().getLongNameDDL());
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
            SSBTriggerSqlServerv2k5.appendString(buffer, "TRIGGER");
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
            SSBTriggerSqlServerv2k5.appendString(buffer, trigger.getName());
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBTriggerSqlServerv2k5.appendString(buffer, "GO");
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendCreate(StringBuffer buffer, TriggerSqlServerv2k5 trigger) {
        this.appendCreate(buffer);
        SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "TRIGGER");
        if (trigger.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBTriggerSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(trigger.getSchema().getName()));
            SSBTriggerSqlServerv2k5.appendString(buffer, '.');
        }
        SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getName()));
    }

    private void appendOnTable(StringBuffer buffer, TriggerSqlServerv2k5 trigger) {
        SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "ON");
        if (trigger.getTable() != null) {
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getTable().getName()));
        } else {
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(trigger.getView().getName()));
        }
    }

    private void appendWithEncription(StringBuffer buffer, TriggerSqlServerv2k5 trigger, boolean prettyPrint) {
        if (trigger.getEncription().equalsIgnoreCase("YES") && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "WITH");
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "ENCRYPTION");
        }
    }

    private void appendTriggeringTime(StringBuffer buffer, TriggerSqlServerv2k5 trigger, boolean prettyPrint) {
        SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "AFTER");
        }
        SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, trigger.getTriggerTime());
    }

    private void appendAction(StringBuffer buffer, TriggerSqlServerv2k5 trigger) {
        for (int i = 0; i < trigger.getActionSet().size(); ++i) {
            if (i > 0) {
                this.appendComma(buffer);
            }
            this.appendStringWithSpace(buffer, trigger.getActionSet().elementAt(i));
        }
    }

    private void appendReplication(StringBuffer buffer, TriggerSqlServerv2k5 trigger, boolean prettyPrint) {
        if (trigger.getForReplication().equalsIgnoreCase("NO")) {
            SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "NOT FOR REPLICATION");
        }
    }

    private void appendTriggeredAction(StringBuffer buffer, TriggerSqlServerv2k5 trigger, boolean prettyPrint) {
        SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        if (trigger.getBody().equalsIgnoreCase("")) {
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "-- Empty body");
        } else {
            SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, trigger.getBody());
        }
    }

    private void appendSetTriggerOrder(StringBuffer buffer, TriggerSqlServerv2k5 trigger, boolean prettyPrint) {
        if (!trigger.getExecutionOrder().equalsIgnoreCase(TriggerSqlServer.EXECUTION_ORDERS[0])) {
            Iterator it = trigger.getActionSet().iterator();
            while (it.hasNext()) {
                SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "sp_settriggerorder");
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, trigger.getName());
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                this.appendComma(buffer);
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendString(buffer, trigger.getExecutionOrder());
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                this.appendComma(buffer);
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                this.appendString(buffer, it.next());
                SSBTriggerSqlServerv2k5.appendString(buffer, '\'');
                SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBTriggerSqlServerv2k5.appendStringWithSpace(buffer, "GO");
                SSBTriggerSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerSqlServerv2k5 && ((TriggerSqlServerv2k5)object).isMarkedGenerate() && (((TriggerSqlServer)object).getTable() != null || ((TriggerSqlServer)object).getView() != null);
    }
}

