/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIncompleteStructuredTypeUDB
extends AbstractSSBUDB {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof StructuredTypeProxyUDB && ((StructuredTypeProxyUDB)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof StructuredType && ((StructuredType)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof StructuredType) {
            StructuredType type = (StructuredType)object;
            SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, type);
            this.appendIncompleteDefinition(buffer, type, prettyPrint);
            DDLFileMaker.incrementCreateStructuredType();
        } else if (object instanceof StructuredTypeProxyUDB) {
            StructuredTypeProxyUDB typeProxy = (StructuredTypeProxyUDB)object;
            StructuredType type = typeProxy.getStructuredType();
            SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, typeProxy);
            boolean used = type.getDesign().hasUsageOfStructuredType(type);
            if (!type.isInstantiable() && used) {
                SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, true, 0);
                SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "--  ERROR: Type " + type.getName() + " is defined as not instantiable but it's used");
                SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, true, 0);
                SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "--  in table/view definition - generated as instantiable");
                SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, true, 0);
                DDLFileMaker.incrementErrors();
            }
            if (!type.isPredefined()) {
                this.appendIncompleteDefinition(buffer, typeProxy, prettyPrint);
                DDLFileMaker.incrementCreateStructuredType();
            }
        }
    }

    private void appendIncompleteDefinition(StringBuffer buffer, StructuredType type, boolean prettyPrint) {
        SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "CREATE");
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "TYPE");
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, type.getName());
        SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
    }

    private void appendIncompleteDefinition(StringBuffer buffer, StructuredTypeProxyUDB typeProxy, boolean prettyPrint) {
        StructuredType type = typeProxy.getStructuredType();
        SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "CREATE");
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "TYPE");
        if (typeProxy.getSchema() != null && typeProxy.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBIncompleteStructuredTypeUDB.appendString(buffer, typeProxy.getStorageDesign().getFormatedName(typeProxy.getSchema().getName()));
            SSBIncompleteStructuredTypeUDB.appendString(buffer, '.');
        }
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, typeProxy.getStorageDesign().getFormatedName(typeProxy.getName()));
        if (typeProxy.hasParentType()) {
            StructuredTypeProxyUDB parent = (StructuredTypeProxyUDB)typeProxy.getParentType();
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "UNDER");
            if (typeProxy.getSchema() != null && typeProxy.getAppView().getSettings().isIncludeSchemaInDDL()) {
                this.appendString(buffer, parent.getSchema());
                SSBIncompleteStructuredTypeUDB.appendString(buffer, '.');
            }
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, parent.getName());
        }
        boolean used = type.getDesign().hasUsageOfStructuredType(type);
        SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
        if (!type.isInstantiable() && !used) {
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "NOT");
        }
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "INSTANTIABLE");
        if (!"".equalsIgnoreCase(typeProxy.getInlineLength())) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "INLINE");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "LENGTH");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, typeProxy.getInlineLength());
        }
        if (!type.isFinal()) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "NOT");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "FINAL");
        }
        SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "MODE DB2SQL");
        if ("YES".equalsIgnoreCase(typeProxy.getWithFunctionAccess())) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "WITH");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "FUNCTION");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "ACCESS");
        }
        if (typeProxy.getType() != null) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "REF");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "USING");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, typeProxy.getDataType());
        }
        if (!"".equalsIgnoreCase(typeProxy.getRefType2RefCastFunction())) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "CAST");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "(SOURCE AS REF)");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "WITH");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, typeProxy.getRefType2RefCastFunction());
        }
        if (!"".equalsIgnoreCase(typeProxy.getRef2RefTypeCastFunction())) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "CAST");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "(REF AS SOURCE)");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, "WITH");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(buffer, typeProxy.getRef2RefTypeCastFunction());
        }
        SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        SSBIncompleteStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
    }
}

