/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.PermissionsUDBv71;

public class SSBPermissionsUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PermissionsUDBv71 permissions = (PermissionsUDBv71)object;
        if (!(permissions.getTable() == null && permissions.getView() == null || permissions.getUser() == null && permissions.getGroup() == null)) {
            this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
            if (!"".equalsIgnoreCase(permissions.getPrivileges())) {
                this.appendComment(buffer, permissions);
                SSBPermissionsUDBv71.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsUDBv71.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsUDBv71.appendString(buffer, permissions.getPrivileges());
                }
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv71.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv71.appendStringWithSpace(buffer, "TO");
                if (permissions.getUser() != null) {
                    SSBPermissionsUDBv71.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                } else if (permissions.getGroup() != null) {
                    SSBPermissionsUDBv71.appendString(buffer, this.storageDesign.getFormatedName(permissions.getGroup().getName()));
                }
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getPrivilegesWithGrantOption())) {
                this.appendComment(buffer, permissions);
                SSBPermissionsUDBv71.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesWithGrantOptionSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsUDBv71.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsUDBv71.appendString(buffer, permissions.getPrivilegesWithGrantOption());
                }
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv71.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv71.appendStringWithSpace(buffer, "TO");
                if (permissions.getUser() != null) {
                    SSBPermissionsUDBv71.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                } else if (permissions.getGroup() != null) {
                    SSBPermissionsUDBv71.appendString(buffer, this.storageDesign.getFormatedName(permissions.getGroup().getName()));
                }
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv71.appendStringWithSpace(buffer, "WITH GRANT OPTION");
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getColumnList())) {
                StringTokenizer st = new StringTokenizer(permissions.getColumnList(), "|");
                String priv = "";
                while (st.hasMoreTokens()) {
                    String col = st.nextToken();
                    if (col.indexOf(44) <= -1) continue;
                    priv = col.substring(col.indexOf(44) + 1).trim();
                    col = col.substring(0, col.indexOf(44));
                    this.appendComment(buffer, permissions);
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, "GRANT");
                    SSBPermissionsUDBv71.appendString(buffer, priv);
                    SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, '(');
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, col);
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, ')');
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, "ON");
                    if (permissions.getTable() != null) {
                        SSBPermissionsUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                    } else if (permissions.getView() != null) {
                        SSBPermissionsUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                    }
                    SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsUDBv71.appendStringWithSpace(buffer, "TO");
                    if (permissions.getUser() != null) {
                        SSBPermissionsUDBv71.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                    } else if (permissions.getGroup() != null) {
                        SSBPermissionsUDBv71.appendString(buffer, this.storageDesign.getFormatedName(permissions.getGroup().getName()));
                    }
                    SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    SSBPermissionsUDBv71.appendNewLine(buffer, prettyPrint, 1);
                }
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof PermissionsUDBv71) {
            PermissionsUDBv71 perm = (PermissionsUDBv71)object;
            if (perm.getTable() != null) {
                return true;
            }
            if (perm.getView() != null) {
                return true;
            }
        }
        return false;
    }
}

