/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.ContainerUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;
    public static final String PAGESIZE = "PAGESIZE";
    public static final String MANAGED_BY = "MANAGED BY";
    public static final String EXTENTSIZE = "EXTENTSIZE";
    public static final String PREFETCHSIZE = "PREFETCHSIZE";
    public static final String OVERHEAD = "OVERHEAD";
    public static final String TRANSFERRATE = "TRANSFERRATE";
    public static final String DROPPED_TABLE_RECOVERY = "DROPPED TABLE RECOVERY";
    public static final String ON_NODE = "ON NODE";
    public static final String ON_NODES = "ON NODES";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceUDBv71 && ((TableSpaceUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableSpaceUDBv71 tablespace = (TableSpaceUDBv71)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        if (!tablespace.getDBDefOnly()) {
            this.appendComment(buffer, tablespace);
            this.appendCreate(buffer, tablespace);
            this.appendNodeGroup(buffer, tablespace, prettyPrint);
            this.appendPageSize(buffer, tablespace, prettyPrint);
            this.appendManagedBy(buffer, tablespace);
            this.appendUsingContainer(buffer, tablespace, prettyPrint);
            this.appendExtentSize(buffer, tablespace, prettyPrint);
            this.appendPrefetchSize(buffer, tablespace, prettyPrint);
            this.appendBufferPool(buffer, tablespace, prettyPrint);
            this.appendOverhead(buffer, tablespace, prettyPrint);
            this.appendTransferRate(buffer, tablespace, prettyPrint);
            this.appendDroppedTableRecovery(buffer, tablespace, prettyPrint);
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateTablespace();
            if (tablespace.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOn(buffer, tablespace, prettyPrint);
            }
        }
        this.appendUsePrivileges(buffer, tablespace, prettyPrint);
    }

    private void appendCommentOn(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 0);
        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "COMMENT ON");
        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "TABLESPACE");
        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace.getLongNameDDL()));
        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "IS");
        SSBTableSpaceUDBv71.appendString(buffer, '\'');
        SSBTableSpaceUDBv71.appendString(buffer, tablespace.getCommentInRDBMS());
        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, '\'');
        SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, TableSpaceUDBv71 tablespace) {
        this.appendCreate(buffer);
        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, tablespace.getDataType());
        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "TABLESPACE");
        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace.getName()));
    }

    protected void appendNodeGroup(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        if (tablespace.getNodeGroup() != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "IN");
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "NODEGROUP");
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace.getNodeGroup().getName()));
        }
    }

    protected void appendPageSize(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        if (tablespace.getPageSize() > 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, PAGESIZE);
            this.appendStringWithSpace(buffer, tablespace.getPageSize());
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, 'K');
        }
    }

    protected void appendManagedBy(StringBuffer buffer, TableSpaceUDBv71 tablespace) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, MANAGED_BY);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, tablespace.getManagedBy());
        }
    }

    protected void appendExtentSize(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(tablespace.getExtentSize()) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, EXTENTSIZE);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, tablespace.getExtentSize());
        }
    }

    protected void appendPrefetchSize(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(tablespace.getPrefetchSize()) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, PREFETCHSIZE);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, tablespace.getPrefetchSize());
        }
    }

    protected void appendBufferPool(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (tablespace.getBufferPool() != null) {
                SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "BUFFERPOOL");
                this.appendStringWithSpace(buffer, tablespace.getBufferPool());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "BUFFERPOOL");
                SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "IBMDEFAULTBP");
            }
        }
    }

    protected void appendOverhead(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        if (tablespace.getOverhead() > 0.0f && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, OVERHEAD);
            this.appendStringWithSpace(buffer, tablespace.getOverhead());
        }
    }

    protected void appendTransferRate(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        if (tablespace.getTransferRate() > 0.0f && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, TRANSFERRATE);
            this.appendStringWithSpace(buffer, tablespace.getTransferRate());
        }
    }

    protected void appendDroppedTableRecovery(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        if (tablespace.getDataType().equalsIgnoreCase("REGULAR")) {
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, DROPPED_TABLE_RECOVERY);
            this.appendOnOffWithSpace(buffer, tablespace.getDroppedTableRecovery());
        }
    }

    protected void appendUsingContainer(StringBuffer buffer, TableSpaceUDBv71 tablespace, boolean prettyPrint) {
        block6: {
            ContainerUDB[] containers = tablespace.getContainers();
            if (containers.length <= 0) break block6;
            List allNodes = tablespace.getAllNodes();
            if (tablespace.getManagedBy().equalsIgnoreCase("SYSTEM")) {
                for (int i = 0; i < allNodes.size(); ++i) {
                    SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    String node = allNodes.get(i).toString();
                    ContainerUDB[] containersForNode = tablespace.getContainersForNode(node);
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "USING");
                    SSBTableSpaceUDBv71.appendString(buffer, '(');
                    for (int j = 0; j < containersForNode.length; ++j) {
                        ContainerUDBv71 container = (ContainerUDBv71)containersForNode[j];
                        SSBTableSpaceUDBv71.appendString(buffer, container.getContainers().trim());
                        if (j >= containersForNode.length - 1) continue;
                        buffer.append(", ");
                    }
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, ')');
                    if (node.equalsIgnoreCase("")) continue;
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, ON_NODE);
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, '(');
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, node.trim());
                    SSBTableSpaceUDBv71.appendString(buffer, ')');
                }
            } else {
                for (int i = 0; i < allNodes.size(); ++i) {
                    SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    String node = allNodes.get(i).toString();
                    ContainerUDB[] containersForNode = tablespace.getContainersForNode(node);
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "USING");
                    SSBTableSpaceUDBv71.appendString(buffer, '(');
                    for (int j = 0; j < containersForNode.length; ++j) {
                        ContainerUDBv71 container = (ContainerUDBv71)containersForNode[j];
                        SSBTableSpaceUDBv71.appendString(buffer, container.getContainers().trim());
                        if (j >= containersForNode.length - 1) continue;
                        buffer.append(", ");
                    }
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, ')');
                    if (node.equalsIgnoreCase("")) continue;
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, ON_NODE);
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, '(');
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, node);
                    SSBTableSpaceUDBv71.appendString(buffer, ')');
                }
            }
        }
    }

    private void appendUsePrivileges(StringBuffer buffer, TableSpaceUDB ts, boolean prettyPrint) {
        if (!ts.getUsers().equalsIgnoreCase("") || !ts.getGroups().equalsIgnoreCase("")) {
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "GRANT");
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "USE");
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "OF");
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "TABLESPACE");
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts.getName()));
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "TO");
            if (!ts.getUsers().equalsIgnoreCase("")) {
                int i;
                for (i = 0; i < ts.getUserSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(buffer);
                    }
                    if (!((String)ts.getUserSet().elementAt(i)).trim().equalsIgnoreCase("PUBLIC")) {
                        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "USER");
                    }
                    this.appendStringWithSpace(buffer, ts.getUserSet().elementAt(i));
                }
                if (!ts.getGroups().equalsIgnoreCase("")) {
                    for (i = 0; i < ts.getUserGroupSet().size(); ++i) {
                        this.appendComma(buffer);
                        SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "GROUP");
                        this.appendStringWithSpace(buffer, ts.getUserGroupSet().elementAt(i));
                    }
                }
            } else {
                for (int i = 0; i < ts.getUserGroupSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(buffer);
                    }
                    SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "GROUP");
                    this.appendStringWithSpace(buffer, ts.getUserGroupSet().elementAt(i));
                }
            }
            if ("YES".equalsIgnoreCase(ts.getGrantOption())) {
                SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableSpaceUDBv71.appendStringWithSpace(buffer, "WITH GRANT OPTION");
            }
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            SSBTableSpaceUDBv71.appendNewLine(buffer, prettyPrint, 0);
        }
    }
}

