/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.PermissionsUDBv81;

public class SSBPermissionsUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PermissionsUDBv81 permissions = (PermissionsUDBv81)object;
        if (!(permissions.getTable() == null && permissions.getView() == null || permissions.getUser() == null && permissions.getGroup() == null)) {
            this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
            if (!"".equalsIgnoreCase(permissions.getPrivileges())) {
                this.appendComment(buffer, permissions);
                SSBPermissionsUDBv81.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsUDBv81.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsUDBv81.appendString(buffer, permissions.getPrivileges());
                }
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv81.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv81.appendStringWithSpace(buffer, "TO");
                if (permissions.getUser() != null) {
                    SSBPermissionsUDBv81.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                } else if (permissions.getGroup() != null) {
                    SSBPermissionsUDBv81.appendString(buffer, this.storageDesign.getFormatedName(permissions.getGroup().getName()));
                }
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getPrivilegesWithGrantOption())) {
                this.appendComment(buffer, permissions);
                SSBPermissionsUDBv81.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesWithGrantOptionSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsUDBv81.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsUDBv81.appendString(buffer, permissions.getPrivilegesWithGrantOption());
                }
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv81.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv81.appendStringWithSpace(buffer, "TO");
                if (permissions.getUser() != null) {
                    SSBPermissionsUDBv81.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                } else if (permissions.getGroup() != null) {
                    SSBPermissionsUDBv81.appendString(buffer, this.storageDesign.getFormatedName(permissions.getGroup().getName()));
                }
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsUDBv81.appendStringWithSpace(buffer, "WITH GRANT OPTION");
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getColumnList())) {
                StringTokenizer st = new StringTokenizer(permissions.getColumnList(), "|");
                String priv = "";
                while (st.hasMoreTokens()) {
                    String col = st.nextToken();
                    if (col.indexOf(44) <= -1) continue;
                    priv = col.substring(col.indexOf(44) + 1).trim();
                    col = col.substring(0, col.indexOf(44));
                    this.appendComment(buffer, permissions);
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, "GRANT");
                    SSBPermissionsUDBv81.appendString(buffer, priv);
                    SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, '(');
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(col));
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, ')');
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, "ON");
                    if (permissions.getTable() != null) {
                        SSBPermissionsUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                    } else if (permissions.getView() != null) {
                        SSBPermissionsUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                    }
                    SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsUDBv81.appendStringWithSpace(buffer, "TO");
                    if (permissions.getUser() != null) {
                        SSBPermissionsUDBv81.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                    } else if (permissions.getGroup() != null) {
                        SSBPermissionsUDBv81.appendString(buffer, this.storageDesign.getFormatedName(permissions.getGroup().getName()));
                    }
                    SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    SSBPermissionsUDBv81.appendNewLine(buffer, prettyPrint, 1);
                }
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof PermissionsUDBv81) {
            PermissionsUDBv81 perm = (PermissionsUDBv81)object;
            if (perm.getTable() != null) {
                return true;
            }
            if (perm.getView() != null) {
                return true;
            }
        }
        return false;
    }
}

