/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SequenceUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSequenceUDBv81
extends AbstractSSBUDB {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        SequenceUDBv81 sequence = (SequenceUDBv81)object;
        this.storageDesign = sequence.getStorageDesign();
        this.appendComment(buffer, sequence);
        this.appendCreateSequnce(buffer, sequence, prettyPrint);
        SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateSequence();
        this.appendGrant(buffer, sequence, prettyPrint);
    }

    private void appendCreateSequnce(StringBuffer buffer, SequenceUDBv81 sequence, boolean prettyPrint) {
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(sequence);
        this.appendCreate(buffer);
        SSBSequenceUDBv81.appendStringWithSpace(buffer, "SEQUENCE");
        if (sequence.getSchema() != null && storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBSequenceUDBv81.appendString(buffer, storageDesign.getFormatedName(sequence.getSchema().getName()));
            SSBSequenceUDBv81.appendString(buffer, ".");
        }
        SSBSequenceUDBv81.appendStringWithSpace(buffer, storageDesign.getFormatedName(sequence.getName()));
        SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBSequenceUDBv81.appendStringWithSpace(buffer, "AS");
        SSBSequenceUDBv81.appendStringWithSpace(buffer, sequence.getDatatype());
        SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBSequenceUDBv81.appendStringWithSpace(buffer, "START");
        SSBSequenceUDBv81.appendStringWithSpace(buffer, "WITH");
        this.appendStringWithSpace(buffer, sequence.getStartWith());
        if (sequence.getIncrementBy() != 1) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "INCREMENT");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, sequence.getIncrementBy());
        } else if (storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "INCREMENT");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "BY");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "1");
        }
        if (!"".equalsIgnoreCase(sequence.getMinValue().trim()) && !"NO".equalsIgnoreCase(sequence.getMinValue().trim())) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "MINVALUE");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, sequence.getMinValue());
        } else if (storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "NO");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "MINVALUE");
        }
        if (!"".equalsIgnoreCase(sequence.getMaxValue().trim()) && !"NO".equalsIgnoreCase(sequence.getMaxValue().trim())) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "MAXVALUE");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, sequence.getMaxValue());
        } else if (storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "NO");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "MAXVALUE");
        }
        if (sequence.getCycle().trim().equalsIgnoreCase("YES")) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "CYCLE");
        } else if (storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "NO");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "CYCLE");
        }
        if (sequence.getCache() != 20) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            if (sequence.getCache() == 0) {
                SSBSequenceUDBv81.appendStringWithSpace(buffer, "NO");
                SSBSequenceUDBv81.appendStringWithSpace(buffer, "CACHE");
            } else {
                SSBSequenceUDBv81.appendStringWithSpace(buffer, "CACHE");
                this.appendStringWithSpace(buffer, sequence.getCache());
            }
        }
        if (sequence.getOrder().equalsIgnoreCase("YES")) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "ORDER");
        } else if (storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "NO");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "ORDER");
        }
    }

    private void appendGrant(StringBuffer buffer, SequenceUDBv81 sequence, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(sequence.getUsedByPublic())) {
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "GRANT");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "USAGE");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "ON");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "SEQUENCE");
            if (sequence.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                SSBSequenceUDBv81.appendString(buffer, this.storageDesign.getFormatedName(sequence.getSchema().getName()));
                SSBSequenceUDBv81.appendString(buffer, ".");
            }
            SSBSequenceUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sequence.getName()));
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "TO");
            SSBSequenceUDBv81.appendStringWithSpace(buffer, "PUBLIC");
            SSBSequenceUDBv81.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SequenceUDBv81 && ((SequenceUDBv81)object).isMarkedGenerate();
    }
}

