/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSAVT;
import oracle.dbtools.crest.exports.reports.RSCheckConstraint;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSValueRanges;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSAttributes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, LogicalDesign model, String modelOVID) throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        System.out.println("attr Begin  " + System.currentTimeMillis());
        String query = "INSERT INTO DMRS_ATTRIBUTES (Attribute_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, Mandatory, DataType_Kind, Value_Type, Formula, ScopeEntity_ID, ScopeEntity_OVID, Domain_ID, Domain_OVID, Logical_Type_ID, Logical_Type_OVID, Distinct_Type_ID, Distinct_Type_OVID, Structured_Type_ID, Structured_Type_OVID, Collection_Type_ID, Collection_Type_OVID, Check_Constraint_Name, Default_Value, Use_Domain_Constraint, Domain_Name, Logical_Type_Name, Structured_Type_Name, Distinct_Type_Name, Collection_Type_Name, Synonyms, Preferred_Abbreviation, Relationship_ID, Relationship_OVID, Entity_Name, PK_Flag, FK_Flag, Relationship_Name, Sequence, T_Size, T_Precision, T_Scale, Char_Units, Data_Source, ScopeEntity_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ArrayList<Attribute> list = new ArrayList<Attribute>(1000);
        int count = 0;
        attributes.clear();
        Iterator it = model.getAttributeSet().iterator();
        while (it.hasNext()) {
            Attribute attribute2 = (Attribute)it.next();
            if (attribute2.getContainerRelation() != null) continue;
            String ovid = new GUID().toString();
            map.put(attribute2.getObjectID(), ovid);
            attributes.add(attribute2);
            stmt.setString(1, attribute2.getName());
            stmt.setString(2, attribute2.getObjectID());
            stmt.setString(3, ovid);
            stmt.setString(4, attribute2.getImportedId());
            stmt.setString(5, attribute2.getContainer() != null ? attribute2.getContainer().getObjectID() : " ");
            stmt.setString(6, attribute2.getContainer() != null ? (String)map.get(attribute2.getContainer().getObjectID()) : " ");
            stmt.setString(7, attribute2.getNullsAllowed() ? "N" : "Y");
            switch (attribute2.getUse()) {
                case 0: {
                    stmt.setString(8, "Domain");
                    break;
                }
                case 1: {
                    stmt.setString(8, "Logical Type");
                    break;
                }
                case 2: {
                    stmt.setString(8, "Distinct Type");
                    break;
                }
                case 3: {
                    if (attribute2.isReference()) {
                        stmt.setString(8, "Ref Struct Type");
                        break;
                    }
                    stmt.setString(8, "Structured Type");
                    break;
                }
                case 4: {
                    stmt.setString(8, "Collection Type");
                }
            }
            stmt.setString(9, attribute2.getSourceType());
            stmt.setString(10, attribute2.getFormulaDesc());
            stmt.setString(11, attribute2.getScope() != null ? attribute2.getScope().getObjectID() : null);
            stmt.setString(12, attribute2.getScope() != null ? (String)map.get(attribute2.getScope().getObjectID()) : null);
            stmt.setString(13, attribute2.getDomain().getObjectID());
            stmt.setString(14, (String)map.get(attribute2.getDomain().getObjectID()));
            stmt.setString(17, attribute2.getDistinctType() != null ? attribute2.getDistinctType().getObjectID() : null);
            stmt.setString(18, attribute2.getDistinctType() != null ? (String)map.get(attribute2.getDistinctType().getObjectID()) : null);
            stmt.setString(19, attribute2.getStructuredType() != null ? attribute2.getStructuredType().getObjectID() : null);
            stmt.setString(20, attribute2.getStructuredType() != null ? (String)map.get(attribute2.getStructuredType().getObjectID()) : null);
            stmt.setString(21, attribute2.getCollectionType() != null ? attribute2.getCollectionType().getObjectID() : null);
            stmt.setString(22, attribute2.getCollectionType() != null ? (String)map.get(attribute2.getCollectionType().getObjectID()) : null);
            stmt.setString(23, attribute2.getConstraintName());
            stmt.setString(24, attribute2.getDefaultValue());
            stmt.setString(25, attribute2.getUseDomainConstraints() ? "Y" : "N");
            if (attribute2.getUse() == 0) {
                stmt.setString(26, attribute2.getDomain().getName());
                stmt.setString(27, attribute2.getDomain().getLogicalDatatype().getName());
                stmt.setString(15, attribute2.getDomain().getLogicalDatatype().getObjectID());
                stmt.setString(16, (String)map.get(attribute2.getDomain().getLogicalDatatype().getObjectID()));
            } else if (attribute2.getUse() == 1) {
                stmt.setString(26, null);
                stmt.setString(27, attribute2.getLogicalDatatype().getName());
                stmt.setString(15, attribute2.getLogicalDatatype().getObjectID());
                stmt.setString(16, (String)map.get(attribute2.getLogicalDatatype().getObjectID()));
            } else if (attribute2.getUse() == 2) {
                stmt.setString(26, null);
                stmt.setString(27, attribute2.getDistinctType().getLogicalDataType().getName());
                stmt.setString(15, attribute2.getDistinctType().getLogicalDataType().getObjectID());
                stmt.setString(16, (String)map.get(attribute2.getDistinctType().getLogicalDataType().getObjectID()));
            } else {
                stmt.setString(26, null);
                stmt.setString(27, null);
                stmt.setString(15, null);
                stmt.setString(16, null);
            }
            stmt.setString(28, attribute2.getStructuredType() != null ? attribute2.getStructuredType().getName() : null);
            stmt.setString(29, attribute2.getDistinctType() != null ? attribute2.getDistinctType().getName() : null);
            stmt.setString(30, attribute2.getCollectionType() != null ? attribute2.getCollectionType().getName() : null);
            stmt.setString(31, attribute2.getSynonym());
            stmt.setString(32, attribute2.getPreferredAbbreviation());
            if (attribute2.isFKAttribute()) {
                DesignObject gen = attribute2.getGenerator();
                stmt.setString(33, gen.getObjectID());
                stmt.setString(34, RSAttributes.getOrCreateOVID(map, gen.getObjectID()));
            } else {
                stmt.setString(33, null);
                stmt.setString(34, null);
            }
            stmt.setString(35, attribute2.getContainer() != null ? attribute2.getContainer().getName() : " ");
            stmt.setString(36, attribute2.isPKElement() ? "P" : null);
            stmt.setString(37, attribute2.isFKAttribute() ? "F" : null);
            stmt.setString(38, attribute2.isFKAttribute() ? attribute2.getGenerator().getName() : null);
            stmt.setInt(39, attribute2.getContainer() != null ? attribute2.getContainer().getIndexOf(attribute2) + 1 : 1);
            if (attribute2.getUse() == 0) {
                stmt.setString(40, attribute2.getDomain().getSize());
                stmt.setInt(41, RSAttributes.getIntValue(attribute2.getDomain().getPrecision()));
                stmt.setInt(42, RSAttributes.getIntValue(attribute2.getDomain().getScale()));
            } else if (attribute2.getUse() == 1) {
                String size = attribute2.getSize();
                String[] parts_n = size.split(" ");
                stmt.setString(40, parts_n[0]);
                stmt.setInt(41, RSAttributes.getIntValue(attribute2.getPrecision()));
                stmt.setInt(42, RSAttributes.getIntValue(attribute2.getScale()));
            } else {
                stmt.setInt(40, 0);
                stmt.setInt(41, 0);
                stmt.setInt(42, 0);
            }
            stmt.setString(43, attribute2.getUnits());
            stmt.setString(44, attribute2.getSource());
            stmt.setString(45, attribute2.getScope() != null ? attribute2.getScope().getName() : null);
            stmt.setString(46, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(attribute2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Attribute attribute2 : list) {
                RSObjectNotes.export(map, connection, attribute2);
                RSComments.export(map, connection, attribute2);
                RSCommentsInRDBMS.export(map, connection, attribute2);
                RSDynamicProperties.export(design, map, connection, attribute2);
            }
            list.clear();
        }
        RSAVT.export(connection, attributes, map, "Attribute");
        RSCheckConstraint.export(connection, attributes, map, "Attribute");
        RSValueRanges.export(connection, attributes, map, "Attribute");
        if (count > 0) {
            stmt.executeBatch();
            for (Attribute attribute : list) {
                RSObjectNotes.export(map, connection, attribute);
                RSComments.export(map, connection, attribute);
                RSCommentsInRDBMS.export(map, connection, attribute);
                RSDynamicProperties.export(design, map, connection, attribute);
            }
            list.clear();
        }
        System.out.println("attr End  " + System.currentTimeMillis());
        stmt.close();
        stmt = null;
    }
}

