/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSAVT;
import oracle.dbtools.crest.exports.reports.RSCheckConstraint;
import oracle.dbtools.crest.exports.reports.RSColumnUI;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSValueRanges;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class RSColumns
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Column> list = new ArrayList<Column>(1000);
        int count = 0;
        ArrayList<Column> mColumns = new ArrayList<Column>();
        String query = "INSERT INTO DMRS_COLUMNS (Column_Name, Abbreviation, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, Mandatory, DataType_Kind, Value_Type, Formula, ScopeEntity_ID, ScopeEntity_OVID, Domain_ID, Domain_OVID, Logical_Type_ID, Logical_Type_OVID, Distinct_Type_ID, Distinct_Type_OVID, Structured_Type_ID, Structured_Type_OVID, Collection_Type_ID, Collection_Type_OVID, Check_Constraint_Name, Default_Value, Use_Domain_Constraint, Domain_Name, Logical_Type_Name, Structured_Type_Name, Distinct_Type_Name, Collection_Type_Name, Uses_Default, Engineer, Table_Name, PK_Flag, FK_Flag, Native_Type, Sequence, Model_ID, Model_OVID, Model_Name, T_Size, T_Precision, T_Scale, Char_Units, Personally_ID_Information, Sensitive_Information, Mask_For_None_Production, Computed, ScopeEntity_Name, Auto_Increment_Column, Identity_Column, Auto_Increment_Generate_Always, Auto_Increment_Start_With, Auto_Increment_Increment_By, Auto_Increment_Min_Value, Auto_Increment_Max_Value, Auto_Increment_Cycle, Auto_Increment_Disable_Cache, Auto_Increment_Cache, Auto_Increment_Order, Auto_Increment_Sequence_Name, Auto_Increment_Trigger_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getRelationalDesigns().iterator();
        while (mit.hasNext()) {
            RelationalDesign model = (RelationalDesign)mit.next();
            String modelOVID = (String)map.get(model.getObjectID());
            mColumns.clear();
            Iterator it = model.getColumnSet().iterator();
            while (it.hasNext()) {
                Column column2 = (Column)it.next();
                String ovid = RSColumns.getOrCreateOVID(map, column2.getObjectID());
                mColumns.add(column2);
                stmt.setString(1, column2.getName());
                stmt.setString(2, column2.getAbbreviation());
                stmt.setString(3, column2.getObjectID());
                stmt.setString(4, ovid);
                stmt.setString(5, column2.getImportedId());
                stmt.setString(6, column2.getContainer().getObjectID());
                stmt.setString(7, (String)map.get(column2.getContainer().getObjectID()));
                stmt.setString(8, column2.getNullsAllowed() ? "N" : "Y");
                switch (column2.getUse()) {
                    case 0: {
                        stmt.setString(9, "Domain");
                        break;
                    }
                    case 1: {
                        stmt.setString(9, "Logical Type");
                        break;
                    }
                    case 2: {
                        stmt.setString(9, "Distinct Type");
                        break;
                    }
                    case 3: {
                        if (column2.isReference()) {
                            stmt.setString(9, "Ref Struct Type");
                            break;
                        }
                        stmt.setString(9, "Structured Type");
                        break;
                    }
                    case 4: {
                        stmt.setString(9, "Collection Type");
                    }
                }
                stmt.setString(10, column2.getSourceType());
                stmt.setString(11, column2.getFormulaDesc());
                stmt.setString(12, column2.getScope() != null ? column2.getScope().getObjectID() : null);
                stmt.setString(13, column2.getScope() != null ? (String)map.get(column2.getScope().getObjectID()) : null);
                stmt.setString(14, column2.getDomain().getObjectID());
                stmt.setString(15, (String)map.get(column2.getDomain().getObjectID()));
                stmt.setString(18, column2.getDistinctType() != null ? column2.getDistinctType().getObjectID() : null);
                stmt.setString(19, column2.getDistinctType() != null ? (String)map.get(column2.getDistinctType().getObjectID()) : null);
                stmt.setString(20, column2.getStructuredType() != null ? column2.getStructuredType().getObjectID() : null);
                stmt.setString(21, column2.getStructuredType() != null ? (String)map.get(column2.getStructuredType().getObjectID()) : null);
                stmt.setString(22, column2.getCollectionType() != null ? column2.getCollectionType().getObjectID() : null);
                stmt.setString(23, column2.getCollectionType() != null ? (String)map.get(column2.getCollectionType().getObjectID()) : null);
                stmt.setString(24, column2.getConstraintName());
                stmt.setString(25, column2.getDefaultValue());
                stmt.setString(26, column2.getUseDomainConstraints() ? "Y" : "N");
                if (column2.getUse() == 0) {
                    stmt.setString(27, column2.getDomain().getName());
                    stmt.setString(28, column2.getDomain().getLogicalDatatype().getName());
                    stmt.setString(16, column2.getDomain().getLogicalDatatype().getObjectID());
                    stmt.setString(17, (String)map.get(column2.getDomain().getLogicalDatatype().getObjectID()));
                } else if (column2.getUse() == 1) {
                    stmt.setString(27, null);
                    stmt.setString(28, column2.getLogicalDatatype().getName());
                    stmt.setString(16, column2.getLogicalDatatype().getObjectID());
                    stmt.setString(17, (String)map.get(column2.getLogicalDatatype().getObjectID()));
                } else if (column2.getUse() == 2) {
                    stmt.setString(27, null);
                    stmt.setString(28, column2.getDistinctType().getLogicalDataType().getName());
                    stmt.setString(16, column2.getDistinctType().getLogicalDataType().getObjectID());
                    stmt.setString(17, (String)map.get(column2.getDistinctType().getLogicalDataType().getObjectID()));
                } else {
                    stmt.setString(27, null);
                    stmt.setString(28, null);
                    stmt.setString(16, null);
                    stmt.setString(17, null);
                }
                stmt.setString(29, column2.getStructuredType() != null ? column2.getStructuredType().getName() : null);
                stmt.setString(30, column2.getDistinctType() != null ? column2.getDistinctType().getName() : null);
                stmt.setString(31, column2.getCollectionType() != null ? column2.getCollectionType().getName() : null);
                stmt.setString(32, column2.getUsesDefaultValue() ? "Y" : "N");
                stmt.setString(33, column2.getShouldEngineer() ? "Y" : "N");
                stmt.setString(34, column2.getContainer().getName());
                stmt.setString(35, column2.isPKElement() ? "P" : null);
                stmt.setString(36, column2.isFKElement() ? "F" : null);
                stmt.setString(37, column2.getDataType().getName());
                stmt.setInt(38, column2.getContainer().getIndexOf(column2) + 1);
                stmt.setString(39, model.getObjectID());
                stmt.setString(40, modelOVID);
                stmt.setString(41, model.getName());
                if (column2.getUse() == 0) {
                    stmt.setString(42, column2.getDomain().getSize());
                    stmt.setInt(43, RSColumns.getIntValue(column2.getDomain().getPrecision()));
                    stmt.setInt(44, RSColumns.getIntValue(column2.getDomain().getScale()));
                } else if (column2.getUse() == 1) {
                    String size = column2.getSize();
                    String[] parts_n = size.split(" ");
                    stmt.setString(42, parts_n[0]);
                    stmt.setInt(43, RSColumns.getIntValue(column2.getPrecision()));
                    stmt.setInt(44, RSColumns.getIntValue(column2.getScale()));
                } else {
                    stmt.setInt(42, 0);
                    stmt.setInt(43, 0);
                    stmt.setInt(44, 0);
                }
                stmt.setString(45, column2.getUnits());
                stmt.setString(46, column2.isContainsPII() == null ? null : (column2.isContainsPII() != false ? "Y" : "N"));
                stmt.setString(47, column2.isContainsSensitiveInformation() == null ? null : (column2.isContainsSensitiveInformation() != false ? "Y" : "N"));
                stmt.setString(48, column2.getMaskingType());
                stmt.setString(49, column2.isComputed() != false ? "Y" : "N");
                stmt.setString(50, column2.getScope() != null ? column2.getScope().getName() : null);
                stmt.setString(51, column2.isAutoIncrementColumn() ? "Y" : "N");
                stmt.setString(52, column2.isIdentityColumn() ? "Y" : "N");
                stmt.setString(53, column2.isAutoIncrementGenerateAlways() ? "Y" : "N");
                stmt.setString(54, column2.getAutoIncrementStartWith());
                stmt.setInt(55, column2.getAutoIncrementIncrementBy() != null ? column2.getAutoIncrementIncrementBy() : 0);
                stmt.setString(56, column2.getAutoIncrementMinValue());
                stmt.setString(57, column2.getAutoIncrementMaxValue());
                stmt.setString(58, column2.isAutoIncrementCycle() ? "Y" : "N");
                stmt.setString(59, column2.isAutoIncrementDisableCache() ? "Y" : "N");
                stmt.setInt(60, column2.getAutoIncrementCache() != null ? column2.getAutoIncrementCache() : 0);
                stmt.setString(61, column2.isAutoIncrementOrder() ? "Y" : "N");
                stmt.setString(62, column2.getAutoIncrementSequenceName());
                stmt.setString(63, column2.getAutoIncrementTriggerName());
                stmt.setString(64, (String)map.get(design.getObjectID()));
                stmt.addBatch();
                list.add(column2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Column column2 : list) {
                    RSObjectNotes.export(map, connection, column2);
                    RSComments.export(map, connection, column2);
                    RSCommentsInRDBMS.export(map, connection, column2);
                    RSColumnUI.export(map, connection, column2);
                    RSDynamicProperties.export(design, map, connection, column2);
                }
                list.clear();
            }
            RSAVT.export(connection, mColumns, map, "Column");
            RSCheckConstraint.export(connection, mColumns, map, "Column");
            RSValueRanges.export(connection, mColumns, map, "Column");
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Column column : list) {
                RSObjectNotes.export(map, connection, column);
                RSComments.export(map, connection, column);
                RSCommentsInRDBMS.export(map, connection, column);
                RSColumnUI.export(map, connection, column);
                RSDynamicProperties.export(design, map, connection, column);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

