/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSDiagrams;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;

public class RSDiagramElements
extends RSGeneral {
    public static void export(Map map, Connection connection, DesignPartView dpv) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_Diagram_Elements (Name, Type, Geometry_Type, Object_ID, OVID, View_ID, Source_ID, Source_OVID, Source_View_ID, Target_ID, Target_OVID, Target_View_ID, Model_ID, Model_OVID, Location_X, Location_Y, Height, Width, BG_Color, FG_Color, Use_Default_Color, Formatting, Points, Diagram_OVID, Diagram_ID, Diagram_Name, Source_Name, Target_Name, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (TopView tv : dpv.getTopviewsList()) {
            DesignObject obj = tv.getModel();
            stmt.setString(1, obj.getName());
            stmt.setString(2, obj.getObjectTypeName());
            stmt.setString(3, tv instanceof TVConnector ? "Line" : "Shape");
            stmt.setString(4, obj.getObjectID());
            stmt.setString(5, RSDiagramElements.getOrCreateOVID(map, obj.getObjectID()));
            stmt.setString(6, tv.getViewID());
            stmt.setString(7, RSDiagramElements.getSourceID(tv));
            stmt.setString(8, RSDiagramElements.getSourceID(tv) != null ? (String)map.get(RSDiagramElements.getSourceID(tv)) : null);
            stmt.setString(9, RSDiagramElements.getSourceViewID(tv));
            stmt.setString(10, RSDiagramElements.getTargetID(tv));
            stmt.setString(11, RSDiagramElements.getTargetID(tv) != null ? (String)map.get(RSDiagramElements.getTargetID(tv)) : null);
            stmt.setString(12, RSDiagramElements.getTargetViewID(tv));
            if (dpv instanceof DPVProcess || dpv instanceof DPVTransformation) {
                stmt.setString(13, tv.getDesign().getProcessModel().getObjectID());
                stmt.setString(14, (String)map.get(tv.getDesign().getProcessModel().getObjectID()));
                stmt.setString(29, tv.getDesign().getProcessModel().getName());
            } else {
                stmt.setString(13, obj.getDesignPartId());
                stmt.setString(14, (String)map.get(obj.getDesignPartId()));
                stmt.setString(29, obj.getDesignPart().getName());
            }
            if (tv instanceof TVConnector) {
                Rectangle r = ((TVConnector)tv).getLineBounds();
                if (r != null) {
                    stmt.setDouble(15, r.getX());
                    stmt.setDouble(16, r.getY());
                    stmt.setDouble(17, r.getWidth());
                    stmt.setDouble(18, r.getHeight());
                } else {
                    stmt.setDouble(15, 0.0);
                    stmt.setDouble(16, 0.0);
                    stmt.setDouble(17, 0.0);
                    stmt.setDouble(18, 0.0);
                }
            } else {
                stmt.setDouble(15, tv.getLocation().getX());
                stmt.setDouble(16, tv.getLocation().getY());
                stmt.setDouble(17, tv.getSize().getWidth());
                stmt.setDouble(18, tv.getSize().getHeight());
            }
            stmt.setObject(19, tv.getModel() != null && tv.getBackgroundColor() != null ? Integer.valueOf(tv.getBackgroundColor().getRGB()) : null);
            stmt.setObject(20, tv.getModel() != null && tv.getForegroundColor() != null ? Integer.valueOf(tv.getForegroundColor().getRGB()) : null);
            stmt.setString(21, tv.getModel() != null && tv.useDefaultColor() ? "Y" : "N");
            stmt.setString(22, RSDiagramElements.getFormatting(tv));
            stmt.setString(23, RSDiagramElements.getPoints(tv));
            if (dpv instanceof DPVProcess || dpv instanceof DPVTransformation) {
                stmt.setString(24, (String)map.get(dpv.getDesignPart().getObjectID()));
                stmt.setString(25, dpv.getDesignPart().getObjectID());
                stmt.setString(26, RSDiagrams.getDiagramName(dpv));
            } else {
                stmt.setString(24, (String)map.get(dpv.getDPVId()));
                stmt.setString(25, dpv.getDPVId());
                stmt.setString(26, RSDiagrams.getDiagramName(dpv));
            }
            stmt.setString(27, RSDiagramElements.getSourceName(tv));
            stmt.setString(28, RSDiagramElements.getTargetName(tv));
            stmt.setString(30, (String)map.get(tv.getDesign().getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }

    private static String getFormatting(TopView tv) {
        if (tv.getModel() instanceof EditableFonts) {
            StringBuffer sb = new StringBuffer();
            Iterator it = tv.getEditableFonts().iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    sb.append(";");
                } else {
                    first = false;
                }
                FontObject fo = (FontObject)it.next();
                sb.append(fo.getType()).append(",");
                sb.append(fo.getColor().getRGB()).append(",");
                sb.append(fo.getFont().getSize()).append(",");
                sb.append(fo.getFont().getStyle());
            }
            return sb.toString();
        }
        return null;
    }

    private static String getPoints(TopView tv) {
        if (tv instanceof TVConnector) {
            StringBuffer sb = new StringBuffer();
            Iterator it = ((TVConnector)tv).getActualPoints().iterator();
            boolean first = true;
            while (it.hasNext()) {
                Point2D p;
                Object obj = it.next();
                if (!first) {
                    sb.append(";");
                } else {
                    first = false;
                }
                if ((p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj) == null) continue;
                sb.append(p.getX()).append(",").append(p.getY());
            }
            return sb.toString();
        }
        return null;
    }

    private static String getSourceID(TopView tv) {
        TopView stv;
        if (tv instanceof TVConnector && (stv = ((TVConnector)tv).getSourceTopView()) != null) {
            return stv.getModel().getObjectID();
        }
        return null;
    }

    private static String getTargetID(TopView tv) {
        TopView ttv;
        if (tv instanceof TVConnector && (ttv = ((TVConnector)tv).getTargetTopView()) != null) {
            return ttv.getModel().getObjectID();
        }
        return null;
    }

    private static String getSourceName(TopView tv) {
        TopView stv;
        if (tv instanceof TVConnector && (stv = ((TVConnector)tv).getSourceTopView()) != null) {
            return stv.getModel().getName();
        }
        return null;
    }

    private static String getTargetName(TopView tv) {
        TopView ttv;
        if (tv instanceof TVConnector && (ttv = ((TVConnector)tv).getTargetTopView()) != null) {
            return ttv.getModel().getName();
        }
        return null;
    }

    private static String getSourceViewID(TopView tv) {
        TopView stv;
        if (tv instanceof TVConnector && (stv = ((TVConnector)tv).getSourceTopView()) != null) {
            return stv.getViewID();
        }
        return null;
    }

    private static String getTargetViewID(TopView tv) {
        TopView ttv;
        if (tv instanceof TVConnector && (ttv = ((TVConnector)tv).getTargetTopView()) != null) {
            return ttv.getViewID();
        }
        return null;
    }
}

