/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;

public class RSDimensions
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Dimension> list = new ArrayList<Dimension>(1000);
        int count = 0;
        ArrayList<Dimension> dimCollection = new ArrayList<Dimension>();
        String query = "INSERT INTO DMRS_DIMENSIONS (Dimension_ID, Dimension_Name, Dimension_OVID, Model_ID, Model_Name, Model_OVID, Base_Entity_ID, Base_Entity_Name, Base_Entity_OVID, Base_Level_ID, Base_Level_Name, Base_Level_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getMultidimensionalDesigns().iterator();
        while (mit.hasNext()) {
            MultidimensionalDesign model = (MultidimensionalDesign)mit.next();
            String modelOVID = (String)map.get(model.getObjectID());
            String designOVID = (String)map.get(model.getDesign().getObjectID());
            Iterator it = model.getDimensionSet().iterator();
            dimCollection.clear();
            while (it.hasNext()) {
                Dimension dim2 = (Dimension)it.next();
                String dimOVID = RSDimensions.getOrCreateOVID(map, dim2.getObjectID());
                dimCollection.add(dim2);
                ContainerObject ent = dim2.getBaseEntity();
                Level lev = dim2.getBaseLevel();
                stmt.setString(1, dim2.getObjectID());
                stmt.setString(2, dim2.getName());
                stmt.setString(3, dimOVID);
                stmt.setString(4, model.getObjectID());
                stmt.setString(5, model.getName());
                stmt.setString(6, modelOVID);
                if (ent != null) {
                    stmt.setString(7, ent.getObjectID());
                    stmt.setString(8, ent.getName());
                    stmt.setString(9, RSDimensions.getOrCreateOVID(map, ent.getObjectID()));
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                if (lev != null) {
                    stmt.setString(10, lev.getObjectID());
                    stmt.setString(11, lev.getName());
                    stmt.setString(12, RSDimensions.getOrCreateOVID(map, lev.getObjectID()));
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                }
                stmt.setString(13, dim2.getOracleLongName());
                stmt.setString(14, dim2.getOraclePluralName());
                stmt.setString(15, dim2.getOracleShortName());
                stmt.setString(16, dim2.getDescription());
                stmt.setString(17, designOVID);
                stmt.addBatch();
                list.add(dim2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Dimension dim2 : list) {
                    RSObjectNotes.export(map, connection, dim2);
                    RSComments.export(map, connection, dim2);
                    RSDynamicProperties.export(design, map, connection, dim2);
                }
                list.clear();
            }
            RSDimensions.exportLevels(map, connection, dimCollection, designOVID);
            RSDimensions.exportCalcMembers(map, connection, dimCollection, designOVID);
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Dimension dim : list) {
                RSObjectNotes.export(map, connection, dim);
                RSComments.export(map, connection, dim);
                RSDynamicProperties.export(design, map, connection, dim);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportLevels(Map map, Connection connection, List dimensions, String designOVID) throws Exception {
        int count1 = 0;
        String levelQuery = "INSERT INTO DMRS_DIMENSION_LEVELS (Dimension_ID, Dimension_Name, Dimension_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement levelStmt = connection.prepareStatement(levelQuery);
        for (Dimension dim : dimensions) {
            for (Level level : dim.getAllLevels()) {
                String levelOVID = RSDimensions.getOrCreateOVID(map, level.getObjectID());
                levelStmt.setString(1, dim.getObjectID());
                levelStmt.setString(2, dim.getName());
                levelStmt.setString(3, (String)map.get(dim.getObjectID()));
                levelStmt.setString(4, level.getObjectID());
                levelStmt.setString(5, level.getName());
                levelStmt.setString(6, levelOVID);
                levelStmt.setString(7, designOVID);
                levelStmt.addBatch();
                if (++count1 != 1000) continue;
                count1 = 0;
                levelStmt.executeBatch();
            }
        }
        if (count1 > 0) {
            count1 = 0;
            levelStmt.executeBatch();
        }
        levelStmt.close();
        levelStmt = null;
    }

    private static void exportCalcMembers(Map map, Connection connection, List dimensions, String designOVID) throws Exception {
        int count2 = 0;
        String calcQuery = "INSERT INTO DMRS_DIMENSION_CALC_ATTRS (Dimension_ID, Dimension_Name, Dimension_OVID, Calc_Attribute_ID, Calc_Attribute_Name, Calc_Attribute_OVID, Calculated_Expr, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement calcStmt = connection.prepareStatement(calcQuery);
        for (Dimension dim : dimensions) {
            for (Dimension.PermanentCalcMember calc : dim.getPermanentCalcMembers()) {
                String calcOVID = RSDimensions.getOrCreateOVID(map, calc.getId());
                calcStmt.setString(1, dim.getObjectID());
                calcStmt.setString(2, dim.getName());
                calcStmt.setString(3, (String)map.get(dim.getObjectID()));
                calcStmt.setString(4, calc.getId());
                calcStmt.setString(5, calc.getName());
                calcStmt.setString(6, calcOVID);
                calcStmt.setString(7, calc.getExpression());
                calcStmt.setString(8, designOVID);
                calcStmt.addBatch();
                if (++count2 != 1000) continue;
                count2 = 0;
                calcStmt.executeBatch();
            }
        }
        if (count2 > 0) {
            count2 = 0;
            calcStmt.executeBatch();
        }
        calcStmt.close();
        calcStmt = null;
    }
}

