/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.GUID;

public class RSDomains
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        Domain domain2;
        ArrayList<Domain> list = new ArrayList<Domain>(1000);
        int count = 0;
        String designOVID = (String)map.get(design.getObjectID());
        String query = "INSERT INTO DMRS_DOMAINS (Domain_ID, Domain_Name, OVID, Synonyms, Logical_Type_ID, Logical_Type_OVID, T_Size, T_Precision, T_Scale, Native_Type, LT_Name, Design_ID, Design_OVID, Design_Name, Default_Value, Unit_Of_Measure, Char_Units) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = design.getDomainSet().iterator();
        while (it.hasNext()) {
            domain2 = (Domain)it.next();
            String ovid = new GUID().toString();
            map.put(domain2.getObjectID(), ovid);
            stmt.setString(1, domain2.getObjectID());
            stmt.setString(2, domain2.getName());
            stmt.setString(3, ovid);
            stmt.setString(4, domain2.getSynonym());
            stmt.setString(5, domain2.getLogicalDatatype().getObjectID());
            stmt.setString(6, (String)map.get(domain2.getLogicalDatatype().getObjectID()));
            stmt.setInt(7, RSDomains.getIntValue(domain2.getSize()));
            stmt.setInt(8, RSDomains.getIntValue(domain2.getPrecision()));
            stmt.setInt(9, RSDomains.getIntValue(domain2.getScale()));
            stmt.setString(10, domain2.getDataType().getName());
            stmt.setString(11, domain2.getLogicalDatatype().getName());
            stmt.setString(12, design.getObjectID());
            stmt.setString(13, designOVID);
            stmt.setString(14, design.getName());
            stmt.setString(15, domain2.getDefaultValue());
            stmt.setString(16, domain2.getUnitOfMeasure());
            stmt.setString(17, domain2.getUnits());
            stmt.addBatch();
            list.add(domain2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Domain domain2 : list) {
                RSObjectNotes.export(map, connection, domain2);
                RSComments.export(map, connection, domain2);
                RSDynamicProperties.export(design, map, connection, domain2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Domain domain3 : list) {
                RSObjectNotes.export(map, connection, domain3);
                RSComments.export(map, connection, domain3);
                RSDynamicProperties.export(design, map, connection, domain3);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
        query = "INSERT INTO DMRS_DOMAIN_AVT (Domain_ID, Domain_OVID, Sequence, Value, Short_Description, Domain_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        stmt = connection.prepareStatement(query);
        it = design.getDomainSet().iterator();
        while (it.hasNext()) {
            domain2 = (Domain)it.next();
            if (domain2.getValueList() == null) continue;
            Iterator vit = domain2.getValueIterator();
            int seq = 0;
            while (vit.hasNext()) {
                Object key = vit.next();
                String value = (String)domain2.getValueList().getValuesDescriptionMap().get(key);
                stmt.setString(1, domain2.getObjectID());
                stmt.setString(2, (String)map.get(domain2.getObjectID()));
                stmt.setInt(3, ++seq);
                stmt.setString(4, key.toString());
                stmt.setString(5, value);
                stmt.setString(6, domain2.getName());
                stmt.setString(7, designOVID);
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
        query = "INSERT INTO DMRS_DOMAIN_CHECK_CONSTRAINTS (Domain_ID, Domain_OVID, Sequence, Text, Database_Type, Domain_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        stmt = connection.prepareStatement(query);
        it = design.getDomainSet().iterator();
        while (it.hasNext()) {
            domain2 = (Domain)it.next();
            CheckConstraint check = domain2.getCheck();
            int seq = 0;
            if (check == null) continue;
            String generic = check.getGenericConstraint();
            if (generic != null && !"".equalsIgnoreCase(generic)) {
                stmt.setString(1, domain2.getObjectID());
                stmt.setString(2, (String)map.get(domain2.getObjectID()));
                stmt.setInt(3, ++seq);
                stmt.setString(4, generic);
                stmt.setString(5, "GENERIC");
                stmt.setString(6, domain2.getName());
                stmt.setString(7, designOVID);
                stmt.addBatch();
                if (++count == 1000) {
                    count = 0;
                    stmt.executeBatch();
                }
            }
            Object[] types = check.getTypes();
            for (int i = 0; i < types.length; ++i) {
                RDBMSType type = (RDBMSType)types[i];
                String text = check.getImplementationFor(type);
                if (text == null || "".equalsIgnoreCase(text)) continue;
                stmt.setString(1, domain2.getObjectID());
                stmt.setString(2, (String)map.get(domain2.getObjectID()));
                stmt.setInt(3, ++seq);
                stmt.setString(4, text);
                stmt.setString(5, type.getName());
                stmt.setString(6, domain2.getName());
                stmt.setString(7, designOVID);
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
        query = "INSERT INTO DMRS_DOMAIN_VALUE_RANGES (Domain_ID, Domain_OVID, Sequence, Begin_Value, End_Value, Short_Description, Domain_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        stmt = connection.prepareStatement(query);
        it = design.getDomainSet().iterator();
        while (it.hasNext()) {
            domain2 = (Domain)it.next();
            Iterator avtit = domain2.getAVTs().iterator();
            int seq = 0;
            while (avtit.hasNext()) {
                AVT avt = (AVT)avtit.next();
                stmt.setString(1, domain2.getObjectID());
                stmt.setString(2, (String)map.get(domain2.getObjectID()));
                stmt.setInt(3, ++seq);
                stmt.setString(4, avt.getBeginValue());
                stmt.setString(5, avt.getEndValue());
                stmt.setString(6, avt.getDescription());
                stmt.setString(7, domain2.getName());
                stmt.setString(8, designOVID);
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

