/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSEntities
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, LogicalDesign model, String modelOVID) throws Exception {
        String ovid;
        ArrayList<Entity> list = new ArrayList<Entity>(1000);
        int count = 0;
        ctMap.clear();
        String query = "INSERT INTO DMRS_CLASSIFICATION_TYPES (Type_ID, Type_OVID, Type_Name, Design_ID, Design_OVID, Design_Name) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (ClassificationType ct : design.getDesignLevelSettings().getClassificationTypeList()) {
            ovid = new GUID().toString();
            ctMap.put(ct.getTypeID(), ovid);
            stmt.setString(1, ct.getTypeID());
            stmt.setString(2, ovid);
            stmt.setString(3, ct.getTypeName());
            stmt.setString(4, design.getObjectID());
            stmt.setString(5, (String)map.get(design.getObjectID()));
            stmt.setString(6, design.getName());
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
        query = "INSERT INTO DMRS_ENTITIES (Entity_Name, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Number_Data_Elements, Classification_Type_ID, Classification_Type_OVID, Classification_Type_Name, Allow_Type_Substitution, Min_Volume, Expected_Volume, Max_Volume, Growth_Rate_Percents, Growth_Rate_Interval, Normal_Form, Temporary_Object_Scope, Adequately_Normalized, Substitution_Parent, Substitution_Parent_OVID, Synonyms, Synonym_To_Display, Preferred_Abbreviation, SuperTypeEntity_ID, SuperTypeEntity_OVID, Engineering_Strategy, Owner, Entity_Source, Model_Name, Substitution_Parent_Name, SuperTypeEntity_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        stmt = connection.prepareStatement(query);
        Iterator it = model.getEntitySet().iterator();
        while (it.hasNext()) {
            ClassificationType ct;
            Entity entity2 = (Entity)it.next();
            ovid = RSEntities.getOrCreateOVID(map, entity2.getObjectID());
            stmt.setString(1, entity2.getName());
            stmt.setString(2, entity2.getObjectID());
            stmt.setString(3, ovid);
            stmt.setString(4, entity2.getImportedId());
            stmt.setString(5, model.getObjectID());
            stmt.setString(6, modelOVID);
            stmt.setString(7, entity2.getBasedOnStructuredType() != null ? entity2.getBasedOnStructuredType().getObjectID() : null);
            stmt.setString(8, entity2.getBasedOnStructuredType() != null ? (String)map.get(entity2.getBasedOnStructuredType().getObjectID()) : null);
            stmt.setString(9, entity2.getBasedOnStructuredType() != null ? entity2.getBasedOnStructuredType().getName() : null);
            stmt.setInt(10, entity2.getElements().length);
            stmt.setString(11, null);
            stmt.setString(12, null);
            stmt.setString(13, null);
            if (!"".equalsIgnoreCase(entity2.getTypeID()) && (ct = design.getDesignLevelSettings().getClassificationTypeByID(entity2.getTypeID())) != null) {
                String ctOVID = (String)ctMap.get(ct.getTypeID());
                stmt.setString(11, entity2.getTypeID());
                stmt.setString(12, ctOVID);
                stmt.setString(13, ct.getTypeName());
            }
            stmt.setString(14, entity2.isAllowTypeSubstitution() ? "Y" : "N");
            stmt.setObject(15, entity2.getMinVolumes());
            stmt.setObject(16, entity2.getExpectedVolumes());
            stmt.setObject(17, entity2.getMaxVolumes());
            stmt.setInt(18, entity2.getGrowthPercentInt());
            stmt.setString(19, entity2.getGrowthType());
            stmt.setString(20, entity2.getNormalForm());
            stmt.setString(21, entity2.getScope());
            stmt.setString(22, "YES".equalsIgnoreCase(entity2.getAdequatelyNormalized()) ? "Y" : "N");
            stmt.setString(23, entity2.getTypeSubstitution() != null ? entity2.getTypeSubstitution().getObjectID() : null);
            stmt.setString(24, entity2.getTypeSubstitution() != null ? RSEntities.getOrCreateOVID(map, entity2.getTypeSubstitution().getObjectID()) : null);
            stmt.setString(25, entity2.getSynonym());
            stmt.setString(26, entity2.getSynonymToDisplay());
            stmt.setString(27, entity2.getPreferredAbbreviation());
            stmt.setString(28, entity2.getHierarchicalParent() != null ? entity2.getHierarchicalParent().getObjectID() : null);
            stmt.setString(29, entity2.getHierarchicalParent() != null ? RSEntities.getOrCreateOVID(map, entity2.getHierarchicalParent().getObjectID()) : null);
            stmt.setString(30, entity2.getFwdEngineeringStrategyName());
            stmt.setString(31, entity2.getOwner());
            stmt.setString(32, entity2.getSource());
            stmt.setString(33, model.getName());
            stmt.setString(34, entity2.getTypeSubstitution() != null ? entity2.getTypeSubstitution().getName() : null);
            stmt.setString(35, entity2.getHierarchicalParent() != null ? entity2.getHierarchicalParent().getName() : null);
            stmt.setString(36, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(entity2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (Entity entity2 : list) {
                RSObjectNotes.export(map, connection, entity2);
                RSComments.export(map, connection, entity2);
                RSCommentsInRDBMS.export(map, connection, entity2);
                RSDynamicProperties.export(design, map, connection, entity2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Entity entity : list) {
                RSObjectNotes.export(map, connection, entity);
                RSComments.export(map, connection, entity);
                RSCommentsInRDBMS.export(map, connection, entity);
                RSDynamicProperties.export(design, map, connection, entity);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

