/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSFKColumns;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSFKeys
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_FOREIGNKEYS (FK_Name, Model_ID, Model_OVID, Object_ID, OVID, Import_ID, Child_Table_Name, Referred_Table_Name, Engineer, Delete_Rule, Child_Table_ID, Child_Table_OVID, Referred_Table_ID, Referred_Table_OVID, Referred_Key_ID, Referred_Key_OVID, Number_Of_Columns, Mandatory, Transferable, In_Arc, Arc_ID, Model_Name, Referred_Key_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getRelationalDesigns().iterator();
        while (mit.hasNext()) {
            RelationalDesign model = (RelationalDesign)mit.next();
            Iterator it = model.getFKIndexAssociationSet().iterator();
            String modelOVID = (String)map.get(model.getObjectID());
            while (it.hasNext()) {
                FKIndexAssociation index2 = (FKIndexAssociation)it.next();
                String ovid = new GUID().toString();
                map.put(index2.getObjectID(), ovid);
                stmt.setString(1, index2.getName());
                stmt.setString(2, model.getObjectID());
                stmt.setString(3, modelOVID);
                stmt.setString(4, index2.getObjectID());
                stmt.setString(5, ovid);
                stmt.setString(6, index2.getImportedId());
                stmt.setString(7, index2.getContainerWithKeyObject().getName());
                stmt.setString(8, index2.getRemoteTable().getName());
                stmt.setString(9, index2.getShouldEngineer() ? "Y" : "N");
                stmt.setString(10, index2.getDeleteRule());
                stmt.setString(11, index2.getContainerWithKeyObject().getObjectID());
                stmt.setString(12, (String)map.get(index2.getContainerWithKeyObject().getObjectID()));
                stmt.setString(13, index2.getRemoteTable().getObjectID());
                stmt.setString(14, (String)map.get(index2.getRemoteTable().getObjectID()));
                stmt.setString(15, index2.getRemoteIndex().getObjectID());
                stmt.setString(16, (String)map.get(index2.getRemoteIndex().getObjectID()));
                stmt.setInt(17, index2.getRemoteIndex().getElements().length);
                stmt.setString(18, index2.isMandatory() ? "Y" : "N");
                stmt.setString(19, index2.isMandatory() ? "Y" : "N");
                stmt.setString(20, index2.getArc() != null ? "Y" : "N");
                stmt.setString(21, index2.getArc() != null ? index2.getArc().getObjectID() : null);
                stmt.setString(22, model.getName());
                stmt.setString(23, index2.getRemoteIndex().getName());
                stmt.setString(24, (String)map.get(design.getObjectID()));
                stmt.addBatch();
                list.add(index2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (FKIndexAssociation index2 : list) {
                    RSObjectNotes.export(map, connection, index2);
                    RSComments.export(map, connection, index2);
                    RSFKColumns.export(design, map, connection, index2);
                    RSDynamicProperties.export(design, map, connection, index2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (FKIndexAssociation index : list) {
                RSObjectNotes.export(map, connection, index);
                RSComments.export(map, connection, index);
                RSFKColumns.export(design, map, connection, index);
                RSDynamicProperties.export(design, map, connection, index);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

