/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSIndexColumns;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSIndexes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Index> list = new ArrayList<Index>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_INDEXES (Index_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, State, Functional, Expression, Engineer, Table_Name, Spatial_Index, Spatial_Layer_Type, Geodetic_Index, Number_Of_Dimensions, Design_OVID, Schema_OVID, Schema_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getRelationalDesigns().iterator();
        while (mit.hasNext()) {
            RelationalDesign model = (RelationalDesign)mit.next();
            Iterator it = model.getGlobalIndexSet().iterator();
            while (it.hasNext()) {
                Index index2 = (Index)it.next();
                if (index2.isFK()) continue;
                String ovid = new GUID().toString();
                map.put(index2.getObjectID(), ovid);
                stmt.setString(1, index2.getName());
                stmt.setString(2, index2.getObjectID());
                stmt.setString(3, ovid);
                stmt.setString(4, index2.getImportedId());
                stmt.setString(5, index2.getContainerObject().getObjectID());
                stmt.setString(6, (String)map.get(index2.getContainerObject().getObjectID()));
                stmt.setString(7, index2.getIndexState());
                stmt.setString(8, !"".equalsIgnoreCase(index2.getIndexExpression()) ? "Y" : "N");
                stmt.setString(9, index2.getIndexExpression());
                stmt.setString(10, index2.getShouldEngineer() ? "Y" : "N");
                stmt.setString(11, index2.getContainerObject().getName());
                stmt.setString(12, index2.isSpatialIndex() ? "Y" : "N");
                stmt.setString(13, index2.getLayerType());
                stmt.setString(14, "YES".equalsIgnoreCase(index2.getGeodetic()) ? "Y" : "N");
                stmt.setInt(15, index2.getDimensionsNumber());
                stmt.setString(16, (String)map.get(design.getObjectID()));
                stmt.setString(17, index2.getSchemaObject() != null ? (String)map.get(index2.getSchemaObject().getObjectID()) : null);
                stmt.setString(18, index2.getSchemaObject() != null ? index2.getSchemaObject().getName() : null);
                stmt.addBatch();
                list.add(index2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Index index2 : list) {
                    RSObjectNotes.export(map, connection, index2);
                    RSComments.export(map, connection, index2);
                    RSCommentsInRDBMS.export(map, connection, index2);
                    RSIndexColumns.export(design, map, connection, index2);
                    RSDynamicProperties.export(design, map, connection, index2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Index index : list) {
                RSObjectNotes.export(map, connection, index);
                RSComments.export(map, connection, index);
                RSCommentsInRDBMS.export(map, connection, index);
                RSIndexColumns.export(design, map, connection, index);
                RSDynamicProperties.export(design, map, connection, index);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

