/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSInfoStores
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<InfoStore> list = new ArrayList<InfoStore>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_INFO_STORES (Info_Store_ID, Info_Store_OVID, Info_Store_Name, Model_ID, Model_OVID, Model_Name, Info_Store_Type, Object_Type, Implementation_Name, Location, Source, File_Name, File_Type, Owner, Rdbms_Site, Scope, Transfer_Type, Field_Separator, Text_Delimiter, Skip_Records, Self_Describing, System_Objective, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String infoQuery = "INSERT INTO DMRS_DATA_FLOW_DIAGRAM_INFOS (Diagram_ID, Diagram_OVID, Diagram_Name, Info_Store_ID, Info_Store_OVID, Info_Store_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getInfoStoreSet().iterator();
        while (it.hasNext()) {
            InfoStore info2 = (InfoStore)it.next();
            String infoOVID = RSInfoStores.getOrCreateOVID(map, info2.getObjectID());
            stmt.setString(1, info2.getObjectID());
            stmt.setString(2, infoOVID);
            stmt.setString(3, info2.getName());
            stmt.setString(4, processModel.getObjectID());
            stmt.setString(5, (String)map.get(processModel.getObjectID()));
            stmt.setString(6, processModel.getName());
            stmt.setString(7, info2.getType());
            stmt.setString(8, info2.getObjectType());
            stmt.setString(9, info2.getImplementationName());
            stmt.setString(10, info2.getLocation());
            stmt.setString(11, info2.getSource());
            stmt.setString(12, info2.getFileName());
            stmt.setString(13, info2.getFileType());
            stmt.setString(14, info2.getOwner());
            stmt.setString(15, info2.getRdbmsSite());
            stmt.setString(16, info2.getScope());
            stmt.setString(17, info2.getTransferType());
            stmt.setString(18, info2.getFieldSeparator());
            stmt.setString(19, info2.getTextDelimiter());
            stmt.setInt(20, info2.getSkipRecords());
            stmt.setString(21, info2.isSelfDescribing() ? "Y" : "N");
            stmt.setString(22, info2.getSystemObjective());
            stmt.setString(23, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(info2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (InfoStore info2 : list) {
                RSObjectNotes.export(map, connection, info2);
                RSComments.export(map, connection, info2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (InfoStore info : list) {
                RSObjectNotes.export(map, connection, info);
                RSComments.export(map, connection, info);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
        PreparedStatement infoStmt = connection.prepareStatement(infoQuery);
        Iterator dfdIter = processModel.getDataFlowDesigns().iterator();
        while (dfdIter.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)dfdIter.next();
            String dfdOVID = RSInfoStores.getOrCreateOVID(map, dfd.getObjectID());
            Iterator infoIter = dfd.getInfoStoreSet().iterator();
            while (infoIter.hasNext()) {
                InfoStore infoStore = (InfoStore)infoIter.next();
                String infoStoreOVID = (String)map.get(infoStore.getObjectID());
                infoStmt.setString(1, dfd.getObjectID());
                infoStmt.setString(2, dfdOVID);
                infoStmt.setString(3, !"".equals(dfd.getName()) ? dfd.getName() : dfd.getObjectTypeName());
                infoStmt.setString(4, infoStore.getObjectID());
                infoStmt.setString(5, infoStoreOVID);
                infoStmt.setString(6, infoStore.getName());
                infoStmt.setString(7, (String)map.get(design.getObjectID()));
                infoStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                infoStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            infoStmt.executeBatch();
        }
        infoStmt.close();
        infoStmt = null;
    }
}

