/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSKeysAttributes;
import oracle.dbtools.crest.exports.reports.RSKeysElements;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSKeys
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, LogicalDesign model, String modelOVID) throws Exception {
        ArrayList<CandidateKey> list = new ArrayList<CandidateKey>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_KEYS (Key_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, State, Synonyms, Entity_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = model.getGlobalCandidateKeySet().iterator();
        while (it.hasNext()) {
            CandidateKey key2 = (CandidateKey)it.next();
            String ovid = new GUID().toString();
            map.put(key2.getObjectID(), ovid);
            stmt.setString(1, key2.getName());
            stmt.setString(2, key2.getObjectID());
            stmt.setString(3, ovid);
            stmt.setString(4, key2.getImportedId());
            stmt.setString(5, key2.getContainerObject().getObjectID());
            stmt.setString(6, (String)map.get(key2.getContainerObject().getObjectID()));
            stmt.setString(7, key2.getKeyState());
            stmt.setString(8, key2.getSynonym());
            stmt.setString(9, key2.getContainerObject().getName());
            stmt.setString(10, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            list.add(key2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (CandidateKey key2 : list) {
                RSObjectNotes.export(map, connection, key2);
                RSComments.export(map, connection, key2);
                RSKeysAttributes.export(design, map, connection, key2);
                RSKeysElements.export(design, map, connection, key2);
                RSDynamicProperties.export(design, map, connection, key2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (CandidateKey key : list) {
                RSObjectNotes.export(map, connection, key);
                RSComments.export(map, connection, key);
                RSKeysAttributes.export(design, map, connection, key);
                RSKeysElements.export(design, map, connection, key);
                RSDynamicProperties.export(design, map, connection, key);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

