/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSProcessAttributes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_PROCESS_ATTRIBUTES (Process_ID, Process_OVID, Entity_ID, Entity_OVID, Flow_ID, Flow_OVID, DFD_ID, DFD_OVID, Process_Name, Entity_Name, Flow_Name, DFD_Name, OP_Read, OP_Create, OP_Update, OP_Delete, CRUD_Code, Flow_Direction, Attribute_ID, Attribute_OVID, Attribute_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            String dfdOVID = RSProcessAttributes.getOrCreateOVID(map, dfd.getObjectID());
            String tlName = dfd.getTopLevelDataFlowDesign().getName();
            Iterator dfdit = dfd.getProcessSet().iterator();
            while (dfdit.hasNext()) {
                Process process = (Process)dfdit.next();
                String procOVID = RSProcessAttributes.getOrCreateOVID(map, process.getObjectID());
                if (process.getType() != 0) continue;
                for (Process.ProcessedObject po : process.getProcessedAttributesAndFlows(false)) {
                    Attribute attribute = (Attribute)po.getObject();
                    stmt.setString(1, process.getObjectID());
                    stmt.setString(2, procOVID);
                    stmt.setString(3, attribute.getContainer().getObjectID());
                    stmt.setString(4, (String)map.get(attribute.getContainer().getObjectID()));
                    stmt.setString(5, po.getFlow().getObjectID());
                    stmt.setString(6, RSProcessAttributes.getOrCreateOVID(map, po.getFlow().getObjectID()));
                    stmt.setString(7, dfd.getObjectID());
                    stmt.setString(8, dfdOVID);
                    stmt.setString(9, process.getName());
                    stmt.setString(10, attribute.getContainer().getName());
                    stmt.setString(11, po.getFlow().getName());
                    stmt.setString(12, tlName);
                    stmt.setString(13, po.isOpRead() ? "Y" : "N");
                    stmt.setString(14, po.isOpCreate() ? "Y" : "N");
                    stmt.setString(15, po.isOpUpdate() ? "Y" : "N");
                    stmt.setString(16, po.isOpDelete() ? "Y" : "N");
                    if (po.isOpRead()) {
                        stmt.setString(17, "R");
                    } else {
                        String crud = "";
                        if (po.isOpCreate()) {
                            crud = "C";
                        }
                        if (po.isOpUpdate()) {
                            crud = crud + "U";
                        }
                        if (po.isOpDelete()) {
                            crud = crud + "D";
                        }
                        stmt.setString(17, crud);
                    }
                    stmt.setString(18, po.isInbound() ? "IN" : "OUT");
                    stmt.setString(19, attribute.getObjectID());
                    stmt.setString(20, (String)map.get(attribute.getObjectID()));
                    stmt.setString(21, attribute.getName());
                    stmt.setString(22, (String)map.get(design.getObjectID()));
                    stmt.addBatch();
                    if (++count != 1000) continue;
                    count = 0;
                    stmt.executeBatch();
                }
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

