/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSFootnotes;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSSourceTargetMappings;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationTask;

public class RSProcesses
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Process> list = new ArrayList<Process>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_PROCESSES (Process_ID, Process_OVID, Process_Name, Diagram_ID, Diagram_OVID, Diagram_Name, Transformation_Task_ID, Transformation_Task_OVID, Transformation_Task_Name, Parent_Process_ID, Parent_Process_OVID, Parent_Process_Name, Process_Number, Process_Type, Process_Mode, Priority, Frequency_Times, Frequency_Time_Unit, Peak_Periods_String, Parameters_Wrappers_String, Interactive_Max_Response_Time, Interactive_Response_Time_Unit, Batch_Min_Transactions, Batch_Time_Unit, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ProcessModel processModel = design.getProcessModel();
        Iterator it = processModel.getDataFlowDesigns().iterator();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            String dfdOVID = RSProcesses.getOrCreateOVID(map, dfd.getObjectID());
            Iterator pit = dfd.getProcessSet().iterator();
            while (pit.hasNext()) {
                Process process2 = (Process)pit.next();
                String procOVID = RSProcesses.getOrCreateOVID(map, process2.getObjectID());
                TransformationTask tt = process2.getTransformationTask();
                Process par = process2.getParentProcess();
                stmt.setString(1, process2.getObjectID());
                stmt.setString(2, procOVID);
                stmt.setString(3, process2.getName());
                stmt.setString(4, dfd.getObjectID());
                stmt.setString(5, dfdOVID);
                stmt.setString(6, !"".equals(dfd.getName()) ? dfd.getName() : dfd.getObjectTypeName());
                if (tt != null) {
                    stmt.setString(7, tt.getObjectID());
                    stmt.setString(8, RSProcesses.getOrCreateOVID(map, tt.getObjectID()));
                    stmt.setString(9, tt.getName());
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                if (par != null) {
                    stmt.setString(10, par.getObjectID());
                    stmt.setString(11, RSProcesses.getOrCreateOVID(map, par.getObjectID()));
                    stmt.setString(12, par.getName());
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                }
                stmt.setString(13, process2.getProcessNumber());
                if (process2.getType() == 2) {
                    stmt.setString(14, "Use Transformation Task");
                } else if (process2.getType() == 1) {
                    stmt.setString(14, "Composite");
                } else {
                    stmt.setString(14, "Primitive");
                }
                stmt.setString(15, process2.getMode());
                stmt.setString(16, process2.getPriority());
                stmt.setInt(17, process2.getFrequencyTimes());
                stmt.setString(18, process2.getFrequencyTimeUnit());
                stmt.setString(19, process2.getPeakPeriodsString());
                stmt.setString(20, process2.getParamsWrappersString());
                stmt.setInt(21, process2.getInteractiveLongestResponseTime());
                stmt.setString(22, process2.getInteractiveResponseTimeUnit());
                stmt.setInt(23, process2.getBatchMinimumTransactions());
                stmt.setString(24, process2.getBatchTimeUnit());
                stmt.setString(25, (String)map.get(design.getObjectID()));
                stmt.addBatch();
                list.add(process2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Process process2 : list) {
                    RSObjectNotes.export(map, connection, process2);
                    RSComments.export(map, connection, process2);
                    RSFootnotes.export(map, connection, process2);
                    RSSourceTargetMappings.export(map, connection, process2);
                    RSDynamicProperties.export(design, map, connection, process2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Process process : list) {
                RSObjectNotes.export(map, connection, process);
                RSComments.export(map, connection, process);
                RSFootnotes.export(map, connection, process);
                RSSourceTargetMappings.export(map, connection, process);
                RSDynamicProperties.export(design, map, connection, process);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

