/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;

public class RSRollupLinks
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<RollupLink> list = new ArrayList<RollupLink>(1000);
        int count = 0;
        ArrayList<RollupLink> linksCollection = new ArrayList<RollupLink>();
        String query = "INSERT INTO DMRS_ROLLUP_LINKS (Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Model_ID, Model_Name, Model_OVID, Parent_Object_ID, Parent_Object_Name, Parent_Object_OVID, Child_Object_ID, Child_Object_Name, Child_Object_OVID, Fact_Entity_ID, Fact_Entity_Name, Fact_Entity_OVID, Parent_Object_Type, Child_Object_Type, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Default_Aggr_Operator, Is_Role_Playing, Is_Sparse_Dimension, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getMultidimensionalDesigns().iterator();
        while (mit.hasNext()) {
            MultidimensionalDesign model = (MultidimensionalDesign)mit.next();
            String modelOVID = (String)map.get(model.getObjectID());
            String designOVID = (String)map.get(model.getDesign().getObjectID());
            linksCollection.clear();
            Iterator it = model.getRollupLinkSet().iterator();
            while (it.hasNext()) {
                RollupLink link2 = (RollupLink)it.next();
                String linkOVID = RSRollupLinks.getOrCreateOVID(map, link2.getObjectID());
                linksCollection.add(link2);
                AbstractMDObject parentObj = link2.getParentLevel();
                AbstractMDObject childObj = link2.getChildLevel();
                ContainerObject entObj = link2.getFactEntity();
                stmt.setString(1, link2.getObjectID());
                stmt.setString(2, link2.getName());
                stmt.setString(3, linkOVID);
                stmt.setString(4, model.getObjectID());
                stmt.setString(5, model.getName());
                stmt.setString(6, modelOVID);
                if (parentObj != null) {
                    stmt.setString(7, parentObj.getObjectID());
                    stmt.setString(8, parentObj.getName());
                    stmt.setString(9, RSRollupLinks.getOrCreateOVID(map, parentObj.getObjectID()));
                    stmt.setString(16, parentObj.getObjectTypeName());
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                    stmt.setString(16, null);
                }
                if (childObj != null) {
                    stmt.setString(10, childObj.getObjectID());
                    stmt.setString(11, childObj.getName());
                    stmt.setString(12, RSRollupLinks.getOrCreateOVID(map, childObj.getObjectID()));
                    stmt.setString(17, childObj.getObjectTypeName());
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                    stmt.setString(17, null);
                }
                if (entObj != null && entObj instanceof Entity) {
                    stmt.setString(13, entObj.getObjectID());
                    stmt.setString(14, entObj.getName());
                    stmt.setString(15, (String)map.get(entObj.getObjectID()));
                } else {
                    stmt.setString(13, null);
                    stmt.setString(14, null);
                    stmt.setString(15, null);
                }
                stmt.setString(18, link2.getOracleLongName());
                stmt.setString(19, link2.getOraclePluralName());
                stmt.setString(20, link2.getOracleShortName());
                stmt.setString(21, link2.getDefaultAggregationOperator());
                stmt.setString(22, link2.isRolePlaying() ? "Y" : "N");
                stmt.setString(23, link2.isSparseDimension() ? "Y" : "N");
                stmt.setString(24, link2.getDescription());
                stmt.setString(25, designOVID);
                stmt.addBatch();
                list.add(link2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (RollupLink link2 : list) {
                    RSObjectNotes.export(map, connection, link2);
                    RSComments.export(map, connection, link2);
                    RSDynamicProperties.export(design, map, connection, link2);
                }
                list.clear();
            }
            RSRollupLinks.exportAttributes(map, connection, linksCollection, designOVID);
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (RollupLink link : list) {
                RSObjectNotes.export(map, connection, link);
                RSComments.export(map, connection, link);
                RSDynamicProperties.export(design, map, connection, link);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportAttributes(Map map, Connection connection, List links, String designOVID) throws Exception {
        int count = 0;
        String attrQuery = "INSERT INTO DMRS_ROLLUP_LINK_ATTRS (Rollup_Link_ID, Rollup_Link_Name, Rollup_Link_OVID, Attribute_ID, Attribute_Name, Attribute_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement attrStmt = connection.prepareStatement(attrQuery);
        for (RollupLink link : links) {
            for (Attribute attr : link.getChildToParentAttributes()) {
                String attrOVID = (String)map.get(attr.getObjectID());
                attrStmt.setString(1, link.getObjectID());
                attrStmt.setString(2, link.getName());
                attrStmt.setString(3, (String)map.get(link.getObjectID()));
                attrStmt.setString(4, attr.getObjectID());
                attrStmt.setString(5, attr.getName());
                attrStmt.setString(6, attrOVID);
                attrStmt.setString(7, designOVID);
                attrStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                attrStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            attrStmt.executeBatch();
        }
        attrStmt.close();
        attrStmt = null;
    }
}

