/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.util.GUID;

public class RSSchemaObject
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<SchemaObject> list = new ArrayList<SchemaObject>(1000);
        int count = 0;
        String designOVID = (String)map.get(design.getObjectID());
        String query = "INSERT INTO DMRS_SCHEMA_OBJECT (Object_ID, Design_OVID, Schema_OVID, Schema_Name) VALUES (?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getRelationalDesigns().iterator();
        while (mit.hasNext()) {
            RelationalDesign model = (RelationalDesign)mit.next();
            String modelOVID = (String)map.get(model.getObjectID());
            Iterator it = model.getSchemaObjectSet().iterator();
            while (it.hasNext()) {
                SchemaObject so2 = (SchemaObject)it.next();
                String ovid = new GUID().toString();
                map.put(so2.getObjectID(), ovid);
                stmt.setString(1, so2.getObjectID());
                stmt.setString(2, designOVID);
                stmt.setString(3, ovid);
                stmt.setString(4, so2.getName());
                stmt.addBatch();
                list.add(so2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (SchemaObject so2 : list) {
                    RSObjectNotes.export(map, connection, so2);
                    RSComments.export(map, connection, so2);
                    RSCommentsInRDBMS.export(map, connection, so2);
                    RSDynamicProperties.export(design, map, connection, so2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (SchemaObject so : list) {
                RSObjectNotes.export(map, connection, so);
                RSComments.export(map, connection, so);
                RSCommentsInRDBMS.export(map, connection, so);
                RSDynamicProperties.export(design, map, connection, so);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

