/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;

public class RSSlices
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Slice> list = new ArrayList<Slice>(1000);
        int count = 0;
        ArrayList<Slice> slicesCollection = new ArrayList<Slice>();
        String query = "INSERT INTO DMRS_SLICES (Slice_ID, Slice_Name, Slice_OVID, Model_ID, Model_Name, Model_OVID, Cube_ID, Cube_Name, Cube_OVID, Entity_ID, Entity_Name, Entity_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Fully_Realized, Is_Read_Only, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getMultidimensionalDesigns().iterator();
        while (mit.hasNext()) {
            MultidimensionalDesign model = (MultidimensionalDesign)mit.next();
            String modelOVID = (String)map.get(model.getObjectID());
            String designOVID = (String)map.get(model.getDesign().getObjectID());
            slicesCollection.clear();
            Iterator it = model.getSliceSet().iterator();
            while (it.hasNext()) {
                Slice slice2 = (Slice)it.next();
                String sliceOVID = RSSlices.getOrCreateOVID(map, slice2.getObjectID());
                slicesCollection.add(slice2);
                Cube cube = slice2.getCube();
                ContainerObject ent = slice2.getEntity();
                stmt.setString(1, slice2.getObjectID());
                stmt.setString(2, slice2.getName());
                stmt.setString(3, sliceOVID);
                stmt.setString(4, model.getObjectID());
                stmt.setString(5, model.getName());
                stmt.setString(6, modelOVID);
                if (cube != null) {
                    stmt.setString(7, cube.getObjectID());
                    stmt.setString(8, cube.getName());
                    stmt.setString(9, RSSlices.getOrCreateOVID(map, cube.getObjectID()));
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                if (ent != null) {
                    stmt.setString(10, ent.getObjectID());
                    stmt.setString(11, ent.getName());
                    stmt.setString(12, (String)map.get(ent.getObjectID()));
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                }
                stmt.setString(13, slice2.getOracleLongName());
                stmt.setString(14, slice2.getOraclePluralName());
                stmt.setString(15, slice2.getOracleShortName());
                stmt.setString(16, slice2.isFullyRealized() ? "Y" : "N");
                stmt.setString(17, slice2.isReadOnlySlice() ? "Y" : "N");
                stmt.setString(18, slice2.getDescription());
                stmt.setString(19, designOVID);
                stmt.addBatch();
                list.add(slice2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Slice slice2 : list) {
                    RSObjectNotes.export(map, connection, slice2);
                    RSComments.export(map, connection, slice2);
                    RSDynamicProperties.export(design, map, connection, slice2);
                }
                list.clear();
            }
            RSSlices.exportDimensionHierarchyLevel(map, connection, slicesCollection, designOVID);
            RSSlices.exportMeasures(map, connection, slicesCollection, designOVID);
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Slice slice : list) {
                RSObjectNotes.export(map, connection, slice);
                RSComments.export(map, connection, slice);
                RSDynamicProperties.export(design, map, connection, slice);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportDimensionHierarchyLevel(Map map, Connection connection, List slices, String designOVID) throws Exception {
        int count = 0;
        String selQuery = "INSERT INTO DMRS_SLICE_DIM_HIER_LEVEL (Slice_ID, Slice_Name, Slice_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Hierarchy_ID, Hierarchy_Name, Hierarchy_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement selStmt = connection.prepareStatement(selQuery);
        for (Slice slice : slices) {
            for (Slice.SelectedLevel sel : slice.getSelectedLevels()) {
                Dimension dim = sel.getDimension();
                Hierarchy hier = sel.getHierarchy();
                Level level = sel.getLevel();
                selStmt.setString(1, slice.getObjectID());
                selStmt.setString(2, slice.getName());
                selStmt.setString(3, (String)map.get(slice.getObjectID()));
                if (dim != null) {
                    selStmt.setString(4, dim.getObjectID());
                    selStmt.setString(5, dim.getName());
                    selStmt.setString(6, RSSlices.getOrCreateOVID(map, dim.getObjectID()));
                } else {
                    selStmt.setString(4, null);
                    selStmt.setString(5, null);
                    selStmt.setString(6, null);
                }
                if (hier != null) {
                    selStmt.setString(7, hier.getObjectID());
                    selStmt.setString(8, hier.getName());
                    selStmt.setString(9, RSSlices.getOrCreateOVID(map, hier.getObjectID()));
                } else {
                    selStmt.setString(7, null);
                    selStmt.setString(8, null);
                    selStmt.setString(9, null);
                }
                if (level != null) {
                    selStmt.setString(10, level.getObjectID());
                    selStmt.setString(11, level.getName());
                    selStmt.setString(12, RSSlices.getOrCreateOVID(map, level.getObjectID()));
                } else {
                    selStmt.setString(10, null);
                    selStmt.setString(11, null);
                    selStmt.setString(12, null);
                }
                selStmt.setString(13, designOVID);
                selStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                selStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            selStmt.executeBatch();
        }
        selStmt.close();
        selStmt = null;
    }

    private static void exportMeasures(Map map, Connection connection, List slices, String designOVID) throws Exception {
        int count = 0;
        String measQuery = "INSERT INTO DMRS_SLICE_MEASURES (Slice_ID, Slice_Name, Slice_OVID, Measure_ID, Measure_Name, Measure_OVID, Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Measure_Alias, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement measStmt = connection.prepareStatement(measQuery);
        for (Slice slice : slices) {
            for (Slice.MeasureWrapper mw : slice.getAllMeasureWrappers()) {
                Measure meas = mw.getMeasure();
                if (meas == null) continue;
                String measOVID = RSSlices.getOrCreateOVID(map, meas.getObjectID());
                Measure.AggregateFunction af = mw.getAggrFunction();
                measStmt.setString(1, slice.getObjectID());
                measStmt.setString(2, slice.getName());
                measStmt.setString(3, (String)map.get(slice.getObjectID()));
                measStmt.setString(4, meas.getObjectID());
                measStmt.setString(5, meas.getName());
                measStmt.setString(6, measOVID);
                if (af != null) {
                    measStmt.setString(7, af.getObjectID());
                    measStmt.setString(8, af.getName());
                    measStmt.setString(9, RSSlices.getOrCreateOVID(map, af.getObjectID()));
                } else {
                    measStmt.setString(7, null);
                    measStmt.setString(8, null);
                    measStmt.setString(9, null);
                }
                measStmt.setString(10, mw.getMeasureAlias());
                measStmt.setString(11, designOVID);
                measStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                measStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            measStmt.executeBatch();
        }
        measStmt.close();
        measStmt = null;
    }
}

