/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSTableIncludeScripts
extends RSGeneral {
    public static void export(Map map, Connection connection, Table table) throws Exception {
        String query = "INSERT INTO DMRS_TABLE_INCLUDE_SCRIPTS (Table_ID, Table_OVID, Table_Name, Type, Sequence, Text, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        String tableOVID = (String)map.get(table.getObjectID());
        RSTableIncludeScripts.addScript(map, stmt, table, tableOVID, "Before Drop", table.getBeforeDrop());
        RSTableIncludeScripts.addScript(map, stmt, table, tableOVID, "Before Create", table.getBeforeCreate());
        RSTableIncludeScripts.addScript(map, stmt, table, tableOVID, "After Create", table.getAfterCreate());
        RSTableIncludeScripts.addScript(map, stmt, table, tableOVID, "End of Script", table.getEndOfScript());
        stmt.close();
        stmt = null;
    }

    private static void addScript(Map map, PreparedStatement stmt, Table table, String tableOVID, String type, String text) throws Exception {
        if (!"".equalsIgnoreCase(text)) {
            int seq = 0;
            while (text.length() > 4000) {
                ++seq;
                String t1 = text.substring(0, 4000);
                int bytes = 4000;
                try {
                    bytes = t1.getBytes("UTF-8").length;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (bytes > 4000) {
                    int diff = bytes - 4000;
                    t1 = text.substring(0, 4000 - diff);
                    text = text.substring(4000 - diff);
                } else {
                    text = text.substring(4000);
                }
                stmt.setString(1, table.getObjectID());
                stmt.setString(2, tableOVID);
                stmt.setString(3, table.getName());
                stmt.setString(4, type);
                stmt.setInt(5, seq);
                stmt.setString(6, t1);
                stmt.setString(7, (String)map.get(table.getDesign().getObjectID()));
                stmt.executeUpdate();
            }
            if (text.length() > 0) {
                stmt.setString(1, table.getObjectID());
                stmt.setString(2, tableOVID);
                stmt.setString(3, table.getName());
                stmt.setString(4, type);
                stmt.setInt(5, ++seq);
                stmt.setString(6, text);
                stmt.setString(7, (String)map.get(table.getDesign().getObjectID()));
                stmt.executeUpdate();
            }
        }
    }
}

