/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSViewContainers;
import oracle.dbtools.crest.exports.reports.RSViewDefinition;
import oracle.dbtools.crest.exports.reports.RSViewOrderGroupby;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.util.GUID;

public class RSTableViews
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<TableView> list = new ArrayList<TableView>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_TABLEVIEWS (TableView_Name, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Where_Clause, Having_Clause, User_Defined, Engineer, Allow_Type_Substitution, OID_Columns, Model_Name, Design_OVID, Schema_OVID, Schema_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getRelationalDesigns().iterator();
        while (mit.hasNext()) {
            RelationalDesign model = (RelationalDesign)mit.next();
            String modelOVID = (String)map.get(model.getObjectID());
            Iterator it = model.getTableViewSet().iterator();
            while (it.hasNext()) {
                TableView view2 = (TableView)it.next();
                String ovid = new GUID().toString();
                map.put(view2.getObjectID(), ovid);
                stmt.setString(1, view2.getName());
                stmt.setString(2, view2.getObjectID());
                stmt.setString(3, ovid);
                stmt.setString(4, view2.getImportedId());
                stmt.setString(5, model.getObjectID());
                stmt.setString(6, modelOVID);
                stmt.setString(7, view2.getBasedOnStructuredType() != null ? view2.getBasedOnStructuredType().getObjectID() : null);
                stmt.setString(8, view2.getBasedOnStructuredType() != null ? (String)map.get(view2.getBasedOnStructuredType().getObjectID()) : null);
                stmt.setString(9, view2.getBasedOnStructuredType() != null ? view2.getBasedOnStructuredType().getName() : null);
                stmt.setString(10, view2.getWhere());
                stmt.setString(11, view2.getHaving());
                stmt.setString(12, view2.getUserDefined() ? "Y" : "N");
                stmt.setString(13, view2.getShouldEngineer() ? "Y" : "N");
                stmt.setString(14, view2.isAllowTypeSubstitution() ? "Y" : "N");
                stmt.setString(15, view2.getOidText());
                stmt.setString(16, model.getName());
                stmt.setString(17, (String)map.get(design.getObjectID()));
                stmt.setString(18, view2.getSchemaObject() != null ? (String)map.get(view2.getSchemaObject().getObjectID()) : null);
                stmt.setString(19, view2.getSchemaObject() != null ? view2.getSchemaObject().getName() : null);
                stmt.addBatch();
                list.add(view2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (TableView view2 : list) {
                    RSObjectNotes.export(map, connection, view2);
                    RSComments.export(map, connection, view2);
                    RSCommentsInRDBMS.export(map, connection, view2);
                    RSViewDefinition.export(map, connection, view2);
                    RSViewContainers.export(map, connection, view2);
                    RSViewOrderGroupby.export(map, connection, view2);
                    RSDynamicProperties.export(design, map, connection, view2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (TableView view : list) {
                RSObjectNotes.export(map, connection, view);
                RSComments.export(map, connection, view);
                RSCommentsInRDBMS.export(map, connection, view);
                RSViewDefinition.export(map, connection, view);
                RSViewContainers.export(map, connection, view);
                RSViewOrderGroupby.export(map, connection, view);
                RSDynamicProperties.export(design, map, connection, view);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

