/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSColumnGroups;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSPKOidColumns;
import oracle.dbtools.crest.exports.reports.RSSpatialColumnDefinition;
import oracle.dbtools.crest.exports.reports.RSTableConstraints;
import oracle.dbtools.crest.exports.reports.RSTableIncludeScripts;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.util.GUID;

public class RSTables
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Table> list = new ArrayList<Table>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_TABLES (Table_Name, Abbreviation, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Number_Data_Elements, Classification_Type_ID, Classification_Type_OVID, Classification_Type_Name, Allow_Type_Substitution, Min_Volume, Expected_Volume, Max_Volume, Growth_Rate_Percents, Growth_Rate_Interval, Normal_Form, Temporary_Object_Scope, Adequately_Normalized, Substitution_Parent, Substitution_Parent_OVID, Engineer, Spatial_Table, OID_is_PK, OID_is_User_Defined, Include_Scripts_Into_DDL, Model_Name, Substitution_Parent_Name, Design_OVID, Schema_OVID, Schema_Name, Source_Info_OVID, Source_DataDict_Schema_Name, Source_DataDict_Object_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getRelationalDesigns().iterator();
        while (mit.hasNext()) {
            RelationalDesign model = (RelationalDesign)mit.next();
            String modelOVID = (String)map.get(model.getObjectID());
            Iterator it = model.getTableSet().iterator();
            while (it.hasNext()) {
                ClassificationType ct;
                Table table2 = (Table)it.next();
                String ovid = new GUID().toString();
                map.put(table2.getObjectID(), ovid);
                stmt.setString(1, table2.getName());
                stmt.setString(2, table2.getAbbreviation());
                stmt.setString(3, table2.getObjectID());
                stmt.setString(4, ovid);
                stmt.setString(5, table2.getImportedId());
                stmt.setString(6, model.getObjectID());
                stmt.setString(7, modelOVID);
                stmt.setString(8, table2.getBasedOnStructuredType() != null ? table2.getBasedOnStructuredType().getObjectID() : null);
                stmt.setString(9, table2.getBasedOnStructuredType() != null ? (String)map.get(table2.getBasedOnStructuredType().getObjectID()) : null);
                stmt.setString(10, table2.getBasedOnStructuredType() != null ? table2.getBasedOnStructuredType().getName() : null);
                stmt.setInt(11, table2.getElements().length);
                stmt.setString(12, null);
                stmt.setString(13, null);
                stmt.setString(14, null);
                if (!"".equalsIgnoreCase(table2.getTypeID()) && (ct = design.getDesignLevelSettings().getClassificationTypeByID(table2.getTypeID())) != null) {
                    String ctOVID = (String)ctMap.get(ct.getTypeID());
                    stmt.setString(12, table2.getTypeID());
                    stmt.setString(13, ctOVID);
                    stmt.setString(14, ct.getTypeName());
                }
                stmt.setString(15, table2.isAllowTypeSubstitution() ? "Y" : "N");
                stmt.setObject(16, table2.getMinVolumes());
                stmt.setObject(17, table2.getExpectedVolumes());
                stmt.setObject(18, table2.getMaxVolumes());
                stmt.setInt(19, table2.getGrowthPercentInt());
                stmt.setString(20, table2.getGrowthType());
                stmt.setString(21, table2.getNormalForm());
                stmt.setString(22, table2.getScope());
                stmt.setString(23, "YES".equalsIgnoreCase(table2.getAdequatelyNormalized()) ? "Y" : "N");
                stmt.setString(24, table2.getTypeSubstitution() != null ? table2.getTypeSubstitution().getObjectID() : null);
                stmt.setString(25, table2.getTypeSubstitution() != null ? RSTables.getOrCreateOVID(map, table2.getTypeSubstitution().getObjectID()) : null);
                stmt.setString(26, table2.getShouldEngineer() ? "Y" : "N");
                stmt.setString(27, table2.isSpatialTable() ? "Y" : "N");
                stmt.setString(28, table2.isOidIsPK() ? "Y" : "N");
                stmt.setString(29, table2.isUserDefinedOid() ? "Y" : "N");
                stmt.setString(30, table2.getShouldGenerateScript() ? "Y" : "N");
                stmt.setString(31, model.getName());
                stmt.setString(32, table2.getTypeSubstitution() != null ? table2.getTypeSubstitution().getName() : null);
                stmt.setString(33, (String)map.get(design.getObjectID()));
                stmt.setString(34, table2.getSchemaObject() != null ? (String)map.get(table2.getSchemaObject().getObjectID()) : null);
                stmt.setString(35, table2.getSchemaObject() != null ? table2.getSchemaObject().getName() : null);
                if (!"".equals(table2.getSourceDDLFile())) {
                    String dInfoKey = "D" + table2.getSourceDDLFile() + model.getObjectID();
                    String dInfoOVID = (String)map.get(dInfoKey);
                    stmt.setString(36, dInfoOVID);
                    stmt.setString(37, null);
                    stmt.setString(38, null);
                } else if (!"".equals(table2.getSourceConnName())) {
                    String bInfoKey = "B" + table2.getSourceConnName() + model.getObjectID();
                    String bInfoOVID = (String)map.get(bInfoKey);
                    stmt.setString(36, bInfoOVID);
                    stmt.setString(37, table2.getSourceObjSchema());
                    stmt.setString(38, table2.getSourceObjName());
                } else {
                    stmt.setString(36, null);
                    stmt.setString(37, null);
                    stmt.setString(38, null);
                }
                stmt.addBatch();
                list.add(table2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Table table2 : list) {
                    RSObjectNotes.export(map, connection, table2);
                    RSComments.export(map, connection, table2);
                    RSCommentsInRDBMS.export(map, connection, table2);
                    RSTableConstraints.export(map, connection, table2);
                    RSSpatialColumnDefinition.export(map, connection, table2);
                    RSTableIncludeScripts.export(map, connection, table2);
                    if (table2.isBST()) {
                        RSPKOidColumns.export(map, connection, table2);
                    }
                    RSColumnGroups.export(map, connection, table2);
                    RSDynamicProperties.export(design, map, connection, table2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Table table : list) {
                RSObjectNotes.export(map, connection, table);
                RSComments.export(map, connection, table);
                RSCommentsInRDBMS.export(map, connection, table);
                RSTableConstraints.export(map, connection, table);
                RSSpatialColumnDefinition.export(map, connection, table);
                RSTableIncludeScripts.export(map, connection, table);
                if (table.isBST()) {
                    RSPKOidColumns.export(map, connection, table);
                }
                RSColumnGroups.export(map, connection, table);
                RSDynamicProperties.export(design, map, connection, table);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

