/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;

public class RSViewColumns
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<ColumnView> list = new ArrayList<ColumnView>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_VIEW_COLUMNS (View_OVID, View_ID, View_Name, Container_ID, Container_OVID, Container_Name, Container_Alias, Is_Expression, Column_ID, Column_OVID, Column_Name, Column_Alias, Native_Type, Type, Personally_ID_Information, Sensitive_Information, Mask_For_None_Production, Expression, Sequence, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator mit = design.getRelationalDesigns().iterator();
        while (mit.hasNext()) {
            RelationalDesign model = (RelationalDesign)mit.next();
            String modelOVID = (String)map.get(model.getObjectID());
            Iterator it = model.getColumnViewSet().iterator();
            while (it.hasNext()) {
                ColumnView column2 = (ColumnView)it.next();
                String ovid = RSViewColumns.getOrCreateOVID(map, column2.getObjectID());
                TableView view = (TableView)column2.getContainer();
                ArrayList elements = (ArrayList)view.getElementsCollection();
                Table refTable = (Table)column2.getTable();
                TableView refView = (TableView)column2.getView();
                Column refColumn = (Column)column2.getReferencedColumn();
                ColumnView refColView = (ColumnView)column2.getReferencedColumnView();
                String refAlias = column2.getTableAlias();
                String columnAlias = column2.getAlias();
                String expr = column2.getExpression();
                stmt.setString(1, RSViewColumns.getOrCreateOVID(map, view.getObjectID()));
                stmt.setString(2, view.getObjectID());
                stmt.setString(3, view.getName());
                if (refTable != null && refColumn != null) {
                    stmt.setString(4, refTable.getObjectID());
                    stmt.setString(5, RSViewColumns.getOrCreateOVID(map, refTable.getObjectID()));
                    stmt.setString(6, refTable.getName());
                    stmt.setString(7, refAlias != null && !refAlias.equals("") ? refAlias : refTable.getName());
                    stmt.setString(8, "N");
                    stmt.setString(9, refColumn.getObjectID());
                    stmt.setString(10, RSViewColumns.getOrCreateOVID(map, refColumn.getObjectID()));
                    stmt.setString(11, refColumn.getName());
                    stmt.setString(12, columnAlias != null && !columnAlias.equals("") ? columnAlias : refColumn.getName());
                    stmt.setString(13, refColumn.getDataType().getName());
                    stmt.setString(14, "T");
                    stmt.setString(15, refColumn.isContainsPII() == null ? null : (refColumn.isContainsPII() != false ? "Y" : "N"));
                    stmt.setString(16, refColumn.isContainsSensitiveInformation() == null ? null : (refColumn.isContainsSensitiveInformation() != false ? "Y" : "N"));
                    stmt.setString(17, refColumn.getMaskingType());
                    stmt.setString(18, "");
                } else if (refView != null && refColView != null) {
                    stmt.setString(4, refView.getObjectID());
                    stmt.setString(5, RSViewColumns.getOrCreateOVID(map, refView.getObjectID()));
                    stmt.setString(6, refView.getName());
                    stmt.setString(7, refAlias != null && !refAlias.equals("") ? refAlias : refView.getName());
                    stmt.setString(8, "N");
                    stmt.setString(9, refColView.getObjectID());
                    stmt.setString(10, RSViewColumns.getOrCreateOVID(map, refColView.getObjectID()));
                    stmt.setString(11, refColView.getAlias() != null && !refColView.getAlias().equals("") ? refColView.getAlias() : refColView.getName());
                    stmt.setString(12, columnAlias != null && !columnAlias.equals("") ? columnAlias : (refColView.getAlias() != null ? refColView.getAlias() : refColView.getName()));
                    stmt.setString(13, refColView.getDataType());
                    stmt.setString(14, "V");
                    stmt.setString(15, "");
                    stmt.setString(16, "");
                    stmt.setString(17, "");
                    stmt.setString(18, "");
                } else {
                    stmt.setString(4, view.getObjectID());
                    stmt.setString(5, RSViewColumns.getOrCreateOVID(map, view.getObjectID()));
                    stmt.setString(6, view.getName());
                    stmt.setString(7, refAlias != null && !refAlias.equals("") ? refAlias : view.getName());
                    stmt.setString(8, "Y");
                    stmt.setString(9, column2.getObjectID());
                    stmt.setString(10, ovid);
                    stmt.setString(11, column2.getName());
                    stmt.setString(12, columnAlias != null && !columnAlias.equals("") ? columnAlias : column2.getName());
                    stmt.setString(13, "");
                    stmt.setString(14, "V");
                    stmt.setString(15, "");
                    stmt.setString(16, "");
                    stmt.setString(17, "");
                    stmt.setString(18, expr != null ? expr : "");
                }
                stmt.setInt(19, elements.indexOf(column2) + 1);
                stmt.setString(20, model.getObjectID());
                stmt.setString(21, modelOVID);
                stmt.setString(22, model.getName());
                stmt.setString(23, (String)map.get(design.getObjectID()));
                stmt.addBatch();
                list.add(column2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (ColumnView column2 : list) {
                    RSObjectNotes.export(map, connection, column2);
                    RSComments.export(map, connection, column2);
                    RSCommentsInRDBMS.export(map, connection, column2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (ColumnView column : list) {
                RSObjectNotes.export(map, connection, column);
                RSComments.export(map, connection, column);
                RSCommentsInRDBMS.export(map, connection, column);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

