/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.Component;
import java.awt.Container;
import javax.ide.util.MetaClass;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOSGiController;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNAddCommand;
import oracle.dbtools.raptor.filenav.FileNavigatorManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.NavigatorWindow;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class FileNavigatorWrapper {
    private static FileNavigatorWrapper INSTANCE = new FileNavigatorWrapper();

    private FileNavigatorWrapper() {
        FileNavigatorManager fileNavigatorManager = FileNavigatorManager.getInstance();
        fileNavigatorManager.initialize();
        NavigatorWindow fileNavigatorWindow = fileNavigatorManager.getNavigatorWindow();
        fileNavigatorWindow.getGUI();
        ContextMenu contextMenu = fileNavigatorWindow.getTreeExplorer().getContextMenu();
        ContextMenuListener dmFileNavigatorCML = new ContextMenuListener(){

            public void menuWillShow(ContextMenu contextMenu) {
                float menuWeight = Float.MAX_VALUE;
                IdeAction addAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)SVNAddCommand.class.getName()));
                if (addAction != null) {
                    addAction.setCommand(new MetaClass(Ide.class.getClassLoader(), SVNAddCommand.class.getName()));
                    addAction.setName(Resource.get((String)"ACTION_ADD_NAME"));
                    addAction.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"add.png"));
                    addAction.setEnabled(true);
                    DMSVNOSGiController.getInstance().register(addAction, (Command)new SVNAddCommand());
                }
                JMenu updatedVersioningMenu = contextMenu.createMenu(Messages.getString("DataModelingAddin.Versioning"), 0.0f);
                Container container = contextMenu.getGUI(true);
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    JMenuItem mi;
                    Component c = container.getComponent(i);
                    if (!(c instanceof JMenuItem) || !(mi = (JMenuItem)c).getText().equalsIgnoreCase(Messages.getString("DataModelingAddin.Versioning"))) continue;
                    JMenu vm = (JMenu)mi;
                    MenuItem addMernuItem = new MenuItem((ToggleAction)addAction);
                    Component[] vmc = ((JMenu)mi).getMenuComponents();
                    contextMenu.remove((Component)mi);
                    boolean enableAdd = false;
                    for (int v = 0; v < vmc.length; ++v) {
                        if (((MenuItem)vmc[v]).getText().equalsIgnoreCase(Messages.getString("DataModelingAddin.Commit"))) {
                            ((IdeAction)((MenuItem)vmc[v]).getAction()).updateAction();
                            enableAdd = !((IdeAction)((MenuItem)vmc[v]).getAction()).isEnabled();
                        }
                        updatedVersioningMenu.add((JMenuItem)((MenuItem)vmc[v]));
                    }
                    addMernuItem.getAction().setEnabled(enableAdd);
                    updatedVersioningMenu.add((JMenuItem)addMernuItem);
                    contextMenu.add((Component)updatedVersioningMenu);
                }
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }
        };
        contextMenu.addContextMenuListener(dmFileNavigatorCML);
    }

    public static FileNavigatorWrapper getInstance() {
        return INSTANCE;
    }

    public void showWindow() {
        String FILE_NAVIGATOR_WINDOW_ID = "FileNavigatorWindow";
        ViewId viewId = new ViewId(FILE_NAVIGATOR_WINDOW_ID);
        DockStation dockStation = DockStation.getDockStation();
        DockableWindow fileNavigatorWindow = (DockableWindow)dockStation.getDockable(viewId);
        if (fileNavigatorWindow == null) {
            fileNavigatorWindow = FileNavigatorManager.getInstance().getNavigatorWindow();
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition(0);
            dockStation.dock((Dockable)fileNavigatorWindow, dockingParam);
        }
        fileNavigatorWindow.show();
        dockStation.activateDockable((Dockable)fileNavigatorWindow);
    }
}

