/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.crest.fcp.GlobalSearchDockable;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.search.GlobalSearchPanel;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;

public class GlobalSearch {
    private JSearchTextField searchBox = null;
    private final DockStation dockStation = DockStation.getDockStation();
    private JPanel mainPanel;
    private SearchAsUTypeListener sutListener;
    private EnterKeyListener ekl;
    private ApplicationView appView;
    private Settings settings;

    public GlobalSearch(ApplicationView appView) {
        this.appView = appView;
        this.settings = appView.getSettings();
        this.initializeToolbar();
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.searchBox, "Center");
    }

    private void initializeToolbar() {
        this.searchBox = new JSearchTextField(false, true, "");
        if (Extension.isDataModeler()) {
            this.searchBox.setPreferredSize(new Dimension(200, Ide.getToolbar().getHeight()));
        } else {
            this.searchBox.setPreferredSize(new Dimension(200, 20));
        }
        this.sutListener = new SearchAsUTypeListener();
        this.ekl = new EnterKeyListener();
        this.searchBox.addKeyListener(this.ekl);
        this.searchBox.getDocument().addDocumentListener(this.sutListener);
    }

    public JPanel getGUI() {
        int h = Ide.getToolbar().getHeight();
        if (h > 10) {
            this.mainPanel.setMaximumSize(new Dimension(250, h));
            this.mainPanel.setMinimumSize(new Dimension(250, h));
            this.mainPanel.repaint();
        } else {
            this.mainPanel.setMaximumSize(new Dimension(250, 20));
            this.mainPanel.setMinimumSize(new Dimension(250, 20));
            this.mainPanel.repaint();
        }
        return this.mainPanel;
    }

    private void runSearch(boolean enterKeyUsed) {
        GlobalSearchPanel gsp = null;
        GlobalSearchDockable globalSearchDockable = null;
        Dockable dockable = this.dockStation.getDockable(GlobalSearchDockable.VIEW_ID);
        if (this.searchBox.getText().trim().equals("")) {
            if (dockable != null) {
                globalSearchDockable = (GlobalSearchDockable)dockable;
                gsp = (GlobalSearchPanel)globalSearchDockable.getGUI();
                gsp.resetItems(this.searchBox);
            }
        } else {
            this.search(enterKeyUsed);
        }
    }

    private void search(boolean enterKeyUsed) {
        GlobalSearchPanel gsp = null;
        GlobalSearchDockable globalSearchDockable = null;
        Dockable dockable = this.dockStation.getDockable(GlobalSearchDockable.VIEW_ID);
        if (dockable == null) {
            globalSearchDockable = new GlobalSearchDockable();
            gsp = (GlobalSearchPanel)globalSearchDockable.getGUI();
            gsp.resetItems(this.searchBox);
            gsp.runSearch(enterKeyUsed);
            globalSearchDockable.show();
        } else if (dockable instanceof GlobalSearchDockable) {
            globalSearchDockable = (GlobalSearchDockable)dockable;
            gsp = (GlobalSearchPanel)globalSearchDockable.getGUI();
            gsp.resetItems(this.searchBox);
            gsp.runSearch(enterKeyUsed);
            if (!globalSearchDockable.isVisible()) {
                this.dockStation.activateDockable((Dockable)globalSearchDockable);
            }
        }
    }

    private class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                GlobalSearch.this.runSearch(true);
            }
        }
    }

    private class SearchAsUTypeListener
    implements DocumentListener {
        private SearchAsUTypeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GlobalSearch.this.runSearch(false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GlobalSearch.this.runSearch(false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            GlobalSearch.this.runSearch(false);
        }
    }
}

