/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DiagramLogicalModelPreferences;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class DiagramLogicalModelPP
extends AbstractPP {
    private static final long serialVersionUID = 2634829318573257787L;
    private static final String UNTITLED_DESIGN = oracle.dbtools.crest.model.Messages.getString("Design.Untitled");
    private JComboBox cbNotation;
    private static final String BACHMAN_IMAGE = "BACHMAN_IMAGE";
    private static final String BARKER_IMAGE = "BARKER_IMAGE";
    private final CardLayout clNotation = new CardLayout();
    private JCheckBox chbBoxInBox;
    private final String USE_DOMAN_NAME = Messages.getString("OptionsDialog.DomainName");
    private final String USE_LOGICAL_TYPE = Messages.getString("OptionsDialog.UsedLogicalType");
    private JPanel mainPanel;

    public DiagramLogicalModelPP() {
        this.setHelpID("DIAGRAM_LOGICAL_MODEL_PREFS_PANEL");
        this.mainPanel = new JPanel(new GridBagLayout());
        JPanel pnNotation = new JPanel(new GridBagLayout());
        JPanel jp = new JPanel(new FlowLayout(0));
        pnNotation.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.NotationType")));
        this.cbNotation = new JComboBox<Object>(Diagram.getNotations());
        this.cbNotation.setPreferredSize(new Dimension(160, 20));
        this.addItem(jp, this.cbNotation, 0, 0, 1, 1, 17, 100, 100);
        ImageIcon imgBachman = (ImageIcon)GUIConfiguration.getInstance().getIcon("NOTATION_BACHMAN");
        JLabel lbBachman = new JLabel(imgBachman, 0);
        ImageIcon imgBarker = (ImageIcon)GUIConfiguration.getInstance().getIcon("NOTATION_BARKER");
        JLabel lbBarker = new JLabel(imgBarker, 0);
        final JPanel jpImage = new JPanel(this.clNotation);
        jpImage.add((Component)lbBachman, BACHMAN_IMAGE);
        jpImage.add((Component)lbBarker, BARKER_IMAGE);
        this.addItem(jp, jpImage, 1, 0, 1, 1, 17, 100, 100);
        this.addItem(pnNotation, jp, 0, 0, 1, 1, 17, 100, 100);
        this.addItem(this.mainPanel, pnNotation, 0, 0, 1, 1, 17, 1, 100);
        this.cbNotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (DiagramLogicalModelPP.this.cbNotation.getSelectedIndex()) {
                    case 0: {
                        DiagramLogicalModelPP.this.clNotation.show(jpImage, DiagramLogicalModelPP.BACHMAN_IMAGE);
                        break;
                    }
                    case 1: {
                        DiagramLogicalModelPP.this.clNotation.show(jpImage, DiagramLogicalModelPP.BARKER_IMAGE);
                        break;
                    }
                    default: {
                        DiagramLogicalModelPP.this.clNotation.show(jpImage, DiagramLogicalModelPP.BACHMAN_IMAGE);
                    }
                }
            }
        });
        jp = new JPanel(new GridBagLayout());
        this.chbBoxInBox = new JCheckBox(Messages.getString("OptionsDialog.BoxInBoxPresentation"));
        this.addItem(jp, this.chbBoxInBox, 0, 1, 1, 1, 17, 100, 100);
        this.addItem(this.mainPanel, jp, 0, 1, 1, 1, 17, 100, 100);
        jp = new JPanel(new FlowLayout(0));
        this.addItem(this.mainPanel, jp, 0, 2, 1, 1, 17, 1, 100);
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext tc) {
        this.chbBoxInBox.setSelected(settings.isBoxInBox());
        this.cbNotation.setSelectedIndex(settings.getNotation());
    }

    public void onExit(TraversableContext tc) {
        settings.setBoxInBox(this.chbBoxInBox.isSelected());
        settings.setNotation(this.cbNotation.getSelectedIndex());
        DiagramLogicalModelPreferences preferences = this.getDiagramLogicalModelPreferences(tc);
        preferences.setBoxInBox(this.chbBoxInBox.isSelected());
        preferences.setNotation(this.cbNotation.getSelectedIndex());
        if (!this.getCurrentDesign().getName().equals(UNTITLED_DESIGN + "_1") || this.getApplicationView().getDesigns().size() == 1) {
            // empty if block
        }
    }

    private DiagramLogicalModelPreferences getDiagramLogicalModelPreferences(TraversableContext tc) {
        return DiagramLogicalModelPreferences.getInstance(tc.getPropertyStorage());
    }
}

