/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplate;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelPhysicalOraclePreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelPhysicalOraclePP";
    private static final String DU = "oracle_user";
    private static final String DT = "oracle_tablespace";
    private static final String UTT = "use_oracle_table_template";
    private static final String UIT = "use_oracle_index_template";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelPhysicalOraclePreferences(HashStructure hash) {
        super(hash);
    }

    public static ModelPhysicalOraclePreferences getInstance(PropertyStorage prefs) {
        return new ModelPhysicalOraclePreferences(ModelPhysicalOraclePreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public String getDefaultOracleUser() {
        return this._hash.getString(DU);
    }

    public void setDefaultOracleUser(String defaultOracleUser) {
        this._hash.putString(DU, defaultOracleUser);
    }

    public String getDefaultOracleTablespace() {
        return this._hash.getString(DT);
    }

    public void setDefaultOracleTablespace(String defaultOracleTablespace) {
        this._hash.putString(DT, defaultOracleTablespace);
    }

    public boolean getUseOracleTableTemplate() {
        return this._hash.getBoolean(UTT);
    }

    public void setUseOracleTableTemplate(boolean useOracleTableTemplate) {
        this._hash.putBoolean(UTT, useOracleTableTemplate);
    }

    public boolean getUseOracleIndexTemplate() {
        return this._hash.getBoolean(UIT);
    }

    public void setUseOracleIndexTemplate(boolean useOracleIndexTemplate) {
        this._hash.putBoolean(UIT, useOracleIndexTemplate);
    }

    public String getDefaultOracleTriggerName() {
        return this._hash.getString("oracle_trigger_name");
    }

    public void setDefaultOracleTriggerName(String defaultOracleTriggerName) {
        this._hash.putString("oracle_trigger_name", defaultOracleTriggerName);
    }

    public String getDefaultOracleSequenceName() {
        return this._hash.getString("oracle_sequence_name");
    }

    public void setDefaultOracleSequenceName(String defaultOracleSequenceName) {
        this._hash.putString("oracle_sequence_name", defaultOracleSequenceName);
    }

    public String getDefaultOracleAutoIncDDL() {
        return this._hash.getString("oracle_auto_inc_ddl");
    }

    public void setDefaultOracleAutoIncDDL(String defaultOracleAutoIncDDL) {
        this._hash.putString("oracle_auto_inc_ddl", defaultOracleAutoIncDDL);
    }

    public String getDefaultOracleIdentityDDL() {
        return this._hash.getString("oracle_identity_ddl");
    }

    public void setDefaultOracleIdentityDDL(String defaultOracleIdentityDDL) {
        this._hash.putString("oracle_identity_ddl", defaultOracleIdentityDDL);
    }

    public void setTableTemplate(OracleTableTemplate ott) {
        HashStructure hs = HashStructure.newInstance();
        hs.putString("ott_temporary", ott.getTemporary());
        hs.putString("ott_preserve_rows", ott.getPreserveRows());
        hs.putString("ott_tableSpace", ott.getTableSpace());
        hs.putString("ott_organization", ott.getOrganization());
        hs.putString("ott_logging", ott.getLogging());
        hs.putString("ott_segment", ott.getSegment());
        hs.putString("ott_cache", ott.getCache());
        hs.putString("ott_monitoring", ott.getMonitoring());
        hs.putString("ott_parallel", ott.getParallel());
        hs.putString("ott_degree", ott.getDegree());
        hs.putString("ott_row_dependency", ott.getRowDependency());
        hs.putString("ott_partitioned", ott.getPartitioned());
        hs.putString("ott_row_movement", ott.getRowMovement());
        hs.putString("ott_data_compression", ott.getDataCompression());
        this._hash.putHashStructure("oracle_table_template", hs);
    }

    public void setIndexTemplate(OracleIndexTemplate oit) {
        HashStructure hs = HashStructure.newInstance();
        hs.putString("oit_bitmap_index", String.valueOf(oit.isBitmapIndex()));
        hs.putString("oit_partitioned", oit.getPartitioned());
        hs.putString("oit_tablespace", oit.getTableSpace());
        hs.putString("oit_logging", oit.getLogging());
        hs.putString("oit_segment", oit.getSegment());
        hs.putString("oit_compress", String.valueOf(oit.getCompress()));
        hs.putString("oit_parallel", oit.getParallel());
        hs.putString("oit_degree", oit.getDegree());
        hs.putString("oit_sorted_rows", oit.getSortedRows());
        hs.putString("oit_compute_stats", oit.getComputeStatistics());
        hs.putString("oit_online", oit.getOnline());
        this._hash.putHashStructure("oracle_index_template", hs);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        HashStructure hsOIT;
        HashStructure hsOTT;
        if (this.contains(DU)) {
            settings.setDefaultOracleUser(this.getDefaultOracleUser());
        }
        if (this.contains(DT)) {
            settings.setDefaultOracleTablespace(this.getDefaultOracleTablespace());
        }
        if (this.contains(UTT)) {
            settings.setUseOracleTableTemplate(this.getUseOracleTableTemplate());
        }
        if (this.contains(UIT)) {
            settings.setUseOracleIndexTemplate(this.getUseOracleIndexTemplate());
        }
        if (this.contains("oracle_trigger_name")) {
            settings.setDefaultOracleTriggerName(this.getDefaultOracleTriggerName());
        }
        if (this.contains("oracle_sequence_name")) {
            settings.setDefaultOracleSequenceName(this.getDefaultOracleSequenceName());
        }
        if (this.contains("oracle_auto_inc_ddl")) {
            settings.setDefaultOracleAutoIncDDL(this.getDefaultOracleAutoIncDDL());
        }
        if (this.contains("oracle_identity_ddl")) {
            settings.setDefaultOracleIdentityDDL(this.getDefaultOracleIdentityDDL());
        }
        if ((hsOTT = this._hash.getHashStructure("oracle_table_template")) != null) {
            OracleTableTemplate ott = settings.getOracleTableTemplate();
            ott.setTemporary(hsOTT.getString("ott_temporary"));
            ott.setPreserveRows(hsOTT.getString("ott_preserve_rows"));
            ott.setTableSpace(hsOTT.getString("ott_tableSpace"));
            ott.setOrganization(hsOTT.getString("ott_organization"));
            ott.setLogging(hsOTT.getString("ott_logging"));
            ott.setSegment(hsOTT.getString("ott_segment"));
            ott.setCache(hsOTT.getString("ott_cache"));
            ott.setMonitoring(hsOTT.getString("ott_monitoring"));
            ott.setParallel(hsOTT.getString("ott_parallel"));
            ott.setDegree(hsOTT.getString("ott_degree"));
            ott.setRowDependency(hsOTT.getString("ott_row_dependency"));
            ott.setPartitioned(hsOTT.getString("ott_partitioned"));
            ott.setRowMovement(hsOTT.getString("ott_row_movement"));
            ott.setDataCompression(hsOTT.getString("ott_data_compression"));
        }
        if ((hsOIT = this._hash.getHashStructure("oracle_index_template")) != null) {
            OracleIndexTemplate oit = settings.getOracleIndexTemplate();
            oit.setBitmapIndex(Boolean.valueOf(hsOIT.getString("oit_bitmap_index")));
            oit.setPartitioned(hsOIT.getString("oit_partitioned"));
            oit.setTableSpace(hsOIT.getString("oit_tablespace"));
            oit.setLogging(hsOIT.getString("oit_logging"));
            oit.setSegment(hsOIT.getString("oit_segment"));
            oit.setCompress(Integer.parseInt(hsOIT.getString("oit_compress")));
            oit.setParallel(hsOIT.getString("oit_parallel"));
            oit.setDegree(hsOIT.getString("oit_degree"));
            oit.setSortedRows(hsOIT.getString("oit_sorted_rows"));
            oit.setComputeStatistics(hsOIT.getString("oit_compute_stats"));
            oit.setOnline(hsOIT.getString("oit_online"));
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setDefaultOracleTablespace(settings.getDefaultOracleTablespace());
        this.setDefaultOracleUser(settings.getDefaultOracleUser());
        this.setUseOracleIndexTemplate(settings.useOracleIndexTemplate());
        this.setUseOracleTableTemplate(settings.useOracleTableTemplate());
        this.setDefaultOracleTriggerName(settings.getDefaultOracleTriggerName());
        this.setDefaultOracleSequenceName(settings.getDefaultOracleSequenceName());
        this.setDefaultOracleAutoIncDDL(settings.getDefaultOracleAutoIncDDL());
        this.setDefaultOracleIdentityDDL(settings.getDefaultOracleIdentityDDL());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

