/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelSynchronizationPhysicalOraclePreferences;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

final class ModelSynchronizationPhysicalOraclePP
extends AbstractPP {
    private static final String DIALOG_NAME = Messages.getString("OptionsDialog.NameElementProvider");
    private JTable itemsTable;
    private List itemsList = new ArrayList();
    private JPanel main;

    public ModelSynchronizationPhysicalOraclePP() {
        this.setHelpID("MODEL_SYNC_PHYSICAL_ORACLE");
        this.main = new JPanel(new GridBagLayout());
        this.itemsTable = new JTable(new ItemsTableModel());
        JTableHeader header = this.itemsTable.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        TableColumn selectedColumn = this.itemsTable.getColumnModel().getColumn(1);
        selectedColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        selectedColumn.setPreferredWidth(150);
        selectedColumn.setMaxWidth(150);
        this.itemsTable.setSelectionMode(0);
        this.main.add((Component)new JScrollPane(this.itemsTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.add(this.main, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext tc) {
        this.itemsList.clear();
        for (SyncObject so : settings.getSyncObjects()) {
            if (!so.getDatabase().equals("Oracle")) continue;
            this.itemsList.add(so);
        }
        this.itemsTable.updateUI();
    }

    public void onExit(TraversableContext tc) {
        for (SyncObject so : this.itemsList) {
            SyncObject sObj = settings.getSyncObject(so.getType(), so.getDatabase());
            if (sObj == null) continue;
            sObj.setUsed(so.isUsed());
        }
        ModelSynchronizationPhysicalOraclePreferences preferences = this.getModelSynchronizationPhysicalOraclePreferences(tc);
        preferences.rebuildHashStructure(settings);
    }

    @Override
    protected String getDialogName() {
        return DIALOG_NAME;
    }

    private ModelSynchronizationPhysicalOraclePreferences getModelSynchronizationPhysicalOraclePreferences(TraversableContext tc) {
        return ModelSynchronizationPhysicalOraclePreferences.getInstance(tc.getPropertyStorage());
    }

    class ItemsTableModel
    extends AbstractTableModel {
        ItemsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ModelSynchronizationPhysicalOraclePP.this.itemsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ModelSynchronizationPhysicalOraclePP.Type");
            }
            return Messages.getString("ModelSynchronizationPhysicalOraclePP.Synchronize");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SyncObject so = (SyncObject)ModelSynchronizationPhysicalOraclePP.this.itemsList.get(rowIndex);
            if (columnIndex == 0) {
                return so.getType();
            }
            if (columnIndex == 1) {
                return so.isUsed();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            SyncObject so = (SyncObject)ModelSynchronizationPhysicalOraclePP.this.itemsList.get(row);
            if (column == 1) {
                so.setUsed((Boolean)value);
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }
    }
}

