/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ModelSynchronizationPhysicalOraclePreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ModelSynchronizationPhysicalPP";
    private static final String ST = "synchronization_types";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ModelSynchronizationPhysicalOraclePreferences(HashStructure hash) {
        super(hash);
    }

    public static ModelSynchronizationPhysicalOraclePreferences getInstance(PropertyStorage prefs) {
        return new ModelSynchronizationPhysicalOraclePreferences(ModelSynchronizationPhysicalOraclePreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public HashStructure getSynchronizationTypes() {
        return this._hash.getHashStructure(ST);
    }

    public void rebuildHashStructure(Settings settings) {
        int counter = 0;
        Iterator it = settings.getSyncObjects().iterator();
        HashStructure hsBasic = HashStructure.newInstance();
        while (it.hasNext()) {
            ++counter;
            SyncObject sync = (SyncObject)it.next();
            HashStructure hs = HashStructure.newInstance();
            hs.putString("db", sync.getDatabase());
            hs.putString("name", sync.getType());
            hs.putBoolean("used", sync.isUsed());
            hsBasic.putHashStructure(Integer.toString(counter), hs);
        }
        this._hash.putHashStructure(ST, hsBasic);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        HashStructure stHash = this.getSynchronizationTypes();
        if (stHash != null) {
            Set stringKeys = stHash.keySet();
            TreeSet<Integer> integerKeys = new TreeSet<Integer>();
            Iterator it = stringKeys.iterator();
            while (it.hasNext()) {
                integerKeys.add(new Integer((String)it.next()));
            }
            for (Integer key : integerKeys) {
                HashStructure hs = stHash.getHashStructure(Integer.toString(key));
                String elementDb = hs.getString("db");
                String elementName = hs.getString("name");
                boolean elementIsUsed = hs.getBoolean("used");
                SyncObject so = settings.getSyncObject(elementName, elementDb);
                if (so != null) {
                    so.setUsed(elementIsUsed);
                    continue;
                }
                SyncObject sOb = new SyncObject(elementName, elementIsUsed, elementDb);
                settings.getSyncObjects().add(sOb);
            }
        }
    }

    public void loadFromSettings(Settings settings) {
        HashStructure hs = this.getSynchronizationTypes();
        if (hs != null) {
            hs.clear();
        }
        for (SyncObject so : settings.getSyncObjects()) {
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

