/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.DDLComparisonPP;
import oracle.dbtools.crest.fcp.preferences.DDLPP;
import oracle.dbtools.crest.fcp.preferences.DDLPreferences;
import oracle.dbtools.crest.fcp.preferences.DDLStoragePP;
import oracle.dbtools.crest.fcp.preferences.DiagramLogicalModelPP;
import oracle.dbtools.crest.fcp.preferences.DiagramLogicalModelPreferences;
import oracle.dbtools.crest.fcp.preferences.DiagramPP;
import oracle.dbtools.crest.fcp.preferences.DiagramPreferences;
import oracle.dbtools.crest.fcp.preferences.DiagramRelationalModelPP;
import oracle.dbtools.crest.fcp.preferences.DiagramRelationalModelPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelLogicalPP;
import oracle.dbtools.crest.fcp.preferences.ModelLogicalPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalDB2PP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalDB2Preferences;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalOraclePP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalOraclePreferences;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalSQLServerPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalSQLServerPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalUDBPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalUDBPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelRelationalPP;
import oracle.dbtools.crest.fcp.preferences.ModelRelationalPreferences;
import oracle.dbtools.crest.fcp.preferences.ModelSynchronizationPhysicalOraclePP;
import oracle.dbtools.crest.fcp.preferences.ModelSynchronizationPhysicalOraclePreferences;
import oracle.dbtools.crest.fcp.preferences.ModelingPreferences;
import oracle.dbtools.crest.fcp.preferences.SearchPP;
import oracle.dbtools.crest.fcp.preferences.SearchPreferences;
import oracle.dbtools.crest.fcp.preferences.ThirdPartyJDBCDriversPP;
import oracle.dbtools.crest.fcp.preferences.ThirdPartyJDBCDriversPreferences;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.CustomDesignRulesPersistence;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.PropertyStorage;

final class ModelingPP
extends AbstractPP {
    private static final long serialVersionUID = -4336060296077324103L;
    private JTextField defaultPrjPath;
    private JTextField defaultImportPath;
    private JTextField defaultSavePath;
    private JTextField defaultSytemTypesPath;
    private JTextField defaultReportsPath;
    private JTextField defaultSaxonPath;
    private JCheckBox chbShowSelectRelModelDialog;
    private JCheckBox chbShowPropertiesDialogOnNew;
    private JCheckBox chbUseThickDriver;
    private JCheckBox chbImportLog;
    private JCheckBox chbReloadLastState;
    private JButton bnImport;
    private JButton bnExport;
    private StringBuffer buffer;
    private static final Logger LOGGER = new Logger(Settings.class);
    private TraversableContext cTC;
    private JPanel mainPanel;
    private static File lastImpFolder = null;
    private static File lastExpFolder = null;
    private String oldCSPath = "";
    private CustomDesignRulesPersistence designRulesPersistence;

    public ModelingPP() {
        this.setHelpID("DATA_MODELER_PREFS_PANEL");
        this.mainPanel = new JPanel(new GridBagLayout());
        this.createDefaultProjectPathOption();
        this.createImportFiles();
        this.createSaveFiles();
        this.createSystemTypes();
        this.createReports();
        this.createCbPanel();
        JPanel btnPanel = new JPanel(new GridBagLayout());
        this.bnImport = new JButton(this.createImportButton());
        this.bnImport.setMnemonic(73);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnExport = new JButton(this.createExportButton());
        this.bnExport.setMnemonic(69);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.addItem(btnPanel, this.bnImport, 0, 1, 1, 1, 17, 0, 1);
        this.addItem(btnPanel, this.bnExport, 1, 1, 1, 1, 17, 0, 1);
        this.addItem(this.mainPanel, btnPanel, 0, 6, 1, 1, 17, 0, 1, 3, 0, 0, 5);
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext tc) {
        DBConfig options = DBConfig.getInstance((TraversableContext)tc);
        this.defaultPrjPath.setText(settings.getDefaultDesignsPath());
        this.defaultImportPath.setText(settings.getDefaultImportPath());
        this.defaultSavePath.setText(settings.getDefaultSavePath());
        this.defaultSytemTypesPath.setText(settings.getDefaultSystemTypesPath());
        this.defaultReportsPath.setText(settings.getDefaultReportsPath());
        this.defaultSaxonPath.setText(settings.getDefaultSaxonPath());
        this.chbShowSelectRelModelDialog.setSelected(settings.showSelectRelModelDialog());
        this.chbShowPropertiesDialogOnNew.setSelected(settings.showPropertiesDialogOnNew());
        this.chbUseThickDriver.setSelected(options.getBoolean("USE_THICK_DRIVER"));
        this.chbImportLog.setSelected(settings.showImportLog());
        this.chbReloadLastState.setSelected(settings.isReloadLastState());
        this.cTC = tc;
        this.oldCSPath = settings.getDefaultSystemTypesPath();
        ModelingPP.validateDirectory(this.defaultPrjPath);
        ModelingPP.validateDirectory(this.defaultImportPath);
        ModelingPP.validateDirectory(this.defaultSavePath);
        ModelingPP.validateDirectory(this.defaultSytemTypesPath);
        ModelingPP.validateDirectory(this.defaultReportsPath);
        ModelingPP.validateDirectory(this.defaultSaxonPath);
    }

    public void onExit(TraversableContext tc) {
        DBConfig options = DBConfig.getInstance((TraversableContext)tc);
        settings.setDefaultDesignsPath(this.defaultPrjPath.getText());
        settings.setDefaultImportPath(this.defaultImportPath.getText());
        settings.setDefaultSavePath(this.defaultSavePath.getText());
        settings.setDefaultReportsPath(this.defaultReportsPath.getText());
        settings.setDefaultSaxonPath(this.defaultSaxonPath.getText());
        settings.setDefaultSystemTypesPath(this.defaultSytemTypesPath.getText());
        settings.setShowSelectRelModelDialog(this.chbShowSelectRelModelDialog.isSelected());
        settings.setShowPropertiesDialogOnNew(this.chbShowPropertiesDialogOnNew.isSelected());
        options.putBoolean("USE_THICK_DRIVER", this.chbUseThickDriver.isSelected());
        settings.setShowImportLog(this.chbImportLog.isSelected());
        settings.setReloadLastState(this.chbReloadLastState.isSelected());
        ModelingPreferences preferences = this.getModelingPreferences(tc);
        preferences.setDefaultDesignsPath(this.defaultPrjPath.getText());
        preferences.setDefaultImportPath(this.defaultImportPath.getText());
        preferences.setDefaultSavePath(this.defaultSavePath.getText());
        preferences.setDefaultReportsPath(this.defaultReportsPath.getText());
        preferences.setDefaultSaxonPath(this.defaultSaxonPath.getText());
        preferences.setDefaultSystemTypesPath(this.defaultSytemTypesPath.getText());
        preferences.setShowSelectRelModelDialog(this.chbShowSelectRelModelDialog.isSelected());
        preferences.setShowPropertiesDialogOnNew(this.chbShowPropertiesDialogOnNew.isSelected());
        preferences.setShowImportLog(this.chbImportLog.isSelected());
        preferences.setReloadLastState(this.chbReloadLastState.isSelected());
        if (!this.oldCSPath.equals(this.defaultSytemTypesPath.getText())) {
            this.getCustomDesignRulesPersistence().loadCustomDRScripts(settings);
        }
    }

    private void createDefaultProjectPathOption() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DefaultDesignsDirectory")));
        this.defaultPrjPath = new JTextField();
        this.defaultPrjPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultPrjPath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultPrjPath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultPrjPath);
            }
        });
        JButton bnSelect = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultPrjPath.getText()));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultPrjPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(panel, this.defaultPrjPath, 0, 0, 1, 1, 17, 1, 100);
        this.addItem(panel, bnSelect, 1, 0, 1, 1, 17, 0, 100);
        this.addItem(this.mainPanel, panel, 0, 0, 1, 1, 17, 1, 100);
    }

    private void createImportFiles() {
        JPanel importPanel = new JPanel(new GridBagLayout());
        importPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DefaultImportDirectory")));
        this.defaultImportPath = new JTextField();
        this.defaultImportPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultImportPath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultImportPath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultImportPath);
            }
        });
        this.addItem(importPanel, this.defaultImportPath, 0, 1, 1, 1, 17, 1, 100);
        JButton bnSelectImport = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelectImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultImportPath.getText()));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultImportPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(importPanel, bnSelectImport, 1, 1, 1, 1, 17, 0, 100);
        this.chbImportLog = new JCheckBox(Messages.getString("OptionsDialog.ShowLogAfterImport"));
        this.addItem(importPanel, this.chbImportLog, 0, 2, 1, 1, 17, 1, 100);
        this.getApplicationView();
        if (!ApplicationView.IS_VIEWER) {
            this.addItem(this.mainPanel, importPanel, 0, 1, 1, 1, 17, 1, 100);
        }
    }

    private void createSaveFiles() {
        JPanel savePanel = new JPanel(new GridBagLayout());
        savePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.DefaultSaveDirectory")));
        this.defaultSavePath = new JTextField();
        this.defaultSavePath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSavePath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSavePath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSavePath);
            }
        });
        this.addItem(savePanel, this.defaultSavePath, 0, 1, 1, 1, 17, 1, 100);
        JButton bnSelect = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultSavePath.getText()));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultSavePath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(savePanel, bnSelect, 1, 1, 1, 1, 17, 0, 100);
        this.getApplicationView();
        if (!ApplicationView.IS_VIEWER) {
            this.addItem(this.mainPanel, savePanel, 0, 2, 1, 1, 17, 1, 100);
        }
    }

    private void createSystemTypes() {
        JPanel systemTypesPanel = new JPanel(new GridBagLayout());
        systemTypesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.SystemTypesDirectory")));
        this.defaultSytemTypesPath = new JTextField();
        this.defaultSytemTypesPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSytemTypesPath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSytemTypesPath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSytemTypesPath);
            }
        });
        JButton bnSelect = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultSytemTypesPath.getText()));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultSytemTypesPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(systemTypesPanel, this.defaultSytemTypesPath, 0, 0, 1, 1, 17, 1, 1);
        this.addItem(systemTypesPanel, bnSelect, 1, 0, 1, 1, 17, 0, 1);
        this.addItem(this.mainPanel, systemTypesPanel, 0, 3, 1, 1, 17, 0, 1);
    }

    private void createReports() {
        JPanel reportsPanel = new JPanel(new GridBagLayout());
        reportsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.Reports")));
        JPanel reportsPathPanel = new JPanel(new GridBagLayout());
        reportsPathPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.ReportsDirectory")));
        JPanel reportsSaxonPanel = new JPanel(new GridBagLayout());
        reportsSaxonPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.ReportsDirectorySaxonJarLabel")));
        this.defaultReportsPath = new JTextField();
        this.defaultReportsPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultReportsPath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultReportsPath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultReportsPath);
            }
        });
        JButton bnSelect = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultReportsPath.getText()));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultReportsPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.defaultSaxonPath = new JTextField();
        this.defaultSaxonPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSaxonPath);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSaxonPath);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractPP.validateDirectory(ModelingPP.this.defaultSaxonPath);
            }
        });
        JButton bnSelectS = new JButton(Messages.getString("OptionsDialog.Select"));
        bnSelectS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ModelingPP.this.defaultSaxonPath.getText()));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.SelectSaxonJAR"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ModelingPP.this.defaultSaxonPath.setText(file.getAbsolutePath());
                }
            }
        });
        this.addItem(reportsPathPanel, this.defaultReportsPath, 0, 0, 1, 1, 17, 1, 1);
        this.addItem(reportsPathPanel, bnSelect, 1, 0, 1, 1, 17, 0, 1);
        this.addItem(reportsSaxonPanel, this.defaultSaxonPath, 0, 0, 1, 1, 17, 1, 1);
        this.addItem(reportsSaxonPanel, bnSelectS, 1, 0, 1, 1, 17, 0, 1);
        reportsPanel.add((Component)reportsPathPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        reportsPanel.add((Component)reportsSaxonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addItem(this.mainPanel, reportsPanel, 0, 4, 1, 1, 17, 0, 1);
    }

    private void createCbPanel() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.setBorder(BorderFactory.createTitledBorder(" "));
        this.chbShowSelectRelModelDialog = new JCheckBox(Messages.getString("OptionsDialog.ShowSelectRelationalModelsDialog"));
        this.chbShowPropertiesDialogOnNew = new JCheckBox(Messages.getString("OptionsDialog.ShowPropertiesDialog"));
        this.chbUseThickDriver = new JCheckBox(Messages.getString("OptionsDialog.UseThickDriver"));
        this.chbReloadLastState = new JCheckBox(Messages.getString("OptionsDialog.ReloadLastState"));
        this.addItem(jpanel, this.chbShowSelectRelModelDialog, 0, 0, 1, 1, 17, 1, 1);
        this.getApplicationView();
        if (!ApplicationView.IS_VIEWER) {
            this.addItem(jpanel, this.chbShowPropertiesDialogOnNew, 0, 2, 1, 1, 17, 1, 1);
        }
        this.addItem(jpanel, this.chbUseThickDriver, 0, 3, 1, 1, 17, 1, 1);
        this.addItem(jpanel, this.chbReloadLastState, 0, 4, 1, 1, 17, 1, 1);
        this.addItem(this.mainPanel, jpanel, 0, 5, 1, 1, 17, 0, 1);
    }

    public Action createImportButton() {
        AbstractAction action = new AbstractAction(Messages.getString("OptionsDialog.Import")){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLFilter fileFilter = new URLFilter(){

                    public boolean accept(URL url) {
                        File file = new File(url.getPath());
                        return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("OptionsDialog.XMLFiles");
                    }
                };
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(0);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setURLFilter(fileFilter);
                if (lastImpFolder != null) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
                } else {
                    String lastDir = ModelingPP.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (lastDir != null && lastDir.length() > 0) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = ModelingPP.this.getApplicationView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                }
                int result = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.ImportSettings"));
                if (result == 0) {
                    try {
                        File file = new File(fileChooser.getSelectedURL().getPath());
                        if (file.exists()) {
                            int ch;
                            lastImpFolder = file.getParentFile();
                            ModelingPP.this.buffer = new StringBuffer();
                            FileInputStream fis = new FileInputStream(file);
                            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                            BufferedReader in = new BufferedReader(isr);
                            while ((ch = ((Reader)in).read()) > -1) {
                                ModelingPP.this.buffer.append((char)ch);
                            }
                            ((Reader)in).close();
                            AbstractPP.settings.loadSettingsFromString(ModelingPP.this.buffer.toString());
                            Preferences p = Preferences.getPreferences();
                            ModelingPreferences mp = ModelingPP.this.getModelingPreferences(ModelingPP.this.cTC);
                            mp.loadFromSettings(AbstractPP.settings);
                            ModelingPP.this.onEntry(ModelingPP.this.cTC);
                            DDLPreferences ddlp = DDLPreferences.getInstance((PropertyStorage)p);
                            ddlp.loadFromSettings(AbstractPP.settings);
                            DDLPP ddlPP = new DDLPP();
                            ddlPP.onEntry(ModelingPP.this.cTC);
                            ddlPP.onExit(ModelingPP.this.cTC);
                            DDLComparisonPP ddlcPP = new DDLComparisonPP();
                            ddlcPP.onEntry(ModelingPP.this.cTC);
                            ddlcPP.onExit(ModelingPP.this.cTC);
                            DDLStoragePP ddlsPP = new DDLStoragePP();
                            ddlsPP.onEntry(ModelingPP.this.cTC);
                            ddlsPP.onExit(ModelingPP.this.cTC);
                            DiagramPreferences dp = DiagramPreferences.getInstance((PropertyStorage)p);
                            dp.loadFromSettings(AbstractPP.settings);
                            DiagramPP dPP = new DiagramPP();
                            dPP.onEntry(ModelingPP.this.cTC);
                            dPP.onExit(ModelingPP.this.cTC);
                            DiagramLogicalModelPreferences dlp = DiagramLogicalModelPreferences.getInstance((PropertyStorage)p);
                            dlp.loadFromSettings(AbstractPP.settings);
                            DiagramLogicalModelPP dlPP = new DiagramLogicalModelPP();
                            dlPP.onEntry(ModelingPP.this.cTC);
                            dlPP.onExit(ModelingPP.this.cTC);
                            DiagramRelationalModelPreferences drp = DiagramRelationalModelPreferences.getInstance((PropertyStorage)p);
                            drp.loadFromSettings(AbstractPP.settings);
                            DiagramRelationalModelPP drPP = new DiagramRelationalModelPP();
                            drPP.onEntry(ModelingPP.this.cTC);
                            drPP.onExit(ModelingPP.this.cTC);
                            ModelPreferences mop = ModelPreferences.getInstance((PropertyStorage)p);
                            mop.loadFromSettings(AbstractPP.settings);
                            ModelPP mPP = new ModelPP();
                            mPP.onEntry(ModelingPP.this.cTC);
                            mPP.onExit(ModelingPP.this.cTC);
                            ModelLogicalPreferences mlp = ModelLogicalPreferences.getInstance((PropertyStorage)p);
                            mlp.loadFromSettings(AbstractPP.settings);
                            ModelLogicalPP mlPP = new ModelLogicalPP();
                            mlPP.onEntry(ModelingPP.this.cTC);
                            mlPP.onExit(ModelingPP.this.cTC);
                            ModelPhysicalOraclePreferences mpo = ModelPhysicalOraclePreferences.getInstance((PropertyStorage)p);
                            mpo.loadFromSettings(AbstractPP.settings);
                            ModelPhysicalOraclePP mpoPP = new ModelPhysicalOraclePP();
                            mpoPP.onEntry(ModelingPP.this.cTC);
                            mpoPP.onExit(ModelingPP.this.cTC);
                            ModelPhysicalDB2Preferences mpdb2 = ModelPhysicalDB2Preferences.getInstance((PropertyStorage)p);
                            mpdb2.loadFromSettings(AbstractPP.settings);
                            ModelPhysicalDB2PP mpdb2PP = new ModelPhysicalDB2PP();
                            mpdb2PP.onEntry(ModelingPP.this.cTC);
                            mpdb2PP.onExit(ModelingPP.this.cTC);
                            ModelPhysicalSQLServerPreferences mps = ModelPhysicalSQLServerPreferences.getInstance((PropertyStorage)p);
                            mps.loadFromSettings(AbstractPP.settings);
                            ModelPhysicalSQLServerPP mpsPP = new ModelPhysicalSQLServerPP();
                            mpsPP.onEntry(ModelingPP.this.cTC);
                            mpsPP.onExit(ModelingPP.this.cTC);
                            ModelPhysicalUDBPreferences mpu = ModelPhysicalUDBPreferences.getInstance((PropertyStorage)p);
                            mpu.loadFromSettings(AbstractPP.settings);
                            ModelPhysicalUDBPP mpuPP = new ModelPhysicalUDBPP();
                            mpuPP.onEntry(ModelingPP.this.cTC);
                            mpuPP.onExit(ModelingPP.this.cTC);
                            ModelRelationalPreferences mrp = ModelRelationalPreferences.getInstance((PropertyStorage)p);
                            mrp.loadFromSettings(AbstractPP.settings);
                            ModelRelationalPP mrpPP = new ModelRelationalPP();
                            mrpPP.onEntry(ModelingPP.this.cTC);
                            mrpPP.onExit(ModelingPP.this.cTC);
                            ThirdPartyJDBCDriversPreferences jp = ThirdPartyJDBCDriversPreferences.getInstance((PropertyStorage)p);
                            jp.loadFromSettings(AbstractPP.settings);
                            ThirdPartyJDBCDriversPP jpPP = new ThirdPartyJDBCDriversPP();
                            jpPP.onEntry(ModelingPP.this.cTC);
                            jpPP.onExit(ModelingPP.this.cTC);
                            ModelSynchronizationPhysicalOraclePreferences st = ModelSynchronizationPhysicalOraclePreferences.getInstance((PropertyStorage)p);
                            st.loadFromSettings(AbstractPP.settings);
                            ModelSynchronizationPhysicalOraclePP stPP = new ModelSynchronizationPhysicalOraclePP();
                            stPP.onEntry(ModelingPP.this.cTC);
                            stPP.onExit(ModelingPP.this.cTC);
                            SearchPreferences sp = SearchPreferences.getInstance((PropertyStorage)p);
                            sp.loadFromSettings(AbstractPP.settings);
                            SearchPP sPP = new SearchPP();
                            sPP.onEntry(ModelingPP.this.cTC);
                            sPP.onExit(ModelingPP.this.cTC);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unable to initialize settings from imported file: ", ex);
                    }
                }
            }
        };
        return action;
    }

    public Action createExportButton() {
        AbstractAction action = new AbstractAction(Messages.getString("OptionsDialog.Export")){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLFilter fileFilter = new URLFilter(){

                    public boolean accept(URL url) {
                        File file = new File(url.getPath());
                        return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("OptionsDialog.XMLFiles");
                    }
                };
                URLChooser fileChooser = DialogUtil.newURLChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(0);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setURLFilter(fileFilter);
                if (lastExpFolder != null) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                } else {
                    String lastDir = ModelingPP.this.getApplicationView().getSettings().getDefaultSavePath();
                    if (lastDir != null && lastDir.length() > 0) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = ModelingPP.this.getApplicationView().getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                }
                int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("OptionsDialog.ExportSettings"));
                if (status == 0) {
                    File file = new File(fileChooser.getSelectedURL().getPath());
                    String[] ext = fileChooser.getSelectedFilter().toString().replaceAll("(^.*\\()|(\\).*$)", "").split("\\)\\(");
                    if (file != null) {
                        lastExpFolder = file.getParentFile();
                        String fileName = file.toString();
                        if (!ext[0].equalsIgnoreCase("")) {
                            fileName = fileName + ext[0].substring(1);
                        }
                        AbstractPP.settings.setSettingsFileName(fileName);
                        AbstractPP.settings.saveSettings();
                        AbstractPP.settings.setSettingsFileName("settings.xml");
                    }
                }
            }
        };
        return action;
    }

    private ModelingPreferences getModelingPreferences(TraversableContext tc) {
        return ModelingPreferences.getInstance(tc.getPropertyStorage());
    }

    private CustomDesignRulesPersistence getCustomDesignRulesPersistence() {
        if (this.designRulesPersistence == null) {
            this.designRulesPersistence = new CustomDesignRulesPersistence(this.getApplicationView());
        }
        return this.designRulesPersistence;
    }
}

