/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.DRTemporary;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class RuleSetPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_RuleSets";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected RuleSetPreferences(HashStructure hash) {
        super(hash);
    }

    public static RuleSetPreferences getInstance(PropertyStorage prefs) {
        return new RuleSetPreferences(RuleSetPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public void setDesignruleSets(List rulesets, ApplicationView appView) {
        HashStructure hsBasic = HashStructure.newInstance();
        for (DesignRuleSet drs : rulesets) {
            HashStructure hsRs = HashStructure.newInstance();
            hsRs.putString("name", drs.getName());
            for (DesignRule dr : drs.getDesignRules()) {
                HashStructure hsDesignRule = HashStructure.newInstance();
                hsDesignRule.putString("model_type", dr.getContextString());
                hsDesignRule.putString("object", dr.getRuleHandler() != null ? dr.getRuleHandler().getLabel() : "");
                hsDesignRule.putString("name", dr.getName());
                hsRs.putHashStructure(dr.getRuleId(), hsDesignRule);
            }
            drs.initDesignRules(appView);
            hsBasic.putHashStructure(drs.getObjectID(), hsRs);
        }
        this._hash.putHashStructure("rule_sets", hsBasic);
    }

    public HashStructure getDesignruleSets() {
        return this._hash.getHashStructure("rule_sets");
    }

    public void loadToSettings(Settings settings, ApplicationView appView) {
        HashStructure hsBasic = this.getDesignruleSets();
        if (hsBasic != null) {
            settings.getDesignRuleSets().clear();
            Set keys = hsBasic.keySet();
            for (String key : keys) {
                HashStructure hs = hsBasic.getHashStructure(key);
                DesignRuleSet drs = new DesignRuleSet(hs.getString("name"), key);
                Set keys1 = hs.keySet();
                for (String key1 : keys1) {
                    if (key1.equals("name")) continue;
                    HashStructure hs1 = hs.getHashStructure(key1);
                    DRTemporary drt = new DRTemporary();
                    drt.setRuleId(key1);
                    drt.setContextString(hs1.getString("model_type"));
                    drt.setName(hs1.getString("name"));
                    drt.setObject(hs1.getString("object"));
                    drs.addDesignRuleTemporary(drt);
                }
                drs.initDesignRules(appView);
                settings.getDesignRuleSets().add(drs);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

