/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.SearchPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.ide.panels.TraversableContext;

public class SearchPP
extends AbstractPP {
    private JRadioButton rbSearchOnEnter;
    private JRadioButton rbSearchOnTyping;
    private JIntegerField txtSearchStartsStart;

    public SearchPP() {
        this.setHelpID("SEARCH_PANEL");
        JPanel pnMain = new JPanel(new GridBagLayout());
        pnMain.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.SimpleSearchOptions")));
        ButtonGroup searchTypeTypeGroup = new ButtonGroup();
        this.rbSearchOnEnter = new JRadioButton(Messages.getString("OptionsDialog.PressEnterToSearch"));
        this.rbSearchOnEnter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchPP.this.txtSearchStartsStart.setEnabled(false);
                }
            }
        });
        this.rbSearchOnTyping = new JRadioButton(Messages.getString("OptionsDialog.SearchAsYouType"));
        this.rbSearchOnTyping.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchPP.this.txtSearchStartsStart.setEnabled(true);
                }
            }
        });
        searchTypeTypeGroup.add(this.rbSearchOnEnter);
        searchTypeTypeGroup.add(this.rbSearchOnTyping);
        JPanel jp = new JPanel(new FlowLayout(0));
        JLabel label1 = new JLabel(Messages.getString("OptionsDialog.After"));
        label1.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.txtSearchStartsStart = new JIntegerField(3, 2);
        this.txtSearchStartsStart.setText("3");
        this.addItem(jp, label1, 0, 0, 1, 1, 17, 0, 0);
        this.addItem(jp, this.txtSearchStartsStart, 1, 0, 1, 1, 17, 0, 0);
        this.addItem(pnMain, this.rbSearchOnEnter, 0, 0, 1, 1, 17, 0, 100);
        this.addItem(pnMain, new JLabel(""), 1, 0, 1, 1, 17, 1, 100);
        this.addItem(pnMain, this.rbSearchOnTyping, 0, 1, 1, 1, 17, 0, 100);
        this.addItem(pnMain, jp, 0, 2, 1, 1, 17, 1, 1);
        this.add(pnMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    public void onEntry(TraversableContext tc) {
        this.rbSearchOnEnter.setSelected(!settings.isSearchAsUType());
        this.rbSearchOnTyping.setSelected(settings.isSearchAsUType());
        this.txtSearchStartsStart.setText(Integer.toString(settings.getSearchAsUTypeStart()));
    }

    public void onExit(TraversableContext tc) {
        SearchPreferences sp = this.getSearchPreferences(tc);
        settings.setSearchAsUType(this.rbSearchOnTyping.isSelected());
        settings.setSearchAsUTypeStart(Integer.parseInt(this.txtSearchStartsStart.getText()));
        sp.setSearchAsUType(this.rbSearchOnTyping.isSelected());
        sp.setSearchAsUTypeStart(Integer.parseInt(this.txtSearchStartsStart.getText()));
    }

    private SearchPreferences getSearchPreferences(TraversableContext tc) {
        return SearchPreferences.getInstance(tc.getPropertyStorage());
    }
}

