/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class SearchPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_SEARCHPP";
    private static final String SEARCH_AS_U_TYPE = "search_as_u_type";
    private static final String SEARCH_AS_U_TYPE_START = "search_as_u_type_start";

    protected SearchPreferences(HashStructure hash) {
        super(hash);
    }

    public static SearchPreferences getInstance(PropertyStorage prefs) {
        return new SearchPreferences(SearchPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public boolean isSearchAsUType() {
        return this._hash.getBoolean(SEARCH_AS_U_TYPE);
    }

    public void setSearchAsUType(boolean sut) {
        this._hash.putBoolean(SEARCH_AS_U_TYPE, sut);
    }

    public int getSearchAsUTypeStart() {
        return this._hash.getInt(SEARCH_AS_U_TYPE_START);
    }

    public void setSearchAsUTypeStart(int start) {
        this._hash.putInt(SEARCH_AS_U_TYPE_START, start);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(SEARCH_AS_U_TYPE)) {
            settings.setSearchAsUType(this.isSearchAsUType());
        }
        if (this.contains(SEARCH_AS_U_TYPE_START)) {
            settings.setSearchAsUTypeStart(this.getSearchAsUTypeStart());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setSearchAsUType(settings.isSearchAsUType());
        this.setSearchAsUTypeStart(settings.getSearchAsUTypeStart());
    }
}

