/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class ThirdPartyJDBCDriversPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_ThirdPartyJDBCDriversPP";
    private static final String DRIVERS = "third_party_jdbc_drivers";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    private ThirdPartyJDBCDriversPreferences(HashStructure hash) {
        super(hash);
    }

    public static ThirdPartyJDBCDriversPreferences getInstance(PropertyStorage prefs) {
        return new ThirdPartyJDBCDriversPreferences(ThirdPartyJDBCDriversPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public ListStructure getJDBCDrivers() {
        return this._hash.getListStructure(DRIVERS);
    }

    public void setJDBCDrivers(List list) {
        ListStructure ls = ListStructure.newInstance();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ls.add((Object)((String)it.next()));
        }
        this._hash.putListStructure(DRIVERS, ls);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        settings.clearJDBCDrivers();
        ListStructure ld = this.getJDBCDrivers();
        if (ld != null) {
            for (String driver : ld) {
                settings.addJDBCDriver(driver);
            }
        }
    }

    public void loadFromSettings(Settings settings) {
        ListStructure ls = this.getJDBCDrivers();
        if (ls != null) {
            ls.clear();
        }
        this.setJDBCDrivers(settings.getJDBCDrivers());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

