/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.ide.model.Displayable;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationTablePanel;
import oracle.jdevimpl.vcs.vop.ClientVersionOperationModel;

public class ChangeListTablePanel
extends VersionOperationTablePanel
implements IChangeListPanel {
    protected JTable table = (JTable)this.getInternalComponent();
    protected List<StorableObjectStatus> statuses;

    @Override
    public List<StorableObjectStatus> update() {
        if (this.statuses != null) {
            return this.update(this.statuses);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<StorableObjectStatus> update(List<StorableObjectStatus> statuses) {
        ArrayList<StorableObjectStatus> recognizedStatuses = null;
        ClientVersionOperationModel model = new ClientVersionOperationModel();
        if (statuses != null) {
            recognizedStatuses = new ArrayList<StorableObjectStatus>();
            ArrayList<FilePathDisplayable> filePaths = new ArrayList<FilePathDisplayable>(statuses.size());
            for (StorableObjectStatus storableObjectStatus : statuses) {
                if (!storableObjectStatus.isNotVersioned() || storableObjectStatus.getRevision() != null) continue;
                recognizedStatuses.add(storableObjectStatus);
                filePaths.add(new FilePathDisplayable(storableObjectStatus.getFilePath()));
            }
            this.statuses = recognizedStatuses;
            model.add(filePaths);
        }
        this.installModel((VersionOperationModel)model);
        return recognizedStatuses;
    }

    @Override
    public List<StorableObjectStatus> getStatuses() {
        return this.statuses;
    }

    @Override
    public List<File> getSelectedFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories) {
        ArrayList<File> selectedFilePaths = new ArrayList<File>(this.table.getSelectedRowCount());
        for (int selectedRow : this.table.getSelectedRows()) {
            selectedFilePaths.add(((FilePathDisplayable)this.table.getValueAt(selectedRow, 0)).getFilePath());
        }
        return selectedFilePaths;
    }

    @Override
    public VersioningTreeNode getSelectedNode() {
        return null;
    }

    @Override
    public boolean hasSelection() {
        return this.table.getSelectedColumnCount() > 0;
    }

    @Override
    public boolean hasSingleSelection() {
        return this.table.getSelectedColumnCount() == 1;
    }

    @Override
    public Component getUnderlyingComponent() {
        return this.getInternalComponent();
    }

    private class FilePathDisplayable
    implements Displayable {
        private File filePath;

        private FilePathDisplayable(File filePath) {
            this.filePath = filePath;
        }

        public File getFilePath() {
            return this.filePath;
        }

        public String getShortLabel() {
            return this.filePath.getPath();
        }

        public String getLongLabel() {
            return this.getShortLabel();
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return this.getShortLabel();
        }
    }
}

