/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.jdeveloper.vcs.vop.VersionOperationTreePanel;

public class ChangeListTreePanel
extends VersionOperationTreePanel
implements IChangeListPanel {
    private static final String OPENING_BRACKET_DETAILS = " [";
    private static final String CLOSING_BRACKET_DETAILS = "]";
    private static final String DETAILS_SEPARATOR = "; ";
    private static final String OPENING_BRACKET_CONFLICTS = " (";
    private static final String CLOSING_BRACKET_CONFLICTS = ")";
    private static final String PROPERTIES_MODIFIED_TEXT = "properties modified ";
    protected DefaultTreeModel treeModel;
    protected final JTree tree;
    protected List<StorableObjectStatus> statuses;
    protected int conflicts;
    protected DataModelerChangeList changeList;
    private GUIConfiguration conf = GUIConfiguration.getInstance();
    private VersioningTreeNode rootNode = null;
    private VersioningTreeNode designNode = null;
    Map<String, VersioningTreeNode> allNodesMap;
    Map mapByID;

    public ChangeListTreePanel(DataModelerChangeList changeList) {
        this.changeList = changeList;
        this.tree = (JTree)this.getInternalComponent();
        this.init();
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                VersioningTreeNode versioningTreeNode = (VersioningTreeNode)value;
                StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
                Icon icon = versioningTreeNode.getIcon();
                if (icon != null) {
                    if (storableObjectStatus != null) {
                        this.setIcon(ChangeListTreePanel.this.getIconForStatus(storableObjectStatus.getTextStatus(), icon));
                    } else {
                        this.setIcon(icon);
                    }
                }
                if (versioningTreeNode.isConflicted()) {
                    this.setForeground(Color.RED);
                }
                if (storableObjectStatus != null) {
                    String designObjectName = storableObjectStatus.getStorableObjectName();
                    StringBuilder text = new StringBuilder(designObjectName != null ? designObjectName : versioningTreeNode.getUserObject().toString());
                    Long revision = storableObjectStatus.getRevision();
                    String propertyStatus = storableObjectStatus.getPropertyStatus();
                    StringBuilder details = new StringBuilder();
                    if (revision != null) {
                        details.append(String.valueOf(revision));
                    }
                    if ("M".equals(propertyStatus)) {
                        if (details.length() > 0) {
                            details.append(ChangeListTreePanel.DETAILS_SEPARATOR);
                        }
                        details.append(ChangeListTreePanel.PROPERTIES_MODIFIED_TEXT);
                    }
                    if (details.length() > 0) {
                        text.append(ChangeListTreePanel.OPENING_BRACKET_DETAILS).append(details.toString()).append(ChangeListTreePanel.CLOSING_BRACKET_DETAILS);
                    }
                    this.setText(text.toString());
                } else if (ChangeListTreePanel.this.conflicts > 0 && ChangeListTreePanel.this.treeModel.getRoot().equals(versioningTreeNode)) {
                    this.setForeground(Color.RED);
                    this.setText(versioningTreeNode.toString() + ChangeListTreePanel.OPENING_BRACKET_CONFLICTS + ChangeListTreePanel.this.conflicts + ChangeListTreePanel.CLOSING_BRACKET_CONFLICTS);
                }
                return this;
            }
        });
    }

    private Icon getIconForStatus(String status, Icon icon) {
        if ("A".equalsIgnoreCase(status)) {
            return this.conf.getObjectAddedIcon(icon);
        }
        if ("D".equalsIgnoreCase(status)) {
            return this.conf.getObjectDeletedIcon(icon);
        }
        if ("M".equalsIgnoreCase(status)) {
            return this.conf.getObjectModifiedIcon(icon);
        }
        if ("MI".equalsIgnoreCase(status)) {
            return this.conf.getObjectMissingIcon(icon);
        }
        return icon;
    }

    @Override
    public List<StorableObjectStatus> update() {
        return this.update(this.statuses);
    }

    @Override
    public List<StorableObjectStatus> update(List<StorableObjectStatus> statuses) {
        return this.constructTree(statuses);
    }

    protected List<StorableObjectStatus> constructTree(List<StorableObjectStatus> statuses) {
        boolean addDesignNode = false;
        this.init();
        if (statuses != null && statuses.size() > 0) {
            Collections.sort(statuses, StorableObjectStatus.FILE_PATH_COMPARATOR);
            Collections.reverse(statuses);
            for (int i = statuses.size() - 1; i >= 0; --i) {
                StorableObjectStatus storableObjectStatus = statuses.get(i);
                String storableObjectName = storableObjectStatus.getStorableObjectName();
                File filePath = storableObjectStatus.getFilePath();
                File sfile = null;
                Design design = DataModelerChangeList.getSelectedDesign();
                String spath = design.getAppView().getSettings().getDefaultSystemTypesPath();
                if (!"".equals(spath)) {
                    sfile = new File(spath);
                }
                if (design.getDesignPath().equals(filePath.getPath())) {
                    this.findOrCreateRootNode().setStorableObjectStatus(storableObjectStatus);
                    this.tree.setRootVisible(true);
                    continue;
                }
                if (SVNClientHelper.isSystemFile(filePath, sfile)) {
                    String nodeName = storableObjectStatus.getStorableObjectName();
                    VersioningTreeNode aNode = this.findOrCreateNode(storableObjectStatus, storableObjectStatus.getObjectClass(), storableObjectStatus.getPath(), nodeName, filePath, this.findOrCreateRootNode());
                    aNode.setStorableObjectStatus(storableObjectStatus);
                    continue;
                }
                this.findOrCreateDesignNode();
                if (this.addToDesignNode(storableObjectStatus)) {
                    addDesignNode = true;
                    continue;
                }
                statuses.remove(i);
            }
            if (addDesignNode) {
                this.findOrCreateRootNode().add(this.designNode);
            }
        }
        this.treeModel.setRoot(this.rootNode);
        this.statuses = statuses;
        return statuses;
    }

    private VersioningTreeNode findOrCreateRootNode() {
        if (this.rootNode == null) {
            File designPath = new File(DataModelerChangeList.getSelectedDesign().getDesignPath());
            this.rootNode = new VersioningTreeNode(designPath.getName(), designPath);
        }
        return this.rootNode;
    }

    private VersioningTreeNode findOrCreateDesignNode() {
        if (this.designNode == null) {
            this.designNode = new VersioningTreeNode(DataModelerChangeList.getSelectedDesign().getName(), new File(DataModelerChangeList.getSelectedDesign().getStorageName()), Design.class);
        }
        return this.designNode;
    }

    private void init() {
        this.allNodesMap = new HashMap<String, VersioningTreeNode>();
        this.mapByID = new HashMap();
        this.rootNode = null;
        this.designNode = null;
        this.conflicts = 0;
        this.treeModel = new DefaultTreeModel(null);
        this.tree.setModel(this.treeModel);
        this.tree.setRootVisible(false);
    }

    private boolean addToDesignNode(StorableObjectStatus storableObjectStatus) {
        Class objectClass = storableObjectStatus.getObjectClass();
        if (objectClass == null) {
            return false;
        }
        if (Design.class.isAssignableFrom(objectClass)) {
            this.designNode.setStorableObjectStatus(storableObjectStatus);
            return true;
        }
        String nodeName = storableObjectStatus.getStorableObjectName();
        File nodePath = storableObjectStatus.getFilePath();
        VersioningTreeNode aNode = this.findOrCreateNode(storableObjectStatus, objectClass, storableObjectStatus.getPath(), nodeName, nodePath, this.designNode);
        aNode.setStorableObjectStatus(storableObjectStatus);
        if (storableObjectStatus.getTextStatus().equals("C")) {
            ++this.conflicts;
        }
        return true;
    }

    private String convertPath(TreePathHelper[] path, String objectName) {
        String result = "";
        for (int i = 0; i < path.length; ++i) {
            if (i == 0) {
                result = result.concat(path[i].getPathName());
                continue;
            }
            result = result.concat("/");
            String pathName = path[i].getPathName();
            if (pathName == null) continue;
            result = result.concat(pathName);
        }
        if (objectName != null && objectName.length() > 0) {
            result = result.length() > 0 ? result.concat("/").concat(objectName) : result.concat(objectName);
        }
        return result;
    }

    VersioningTreeNode getParentNode(String parentName, String parentID) {
        StorableObjectStatus status;
        VersioningTreeNode node;
        VersioningTreeNode result = null;
        if (parentID != null && (result = this.allNodesMap.get(parentName + parentID)) == null && (node = (VersioningTreeNode)this.mapByID.get(parentID)) != null && (status = node.getStorableObjectStatus()) != null) {
            String parid = status.getStorableObjectParentID();
            return this.getParentNode(parentName, parid);
        }
        return result;
    }

    private VersioningTreeNode findOrCreateNode(StorableObjectStatus storableObjectStatus, Class aClass, TreePathHelper[] path, String aNodeName, File aNodePath, VersioningTreeNode root) {
        String objPath = this.convertPath(path, aNodeName);
        VersioningTreeNode node = null;
        String id = storableObjectStatus.getStorableObjectID();
        String parentID = storableObjectStatus.getStorableObjectParentID();
        if (aClass != null && StorageDesign.class.isAssignableFrom(aClass)) {
            id = null;
        }
        if (id != null) {
            node = this.allNodesMap.get(objPath + id);
        }
        if (node == null) {
            node = this.allNodesMap.get(objPath);
        }
        if (node == null) {
            if (path.length > 0) {
                String parentName = "";
                VersioningTreeNode parentNode = null;
                for (int i = 0; i < path.length; ++i) {
                    VersioningTreeNode aNode;
                    String pathName = path[i].getPathName();
                    if (pathName != null) {
                        parentName = i == 0 ? parentName.concat(pathName) : parentName.concat("/").concat(pathName);
                    }
                    if ((aNode = this.allNodesMap.get(parentName)) == null && parentID != null) {
                        aNode = this.getParentNode(parentName, parentID);
                    }
                    if (aNode == null) {
                        aNode = new VersioningTreeNode(path[i].getPathName(), path[i].getFile(), path[i].getPathClass());
                        this.allNodesMap.put(parentName, aNode);
                        if (parentNode == null) {
                            root.add(aNode);
                        } else {
                            parentNode.add(aNode);
                        }
                        parentNode = aNode;
                        continue;
                    }
                    parentNode = aNode;
                }
                if (parentNode != null) {
                    node = new VersioningTreeNode(aNodeName, aNodePath, aClass);
                    if (id != null) {
                        this.allNodesMap.put(objPath + id, node);
                        this.mapByID.put(id, node);
                        if (aClass != null && RelationalDesign.class.isAssignableFrom(aClass)) {
                            this.allNodesMap.put(objPath + ModelIDObject.getShortID(id), node);
                            this.allNodesMap.put(objPath, node);
                        }
                    } else {
                        this.allNodesMap.put(objPath, node);
                    }
                    parentNode.add(node);
                }
            } else {
                node = new VersioningTreeNode(aNodeName, aNodePath, aClass);
                if (id != null) {
                    this.allNodesMap.put(objPath + id, node);
                    this.mapByID.put(id, node);
                } else {
                    this.allNodesMap.put(objPath, node);
                }
                root.add(node);
            }
        }
        return node;
    }

    @Override
    public List<File> getSelectedFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories) {
        return this.getSelectedFilePaths(treeNodesForRefreshing, recursively, alwaysRecurseDirectories, false);
    }

    public List<File> getSelectedFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories, boolean singleUpdate) {
        TreePath[] selectionPaths = this.getTree().getSelectionPaths();
        if (selectionPaths == null) {
            return this.getAllFilePaths(treeNodesForRefreshing, recursively, alwaysRecurseDirectories);
        }
        ArrayList<File> selectedFilePaths = new ArrayList<File>();
        for (TreePath selectionPath : selectionPaths) {
            VersioningTreeNode treeNode = (VersioningTreeNode)selectionPath.getLastPathComponent();
            if (alwaysRecurseDirectories && treeNode.getFilePath().isDirectory()) {
                recursively = true;
            }
            this.addSelectedFilePath(treeNode, selectedFilePaths, recursively, singleUpdate);
            this.addTreeNodesForRefreshing(treeNode, treeNodesForRefreshing, recursively);
        }
        return selectedFilePaths;
    }

    public List<File> getAllFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories) {
        return this.getAllFilePaths(treeNodesForRefreshing, recursively, alwaysRecurseDirectories, false);
    }

    public List<File> getAllFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories, boolean singleUpdate) {
        ArrayList<File> allFilePaths = new ArrayList<File>();
        VersioningTreeNode root = (VersioningTreeNode)this.treeModel.getRoot();
        VersioningTreeNode node = null;
        if (this.tree.isRootVisible()) {
            node = root;
        } else if (root != null && root.getChildCount() > 0) {
            node = (VersioningTreeNode)root.getFirstChild();
        }
        if (node != null) {
            this.addSelectedFilePath(node, allFilePaths, recursively);
            this.addTreeNodesForRefreshing(node, treeNodesForRefreshing, recursively);
        }
        return allFilePaths;
    }

    public List<File> getAllFilePathsForCommit(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories) {
        ArrayList<File> allFilePaths = new ArrayList<File>();
        VersioningTreeNode root = (VersioningTreeNode)this.treeModel.getRoot();
        VersioningTreeNode node = null;
        if (this.tree.isRootVisible()) {
            node = root;
            if (node != null) {
                this.addSelectedFilePath(node, allFilePaths, recursively);
                this.addTreeNodesForRefreshing(node, treeNodesForRefreshing, recursively);
            }
        } else if (root != null && root.getChildCount() > 0) {
            for (node = (VersioningTreeNode)root.getFirstChild(); node != null; node = (VersioningTreeNode)node.getNextSibling()) {
                this.addSelectedFilePath(node, allFilePaths, recursively);
                this.addTreeNodesForRefreshing(node, treeNodesForRefreshing, recursively);
            }
        }
        return allFilePaths;
    }

    protected void addSelectedFilePath(VersioningTreeNode versioningTreeNode, List<File> selectedFilePaths, boolean recursively) {
        this.addSelectedFilePath(versioningTreeNode, selectedFilePaths, recursively, false);
    }

    protected void addSelectedFilePath(VersioningTreeNode versioningTreeNode, List<File> selectedFilePaths, boolean recursively, boolean singleUpdate) {
        selectedFilePaths.add(versioningTreeNode.getFilePath());
        if (recursively) {
            if (!singleUpdate) {
                this.addDependantFilePath(versioningTreeNode, selectedFilePaths);
            }
            for (int i = 0; i < versioningTreeNode.getChildCount(); ++i) {
                this.addSelectedFilePath((VersioningTreeNode)versioningTreeNode.getChildAt(i), selectedFilePaths, recursively);
            }
        }
    }

    private void addDependantFilePath(VersioningTreeNode versioningTreeNode, List<File> selectedFilePaths) {
        File dependantFilePath = versioningTreeNode.getDependantFilePath();
        if (dependantFilePath != null) {
            selectedFilePaths.add(dependantFilePath);
        }
    }

    protected void addTreeNodesForRefreshing(VersioningTreeNode versioningTreeNode, List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively) {
        if (versioningTreeNode.getStorableObjectStatus() != null) {
            treeNodesForRefreshing.add(versioningTreeNode);
        }
        if (recursively) {
            for (int i = 0; i < versioningTreeNode.getChildCount(); ++i) {
                this.addTreeNodesForRefreshing((VersioningTreeNode)versioningTreeNode.getChildAt(i), treeNodesForRefreshing, recursively);
            }
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public List<StorableObjectStatus> getStatuses() {
        return this.statuses;
    }

    @Override
    public VersioningTreeNode getSelectedNode() {
        return (VersioningTreeNode)this.tree.getLastSelectedPathComponent();
    }

    @Override
    public boolean hasSelection() {
        TreePath[] selection = this.tree.getSelectionPaths();
        return selection != null;
    }

    @Override
    public boolean hasSingleSelection() {
        TreePath[] selection = this.tree.getSelectionPaths();
        return selection != null && selection.length == 1;
    }

    @Override
    public Component getUnderlyingComponent() {
        return this.getInternalComponent();
    }
}

