/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChangeListTreePanel;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.UpdateableAction;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOSGiController;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNAddPropertyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionHistoryCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNViewPropertiesCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.vop.BaseVersionOperationPanel;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;

public abstract class DataModelerChangeList
extends AsynchronousChangeList {
    private static final Logger LOGGER = new Logger(DataModelerChangeList.class);
    protected IChangeListPanel panel;
    protected DataModelerChangeListWindow window;
    protected DataModelerChangeList dependantChangeList;
    protected DataModelerChangeList secondDependantChangeList;
    protected boolean autoRefreshDependantChangeList;
    protected boolean autoRefreshSecondDependantChangeList;
    protected boolean refreshWhenNotVisible;
    protected JPopupMenu popupMenu;
    protected static final JComboBox scopeComboBox = DataModelerChangeList.createScopeComboBox();
    private static final String OPENING_BRACKET_CONFLICTS = " (";
    private static final String CLOSING_BRACKET_CONFLICTS = ")";
    boolean versionedOnly = true;

    public DataModelerChangeList(String modeId) {
        super((Object)modeId);
        this.addScopeComboBoxListener();
        BaseVersionOperationPanel panel = (BaseVersionOperationPanel)this.createChangeListPanel();
        this.initializeVersionOperationPanel(panel);
        this.layoutPanel(panel);
        this.installPopupMenu();
    }

    protected IChangeListPanel createChangeListPanel() {
        this.panel = new ChangeListTreePanel(this);
        return this.panel;
    }

    protected void installPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.addActions();
        IdeAction defaultCompareAction = this.addCompareActions();
        this.addAdditionalActions();
        this.addPopupMenu(this.getPanel(), this.popupMenu, defaultCompareAction);
    }

    public void addPopupMenu(final IChangeListPanel changeListPanel, final JPopupMenu popupMenu, final IdeAction defaultAction) {
        changeListPanel.getUnderlyingComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && changeListPanel.hasSelection()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DataModelerChangeList.this.updateActions(popupMenu);
                if (e.isPopupTrigger() && changeListPanel.hasSelection()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        if (defaultAction != null && defaultAction.isEnabled()) {
                            defaultAction.performAction();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn(ex);
                    }
                }
            }
        });
    }

    private void updateActions(JPopupMenu menu) {
        for (int i = 0; i < menu.getComponents().length; ++i) {
            Action action;
            Component component = menu.getComponents()[i];
            if (component instanceof JMenu) {
                this.updateActions(((JMenu)component).getPopupMenu());
                continue;
            }
            if (!(component instanceof JMenuItem) || (action = ((JMenuItem)component).getAction()) == null) continue;
            if (action instanceof IdeAction) {
                ((IdeAction)action).updateAction();
                continue;
            }
            if (!(action instanceof UpdateableAction)) continue;
            ((UpdateableAction)action).update();
        }
    }

    protected void addAdditionalActions() {
        IdeAction action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"DataModelingAddin.VersionHistory"));
        if (action != null) {
            action.setCommand(SVNVersionHistoryCommand.COMMAND_ID);
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"version_history.png"));
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
        if ((action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"DataModelingAddin.ViewSubversionProperties"))) != null) {
            action.setCommand(SVNViewPropertiesCommand.COMMAND_ID);
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"properties.png"));
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
        if ((action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"DataModelingAddin.AddSubversionProperty"))) != null) {
            action.setCommand(SVNAddPropertyCommand.COMMAND_ID);
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"propertyadd.png"));
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
        if ((action = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand"))) != null) {
            action.setCommand("oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand");
            action.setName(Messages.getString("DataModelingAddin.StorableObjectProperties"));
            action.putValue("SmallIcon", (Object)VCSIconArb.getIcon((String)"file.png"));
            DMSVNOSGiController.getInstance().register(action, (Command)new StorableObjectPropertiesCommand());
            this.popupMenu.addSeparator();
            this.popupMenu.add(Ide.getMenubar().createMenuItem((ToggleAction)action));
        }
    }

    protected abstract void addActions();

    protected abstract IdeAction addCompareActions();

    public abstract void clear();

    protected abstract ChangeListStatus[] getChangeListStatuses();

    public boolean isRefreshWhenNotVisible() {
        return this.refreshWhenNotVisible;
    }

    public void setRefreshWhenNotVisible(boolean refreshWhenNotVisible) {
        this.refreshWhenNotVisible = refreshWhenNotVisible;
    }

    public DataModelerChangeList getDependantChangeList() {
        return this.dependantChangeList;
    }

    public void setDependantChangeList(DataModelerChangeList dependantChangeList) {
        this.dependantChangeList = dependantChangeList;
    }

    public boolean isAutoRefreshDependantChangeList() {
        return this.autoRefreshDependantChangeList;
    }

    public void setAutoRefreshDependantChangeList(boolean autoRefreshDependantChangeList) {
        this.autoRefreshDependantChangeList = autoRefreshDependantChangeList;
    }

    public DataModelerChangeListWindow getWindow() {
        return this.window;
    }

    public void setWindow(DataModelerChangeListWindow window) {
        this.window = window;
    }

    protected ChangeListEventQueue createEventQueue() {
        return null;
    }

    protected void initializeChangeList() {
        this.setVisibleStatuses(this.getChangeListStatuses());
    }

    public void updateUI(List<StorableObjectStatus> statuses) {
        List<StorableObjectStatus> recognizedStatuses = this.getPanel().update(statuses);
        this.initializeModel();
        MutableVersionOperationModel model = this.getModel();
        if (model != null) {
            this.setToolTipText("");
            if (recognizedStatuses != null && !recognizedStatuses.isEmpty()) {
                try {
                    model.add(recognizedStatuses);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.firePropertyChange("changeListCount", model.getItems().length == 0 ? 1 : 0, model.getItems().length);
        }
    }

    public IChangeListPanel getPanel() {
        return this.panel;
    }

    protected void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        this.addScopeComboBox(toolbar);
    }

    protected void addScopeComboBox(Toolbar toolbar) {
        if (toolbar.getComponentCount() > 0) {
            toolbar.add((Component)toolbar.newSeparator(), 0);
        }
        toolbar.add((Component)scopeComboBox, 0);
    }

    protected static JComboBox createScopeComboBox() {
        JComboBox<Object> scopeComboBox = new JComboBox<Object>();
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Design design = (Design)value;
                if (design != null) {
                    String folder = new File(design.getStorageName()).getParent();
                    this.setText(design.getName() + DataModelerChangeList.OPENING_BRACKET_CONFLICTS + folder + DataModelerChangeList.CLOSING_BRACKET_CONFLICTS);
                }
                return this;
            }
        };
        scopeComboBox.setRenderer(renderer);
        Dimension d = new Dimension(SwingUtilities.computeStringWidth(renderer.getFontMetrics(renderer.getFont()), "ReasonablyLongApplicationNameWithIconIncludingItsLocation.jws"), scopeComboBox.getPreferredSize().height);
        scopeComboBox.setMaximumSize(d);
        scopeComboBox.setMinimumSize(d);
        return scopeComboBox;
    }

    protected void addScopeComboBoxListener() {
        scopeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    DataModelerChangeList.this.clear();
                } else if (e.getStateChange() == 1 && DataModelerChangeList.this.isVisible()) {
                    DataModelerChangeList.this.refresh();
                }
            }
        });
    }

    protected void startImpl() {
    }

    public JComboBox getScopeComboBox() {
        return scopeComboBox;
    }

    public static Design getSelectedDesign() {
        return (Design)scopeComboBox.getSelectedItem();
    }

    protected JMenu createCompareWithMenu(JPopupMenu popupMenu) {
        popupMenu.addSeparator();
        JMenu compareWithMenu = new JMenu(Messages.getString("DataModelingAddin.CompareWith"));
        popupMenu.add(compareWithMenu);
        return compareWithMenu;
    }

    public boolean isVersionedOnly() {
        return this.versionedOnly;
    }

    public void setVersionedOnly(boolean versionedOnly) {
        this.versionedOnly = versionedOnly;
    }

    public DataModelerChangeList getSecondDependantChangeList() {
        return this.secondDependantChangeList;
    }

    public void setSecondDependantChangeList(DataModelerChangeList secondDependantChangeList) {
        this.secondDependantChangeList = secondDependantChangeList;
    }

    public boolean isAutoRefreshSecondDependantChangeList() {
        return this.autoRefreshSecondDependantChangeList;
    }

    public void setAutoRefreshSecondDependantChangeList(boolean autoRefreshSecondDependantChangeList) {
        this.autoRefreshSecondDependantChangeList = autoRefreshSecondDependantChangeList;
    }
}

